<?php
if (!defined('UAP_CORE') && !defined('ABSPATH')) exit;
class leform_front_class {
	var $test = '1';
	function __construct() {
		global $leform;
		if (is_admin()) {
		} else {
			add_action('init', array(&$this, 'init'), 15);
			add_action('wp', array(&$this, 'front_init'), 15);
			add_shortcode('leform', array(&$this, "shortcode_handler"));
			add_shortcode('leform-dl', array(&$this, "shortcode_dl_handler"));
		}
	}

	function front_init() {
		add_action('wp_enqueue_scripts', array(&$this, 'front_enqueue_scripts'), 99);
		add_action('wp_head', array(&$this, 'front_header'), 15);
		add_action('wp_footer', array(&$this, 'front_footer'), 999);
	}

	function front_enqueue_scripts() {
		global $leform;
		if ($leform->advanced_options['minified-sources'] == 'on') $min = '.min';
		else $min = '';
		wp_enqueue_script("jquery");
		wp_enqueue_style('leform-style', $leform->plugins_url.'/css/style'.$min.'.css', array(), LEFORM_VERSION);
		wp_enqueue_script('leform', $leform->plugins_url.'/js/leform'.$min.'.js', array('jquery'), LEFORM_VERSION, true);
		if ($leform->options['fa-enable'] == 'on') {
			if ($leform->options['fa-css-disable'] != 'on') {
				if ($leform->options['fa-solid-enable'] == 'on' && $leform->options['fa-regular-enable'] == 'on' && $leform->options['fa-brands-enable'] == 'on') wp_enqueue_style('leform-font-awesome-all', $leform->plugins_url.'/css/fontawesome-all'.$min.'.css', array(), LEFORM_VERSION);
				else {
					wp_enqueue_style('leform-font-awesome-all', $leform->plugins_url.'/css/fontawesome'.$min.'.css', array(), LEFORM_VERSION);
					if ($leform->options['fa-solid-enable'] == 'on') wp_enqueue_style('leform-font-awesome-solid', $leform->plugins_url.'/css/fontawesome-solid'.$min.'.css', array(), LEFORM_VERSION);
					if ($leform->options['fa-regular-enable'] == 'on') wp_enqueue_style('leform-font-awesome-regular', $leform->plugins_url.'/css/fontawesome-regular'.$min.'.css', array(), LEFORM_VERSION);
					if ($leform->options['fa-brands-enable'] == 'on') wp_enqueue_style('leform-font-awesome-brands', $leform->plugins_url.'/css/fontawesome-brands'.$min.'.css', array(), LEFORM_VERSION);
				}
			}
		} else wp_enqueue_style('leform-fa', $leform->plugins_url.'/css/leform-fa'.$min.'.css', array(), LEFORM_VERSION);
		if ($leform->options['airdatepicker-enable'] == 'on') {
			if ($leform->options['airdatepicker-js-disable'] != 'on') {
				wp_enqueue_style('airdatepicker', $leform->plugins_url.'/css/airdatepicker'.$min.'.css', array(), LEFORM_VERSION);
				wp_enqueue_script('airdatepicker', $leform->plugins_url.'/js/airdatepicker'.$min.'.js', array('jquery'), LEFORM_VERSION, true);
			}
		}
		if ($leform->options['jsep-enable'] == 'on') {
			if ($leform->options['jsep-js-disable'] != 'on') {
				wp_enqueue_script('jsep', $leform->plugins_url.'/js/jsep'.$min.'.js', array('leform'), LEFORM_VERSION, true);
			}
		}
		if ($leform->options['mask-enable'] == 'on') {
			if ($leform->options['mask-js-disable'] != 'on') {
				wp_enqueue_script('jquery.mask', $leform->plugins_url.'/js/jquery.mask'.$min.'.js', array('jquery'), LEFORM_VERSION, true);
			}
		}		
		do_action('leform_wp_enqueue_scripts');
	}

	function init() {
		global $wpdb, $leform;
		if (array_key_exists('leform-confirm', $_REQUEST)) {
			$confirmation_id = preg_replace('/[^a-zA-Z0-9-]/', '', $_REQUEST['leform-confirm']);
			$message = esc_html__('Invalid confirmation URL.', 'leform');
			$forms = '';
			if (!empty($confirmation_id)) {
				$record_details = $wpdb->get_row("SELECT t1.*, t2.name AS form_name, t2.options AS form_options, t2.elements AS form_elements FROM ".$wpdb->prefix."leform_records t1 LEFT JOIN ".$wpdb->prefix."leform_forms t2 ON t2.id = t1.form_id WHERE t1.deleted = '0' AND t1.str_id = '".esc_sql($confirmation_id)."'", ARRAY_A);
				if ($record_details) {
					if ($record_details['status'] == LEFORM_RECORD_STATUS_CONFIRMED) {
						$message = esc_html__('Email address already confirmed.', 'leform');
					} else {
						if (!class_exists("leform_form")) include_once(dirname(__FILE__).'/core-form.php');
						$form_object = new leform_form(intval($record_details['form_id']));
						if (empty($form_object->id)) {
							$message = esc_html__('Relevant form not found.', 'leform');
						} else {
							$form_object->form_data = json_decode($record_details['fields'], true);
							$form_object->form_info = json_decode($record_details['info'], true);
							
							$datestamp = date('Ymd');
							$timestamp = date('h');
							$stats_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_stats WHERE form_id = '".esc_sql($form_object->id)."' AND datestamp = '".esc_sql($datestamp)."' AND timestamp = '".esc_sql($timestamp)."'", ARRAY_A);
							if (!empty($stats_details)) {
								$wpdb->query("UPDATE ".$wpdb->prefix."leform_stats SET confirmed = confirmed + 1 WHERE id = '".esc_sql($stats_details['id'])."'");
							} else {
								$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_stats (form_id, impressions, submits, confirmed, payments, datestamp, timestamp, deleted) VALUES ('".esc_sql($form_object->id)."', '0', '0', '1', '0', '".esc_sql($datestamp)."', '".esc_sql($timestamp)."', '0')");
							}
							$wpdb->query("UPDATE ".$wpdb->prefix."leform_records SET status = '".esc_sql(LEFORM_RECORD_STATUS_CONFIRMED)."' WHERE id = '".esc_sql($record_details['id'])."'");

							$form_object->do_notifications("confirm");
							$integrations_data = $form_object->do_integrations("confirm");
							if (array_key_exists('forms', $integrations_data)) $forms = implode('', $integrations_data['forms']);
							do_action('leform_confirmed', $form_object);
							
							$message = $form_object->replace_shortcodes($form_object->form_options['double-message']);
							if (!empty($form_object->form_options['double-url'])) {
								$url = $form_object->replace_shortcodes($form_object->form_options['double-url'], array(), true);
								header('Location: '.$url);
								exit;
							}
						}
					}
				}
			}
			echo '<!DOCTYPE html>
<html>
<head>
	<meta name="robots" content="noindex, nofollow, noarchive, nosnippet">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<title>'.esc_html__('Confirmation', 'leform').'</title>
	<link href="//fonts.googleapis.com/css?family=Open+Sans:400,300&subset=latin,cyrillic-ext,greek-ext,latin-ext,cyrillic,greek,vietnamese" rel="stylesheet" type="text/css">
	<link href="'.$leform->plugins_url.'/css/tiny-content.css" rel="stylesheet" type="text/css">
	<style>
	body {font-family: "Open Sans", "Helvetica Neue", Helvetica, Arial, sans-serif; font-weight: 100; color: #444; background-color: #fff; line-height: 1.475;}
	.front-container {position: absolute;top: 0;right: 0;bottom: 0;left: 0;min-width: 240px;height: 100%;display: table;width: 100%;}
	.front-content {max-width: 1024px;margin: 0px auto;padding: 20px 0;position: relative;display: table-cell;text-align: center;vertical-align: middle;}
	</style>
</head>
<body>
	<div class="front-container">
		<div class="front-content">
			'.$message.'
		</div>
	</div>'.(empty($forms) ? '' : $forms.'
	<script>
		var buttons = document.getElementsByClassName("leform-send");
		for (var i=0; i<buttons.length; i++) {
			buttons[i].click();
		}
	</script>').'
</body>
</html>';
			exit;
		} else if (array_key_exists('leform-dl', $_REQUEST) && defined('LEFORM_ALLOW_FORM_EXPORT') && LEFORM_ALLOW_FORM_EXPORT === true) {
			$form_id = intval($_REQUEST["leform-dl"]);
			$export = $leform->export($form_id);
		}
	}

	function front_header() {
		global $wpdb, $leform;
		echo '
<script>var leform_customjs_handlers = {};</script>';
	}

	static function front_footer() {
		global $wpdb, $leform;
		$forms = $wpdb->get_results("SELECT * FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0' AND active = '1'", ARRAY_A);
		$default_form_options = $leform->default_form_options();
		$overlays = "";
		foreach ($forms as $form_details) {
			$form_options = json_decode($form_details['options'], true);
			if (!empty($form_options) && is_array($form_options)) $form_options = array_merge($default_form_options, $form_options);
			else $form_options = $default_form_options;
			$overlays .= '"leform-'.$form_details['id'].'":["'.(empty($form_options['popup-overlay-color']) ? 'rgba(0,0,0,0.7)' : $form_options['popup-overlay-color']).'","'.(empty($form_options["popup-spinner-color-color1"]) ? '#FF5722' : $form_options["popup-spinner-color-color1"]).'","'.(empty($form_options["popup-spinner-color-color2"]) ? '#FF9800' : $form_options["popup-spinner-color-color2"]).'","'.(empty($form_options["popup-spinner-color-color3"]) ? '#FFC107' : $form_options["popup-spinner-color-color3"]).'"],';
		}
		$overlays .= '"none":["","","",""]';
		echo '
<script>
	var leform_ajax_url = "'.admin_url('admin-ajax.php').'";
	var leform_overlays = {'.$overlays.'};
	var leform_ga_tracking = "'.$leform->options['ga-tracking'].'";
</script>';
	}

	static function shortcode_handler($_atts) {
		global $post, $wpdb, $leform;
		if (is_feed()) {
			if (isset($_atts['feed'])) {
				return '<div>'.$_atts['feed'].'</div>';
			} else return '';
		}
		if (!isset($_atts['id']) || empty($_atts['id'])) return '';
		$preview = false;
		if (array_key_exists('preview', $_atts) && $_atts['preview'] == true) $preview = true;
		if (!class_exists("leform_form")) include_once(dirname(__FILE__).'/core-form.php');
		$form_object = new leform_form(intval($_atts['id']), $preview);
		$form = $form_object->get_form_html();
		if ($form === false) return '';
		if (!empty($form_object->form_options['max-width-value'])) {
			$style_attr = ' style="max-width:'.esc_html($form_object->form_options['max-width-value'].$form_object->form_options['max-width-unit']).';margin: 0 '.(($form_object->form_options['max-width-position'] == 'center' || $form_object->form_options['max-width-position'] == 'left') ? 'auto' : '0').' 0 '.(($form_object->form_options['max-width-position'] == 'center' || $form_object->form_options['max-width-position'] == 'right') ? 'auto' : '0').';"';
		} else $style_attr = '';
		if (array_key_exists('dl', $_atts) && $_atts['dl'] == 'on' && defined('LEFORM_ALLOW_FORM_EXPORT') && LEFORM_ALLOW_FORM_EXPORT === true) {
			$dl = '<div class="leform-dl"'.esc_html($style_attr).'><a href="'.rtrim(get_bloginfo('url'), '/').'/?leform-dl='.intval($_atts['id']).'" rel="nofollow"><i class="fas fa-download"></i> '.esc_html__('Download Form', 'leform').'</a></div>';
		} else $dl = '';
		return $form['style'].$dl.'<div class="leform-inline leform-container"'.$style_attr.'>'.$form['html'].'</div>';
	}
	function widgets_init() {
		include_once(dirname(dirname(__FILE__)).'/widget.php');
		register_widget('leform_widget');
	}
}
?>