<?php
if (!defined('UAP_CORE') && !defined('ABSPATH')) exit;
class leform_admin_class {
	var $list_table;
	var $success_message = '';
	var $error_message = '';
	function __construct() {
		global $leform;
		if (is_admin()) {
			$version = get_option('leform-version');
			$webfonts_version = get_option('leform-webfonts-version', 0);
			if (($version && $version < LEFORM_VERSION) || $webfonts_version < LEFORM_WEBFONTS_VERSION) {
				add_action('admin_notices', array(&$this, 'admin_warning'));
			}
			
			add_action('admin_enqueue_scripts', array(&$this, 'admin_enqueue_scripts'));
			add_action('admin_head', array(&$this, 'admin_head'));
			add_action('admin_menu', array(&$this, 'admin_menu'), 1);
			add_action('admin_init', array(&$this, 'admin_init'));

			add_filter('pre_set_site_transient_update_plugins', array(&$this, 'check_for_plugin_update'));
			add_filter('plugins_api', array(&$this, 'plugin_api_call'), 10, 3);
		}
	}
	
	function admin_warning() {
		echo '
		<div class="error leform-error leform-error-animated"><p>'.sprintf(esc_html__('IMPORTANT! Please deactivate and activate "Green Forms" plugin %shere%s! It is necessary to sync database for additional functionality', 'leform'), '<a href="'.admin_url('plugins.php').'">', '</a>').'</p></div>';
	}

	function admin_enqueue_scripts() {
		global $leform;
		wp_enqueue_script("jquery");
		wp_enqueue_style('leform', $leform->plugins_url.'/css/admin.css', array(), LEFORM_VERSION);
		wp_enqueue_script('leform', $leform->plugins_url.'/js/admin.js', array('jquery'), LEFORM_VERSION);
		wp_enqueue_style('leform-front', $leform->plugins_url.'/css/style.css', array(), LEFORM_VERSION);
		wp_enqueue_style('qtip2', $leform->plugins_url.'/css/jquery.qtip.min.css', array(), LEFORM_VERSION);
		wp_enqueue_script('qtip2', $leform->plugins_url.'/js/jquery.qtip.min.js', array('jquery'), LEFORM_VERSION);
		if (array_key_exists('page', $_GET) && ($_GET['page'] == 'leform' || substr($_GET['page'], 0, strlen('leform-')) == 'leform-')) {
			wp_enqueue_style('leform-fa', $leform->plugins_url.'/css/leform-fa.css', array(), LEFORM_VERSION);
			wp_enqueue_style('leform-if', $leform->plugins_url.'/css/leform-if.css', array(), LEFORM_VERSION);
			wp_enqueue_style('font-awesome-5.7.2', $leform->plugins_url.'/css/fontawesome-all.min.css', array(), LEFORM_VERSION);
			wp_enqueue_style('material-icons-3.0.1', $leform->plugins_url.'/css/material-icons.css', array(), LEFORM_VERSION);
			wp_enqueue_style('airdatepicker', $leform->plugins_url.'/css/airdatepicker.css', array(), LEFORM_VERSION);
			wp_enqueue_script('airdatepicker', $leform->plugins_url.'/js/airdatepicker.js', array('jquery'), LEFORM_VERSION);
			wp_enqueue_script('chart.js', $leform->plugins_url.'/js/chart.min.js', array(), LEFORM_VERSION);
			wp_enqueue_script('jquery.mask', $leform->plugins_url.'/js/jquery.mask.min.js', array('jquery'), LEFORM_VERSION);
			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-draggable');
			wp_enqueue_script('jquery-ui-resizable');
			wp_enqueue_script('jquery-ui-sortable');
			wp_enqueue_script('jquery-ui-slider');
			wp_enqueue_style('minicolors', $leform->plugins_url.'/css/jquery.minicolors.css', array(), LEFORM_VERSION);
			wp_enqueue_script('minicolors', $leform->plugins_url.'/js/jquery.minicolors.js', array('jquery'), LEFORM_VERSION, true);
			wp_enqueue_media();
			wp_enqueue_editor();
		}
	}
	
	function admin_head() {
		global $leform, $wpdb;
		$sql = "SELECT id, name, active FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0' ORDER BY id DESC";
		$rows = $wpdb->get_results($sql, ARRAY_A);
		
		$gettingstarted_steps = array(
			"create-form" => array(
				array(
					"selector"	=> ".leform-toolbar",
					"class"		=> "bottom-left",
					"style"		=> "margin-top:10px;margin-left:50px;min-width:530px;",
					"text"		=> esc_html__('Add input field or any other element to the form by clicking relevant button on Elements Toolbar.', 'leform')
				),
				array (
					"selector"	=> ".leform-header-settings",
					"class"		=> "left",
					"style"		=> "top:-25px;left:60px;min-width:530px;",
					"text"		=> esc_html__('Click this button to check and adjust form settings (styles, notifications, integrations, payments, etc.).', 'leform')
				),
				array (
					"selector"	=> ".leform-pages-bar",
					"class"		=> "bottom-left",
					"style"		=> "margin-top:10px;margin-left:60px;",
					"text"		=> esc_html__('Add pages (steps) to create multi-step forms.', 'leform')
				),
				array (
					"selector"	=> ".leform-header-save",
					"class"		=> "bottom-right",
					"style"		=> "margin-top:10px;margin-right:50px;min-width:400px;",
					"text"		=> esc_html__('Save changes by clicking this button.', 'leform')
				)
			),
			"form-saved" => array(
				array (
					"selector"	=> ".leform-header-preview",
					"class"		=> "bottom-right",
					"style"		=> "margin-top:0px;margin-right:20px;min-width:400px;",
					"text"		=> esc_html__('Click this button to preview the form.', 'leform')
				),
				array (
					"selector"	=> ".leform-header-using",
					"class"		=> "bottom-right",
					"style"		=> "margin-top:0px;margin-right:20px;min-width:400px;",
					"text"		=> esc_html__('Click this button and check how to use or embed the form.', 'leform')
				)
			),
			"element-properties" => array(
				array(
					"selector"	=> "#leform-form-1",
					"class"		=> "bottom-left",
					"style"		=> "margin-top:10px;margin-left:50px;",
					"text"		=> esc_html__('Click mouse right button over element to access its properties.', 'leform')
				)
			)
		);
		echo '
<script>
	var leform_ajax_handler = "'.admin_url('admin-ajax.php').'";var leform_plugin_url = "'.$leform->plugins_url.'"; var leform_forms_encoded = "'.base64_encode(json_encode($rows)).'"; var leform_gettingstarted_enable = "'.$leform->options['gettingstarted-enable'].'"; var leform_gettingsstarted_encoded = "'.base64_encode(json_encode($gettingstarted_steps)).'";
	leform_gettingstarted_steps = JSON.parse(leform_decode64(leform_gettingsstarted_encoded));
</script>';
	}

	function admin_menu() {
		global $leform;
		if ($leform->demo_mode) {
			$cap = "read";
		} else $cap = "manage_options";
		add_menu_page(
			"Green Forms"
			, "Green Forms"
			, $cap
			, "leform"
			, array(&$this, 'admin_forms')
			, 'none'
			, 55
		);
		add_submenu_page(
			"leform"
			, esc_html__('Forms', 'leform')
			, esc_html__('Forms', 'leform')
			, $cap
			, "leform"
			, array(&$this, 'admin_forms')
		);
		add_submenu_page(
			"leform"
			, esc_html__('Create Form', 'leform')
			, esc_html__('Create Form', 'leform')
			, $cap
			, "leform-add"
			, array(&$this, 'admin_add_form')
		);
		add_submenu_page(
			"leform"
			, esc_html__('Log', 'leform')
			, esc_html__('Log', 'leform')
			, $cap
			, "leform-log"
			, array(&$this, 'admin_records')
		);
		add_submenu_page(
			"leform"
			, esc_html__('Stats', 'leform')
			, esc_html__('Stats', 'leform')
			, $cap
			, "leform-stats"
			, array(&$this, 'admin_stats')
		);
		add_submenu_page(
			"leform"
			, esc_html__('Field Analytics', 'leform')
			, esc_html__('Field Analytics', 'leform')
			, $cap
			, "leform-field-analytics"
			, array(&$this, 'admin_field_analytics')
		);
		add_submenu_page(
			"leform"
			, esc_html__('Transactions', 'leform')
			, esc_html__('Transactions', 'leform')
			, $cap
			, "leform-transactions"
			, array(&$this, 'admin_transactions')
		);
		do_action('leform_admin_menu');
		add_submenu_page(
			"leform"
			, esc_html__('Settings', 'leform')
			, esc_html__('Settings', 'leform')
			, $cap
			, "leform-settings"
			, array(&$this, 'admin_settings')
		);
		if (defined('UAP_CORE')) {
			add_submenu_page(
				"leform"
				, esc_html__('How To Use', 'leform')
				, esc_html__('How To Use', 'leform')
				, $cap
				, "leform-using"
				, array(&$this, 'admin_using')
			);
		}
	}

	function admin_using() {
		global $wpdb, $leform;
		echo '
		<div class="wrap leform-admin leform">
			<h2>'.esc_html__('Green Forms - How To Use', 'leform').'
				<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/standalone-script-documentation/' : 'https://greenforms.pro/documentation/').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
			</h2>
			<div class="leform-settings leform-using-page">
				<h3>'.esc_html__('Embedding Green Forms', 'leform').'</h3>
				<p>'.esc_html__('To embed Green Forms into any website you need perform the following steps:', 'leform').'</p>
				<ol>
					<li>
						<span>'.sprintf(esc_html__('Make sure that website has %sDOCTYPE%s. If not, add the following line as a first line of HTML-document:', 'leform'), '<code>', '</code>').'</span>
						<input type="text" readonly="readonly" value="'.esc_html('<!DOCTYPE html>').'" onclick="this.focus();this.select();" />
					</li>
					<li>
						<span>'.sprintf(esc_html__('Make sure that website loads jQuery version 1.9 or higher. If not, add the following line into %shead%s section of HTML-document:', 'leform'), '<code>', '</code>').'</span>
						<input type="text" readonly="readonly" value="'.esc_html('<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>').'" onclick="this.focus();this.select();" />
					</li>
					<li>
						<span>'.sprintf(esc_html__('Copy the following JS-snippet and paste it into website code. You need paste it at the end of %sbody%s section (above closing %s</body>%s tag).', 'leform'), '<code>', '</code>', '<code>', '</code>').'</span>
						<input type="text" readonly="readonly" value="'.esc_html('<script id="leform-remote" src="'.$leform->plugins_url.'/js/leform'.($leform->advanced_options['minified-sources'] == 'on' ? '.min' : '').'.js?ver='.LEFORM_VERSION.'" data-handler="'.admin_url('admin-ajax.php').'"></script>').'" onclick="this.focus();this.select();" />
					</li>
					<li>
						<span>'.esc_html__('Integration finished!', 'leform').'</span>
					</li>
				</ol>
			</div>
			<div class="leform-settings leform-using-page">
				<h3>'.esc_html__('Using Green Forms', 'leform').'</h3>
				<p>'.esc_html__('You can insert forms as regular inline forms or/and raise them as popups.', 'leform').'</p>
				<ol>
					<li>
						<span>'.esc_html__('Use the following HTML-code to embed the form into HTML-document as inline form:', 'leform').'</span>
						<input type="text" readonly="readonly" value="'.esc_html('<div class="leform-inline" data-id="{FORM-ID}"></div>').'" onclick="this.focus();this.select();" />
					</li>
					<li>
						<span>'.esc_html__('Use the following URL with a link/button (href attribute) to open the form in popup mode:', 'leform').'</span>
						<input type="text" readonly="readonly" value="#leformx-{FORM-ID}" onclick="this.focus();this.select();" />
					</li>
					<li>
						<span>'.esc_html__('Use the following javascript function to open the form in popup mode:', 'leform').'</span>
						<input type="text" readonly="readonly" value="leform_popup_open({FORM-ID});" onclick="this.focus();this.select();" />
					</li>
				</ol>
				<p>'.sprintf(esc_html__('Replace {FORM-ID} by real Form ID. You can find Form ID by clicking %s icon on %sForms%s page.', 'leform'), '<i class="fas fa-code" style="font-size: 20px;"></i>', '<a href="?page=leform">', '</a>').'</p>
			</div>
		</div>';
	}
	
	function admin_settings() {
		global $wpdb, $leform;
		if (isset($_GET['subpage']) && $_GET['subpage'] == 'advanced') {
			$this->admin_advanced_settings();
			return;
		}
		echo '
<div class="wrap leform-admin leform">
	<h2>'.esc_html__('Green Forms - General Settings', 'leform').'
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/standalone-script-documentation/' : 'https://greenforms.pro/documentation/').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>
	<div class="leform-tabs leform-tabs-main">
		<a class="leform-tab leform-tab-active" href="'.admin_url('admin.php').'?page=leform-settings">'.esc_html__('General', 'leform').'</a>
		<a class="leform-tab" href="'.admin_url('admin.php').'?page=leform-settings&subpage=advanced">'.esc_html__('Advanced', 'leform').'</a>
	</div>
	<form class="leform-settings-form" enctype="multipart/form-data" method="post" style="margin: 0px" action="'.admin_url('admin.php').'">
		<div class="leform-settings" style="position: relative;">
			<h3>'.esc_html__('Mailing Settings', 'leform').'</h3>
			<table class="leform-useroptions">
				<tr>
					<th>'.esc_html__('Sender name', 'leform').':</th>
					<td>
						<input type="text" id="leform-from-name" name="leform-from-name" value="'.esc_html($leform->options['from-name']).'" class="widefat" />
						<br /><em>'.esc_html__('Please enter sender name. All messages from plugin are sent using this name as "FROM:" header value.', 'leform').'</a></em>.
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('Sender email', 'leform').':</th>
					<td>
						<input type="text" id="leform-from-email" name="leform-from-email" value="'.esc_html($leform->options['from-email']).'" class="widefat" />
						<br /><em>'.esc_html__('Please enter sender e-mail. All messages from plugin are sent using this e-mail as "FROM:" header value.', 'leform').'</a></em>.
					</td>
				</tr>
			</table>
			<h3>'.esc_html__('Miscellaneous', 'leform').'</h3>
			<table class="leform-useroptions">
				<tr>
					<th>'.esc_html__('GA tracking', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-ga-tracking" name="leform-ga-tracking" '.($leform->options['ga-tracking'] == "on" ? 'checked="checked"' : '').' /><label for="leform-ga-tracking"></label><span>'.esc_html__('Enable Google Analytics tracking', 'leform').'</span>
						<br /><em>'.esc_html__('Send form submission event to Google Analytics. GA must be installed on your website. If you use GTM, please configure it properly to accept events.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('Font Awesome', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-fa-enable" name="leform-fa-enable" '.($leform->options['fa-enable'] == "on" ? 'checked="checked"' : '').' onchange="if(jQuery(\'#leform-fa-enable\').is(\':checked\')){jQuery(\'.leform-fa-extra\').fadeIn(300);}else{jQuery(\'.leform-fa-extra\').fadeOut(300);}" /><label for="leform-fa-enable"></label><span>'.esc_html__('Enable Font Awesome icons', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if you want to use full set of Font Awesome icons.', 'leform').'</em>
					</td>
				</tr>
				<tr class="leform-fa-extra"'.($leform->options['fa-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-fa-solid-enable" name="leform-fa-solid-enable" '.($leform->options['fa-solid-enable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-fa-solid-enable"></label><span>'.esc_html__('Enable Solid Icons', 'leform').'</span>
						<br /><em>'.esc_html__('Enable Font Awesome Solid Icons, you can turn it off you do not need Solid Icons pack. More details:', 'leform').' <a href="https://fontawesome.com/cheatsheet" target="_blank">https://fontawesome.com/cheatsheet</a>.</em>
					</td>
				</tr>
				<tr class="leform-fa-extra"'.($leform->options['fa-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-fa-regular-enable" name="leform-fa-regular-enable" '.($leform->options['fa-regular-enable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-fa-regular-enable"></label><span>'.esc_html__('Enable Regular Icons', 'leform').'</span>
						<br /><em>'.esc_html__('Enable Font Awesome Regular Icons, you can turn it off you do not need Regular Icons pack. More details:', 'leform').' <a href="https://fontawesome.com/cheatsheet" target="_blank">https://fontawesome.com/cheatsheet</a>.</em>
					</td>
				</tr>
				<tr class="leform-fa-extra"'.($leform->options['fa-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-fa-brands-enable" name="leform-fa-brands-enable" '.($leform->options['fa-brands-enable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-fa-brands-enable"></label><span>'.esc_html__('Enable Brand Icons', 'leform').'</span>
						<br /><em>'.esc_html__('Enable Font Awesome Brand Icons, you can turn it off you do not need Brand Icons pack. More details:', 'leform').' <a href="https://fontawesome.com/cheatsheet" target="_blank">https://fontawesome.com/cheatsheet</a>.</em>
					</td>
				</tr>
				<tr class="leform-fa-extra"'.($leform->options['fa-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-fa-css-disable" name="leform-fa-css-disable" '.($leform->options['fa-css-disable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-fa-css-disable"></label><span>'.esc_html__('Do not load Font Awesome library', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if your theme or another plugin already loads Font Awesome library.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('Air Datepicker plugin', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-airdatepicker-enable" name="leform-airdatepicker-enable" '.($leform->options['airdatepicker-enable'] == "on" ? 'checked="checked"' : '').' onchange="if(jQuery(\'#leform-airdatepicker-enable\').is(\':checked\')){jQuery(\'.leform-airdatepicker-extra\').fadeIn(300);}else{jQuery(\'.leform-airdatepicker-extra\').fadeOut(300);}" /><label for="leform-airdatepicker-enable"></label><span>'.esc_html__('Enable Air Datepicker plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if you want to use nice datepicker with forms.', 'leform').'</em>
					</td>
				</tr>
				<tr class="leform-airdatepicker-extra"'.($leform->options['airdatepicker-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-airdatepicker-js-disable" name="leform-airdatepicker-js-disable" '.($leform->options['airdatepicker-js-disable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-airdatepicker-js-disable"></label><span>'.esc_html__('Do not load Air Datepicker plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if your theme or another plugin already loads Air Datepicker plugin.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('jQuery Mask plugin', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-mask-enable" name="leform-mask-enable" '.($leform->options['mask-enable'] == "on" ? 'checked="checked"' : '').' onchange="if(jQuery(\'#leform-mask-enable\').is(\':checked\')){jQuery(\'.leform-mask-extra\').fadeIn(300);}else{jQuery(\'.leform-mask-extra\').fadeOut(300);}" /><label for="leform-mask-enable"></label><span>'.esc_html__('Enable jQuery Mask plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if you want to specify input masks for text fields.', 'leform').'</em>
					</td>
				</tr>
				<tr class="leform-mask-extra"'.($leform->options['mask-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-mask-js-disable" name="leform-mask-js-disable" '.($leform->options['mask-js-disable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-mask-js-disable"></label><span>'.esc_html__('Do not load jQuery Mask plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if your theme or another plugin already loads jQuery Mask plugin.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th>'.esc_html__('JavaScript Expression Parser', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-jsep-enable" name="leform-jsep-enable" '.($leform->options['jsep-enable'] == "on" ? 'checked="checked"' : '').' onchange="if(jQuery(\'#leform-jsep-enable\').is(\':checked\')){jQuery(\'.leform-jsep-extra\').fadeIn(300);}else{jQuery(\'.leform-jsep-extra\').fadeOut(300);}" /><label for="leform-jsep-enable"></label><span>'.esc_html__('Enable JavaScript Expression Parser plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if you want to use math expressions and show results on front-end side.', 'leform').'</em>
					</td>
				</tr>
				<tr class="leform-jsep-extra"'.($leform->options['jsep-enable'] == "on" ? '' : ' style="display:none;"').'>
					<th></th>
					<td>
						<input type="checkbox" id="leform-jsep-js-disable" name="leform-jsep-js-disable" '.($leform->options['jsep-js-disable'] == "on" ? 'checked="checked"' : '').' /><label for="leform-jsep-js-disable"></label><span>'.esc_html__('Do not load JavaScript Expression Parser plugin', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on if your theme or another plugin already loads JavaScript Expression Parser plugin.', 'leform').'</em>
					</td>
				</tr>
			</table>
			<h3>'.esc_html__('Item Purchase Code', 'leform').'</h3>
			<table class="leform-useroptions">
				<tr>
					<th>'.esc_html__('Item Purchase Code', 'leform').':</th>
					<td>
						<input type="text" id="leform-purchase-code" name="leform-purchase-code" value="'.esc_html($leform->options['purchase-code']).'" class="widefat" />
						<br /><em>'.esc_html__('To activate your license please enter Item Purchase Code.', 'leform').' <a target="_blank" href="https://help.market.envato.com/hc/en-us/articles/202822600">'.esc_html__('Where can I find my Purchase Code?', 'leform').'</a></em>
					</td>
				</tr>
				</tr>
			</table>';
		do_action('leform_options_show');
		echo '
			<hr>
			<div class="leform-button-container">
				<input type="hidden" name="action" value="leform-settings-save" />
				<a class="leform-button" onclick="return leform_settings_save(this);"><i class="fas fa-check"></i><label>'.esc_html__('Save Settings', 'leform').'</label></a>
			</div>
		</div>
	</form>
</div>
<div id="leform-global-message"></div>';
		
	}

	function admin_advanced_settings() {
		global $wpdb, $leform;
		
		if (!in_array('curl', get_loaded_extensions())) {
			$is_curl = false;
			$message .= '<div class="error"><p>'.esc_html__('cURL is not installed! Some modules are not available.', 'leform').'</p></div>';
		
		} else $is_curl = true;
		echo '
<div class="wrap leform-admin leform">
	<h2>'.esc_html__('Green Forms - Advanced Settings', 'leform').'
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/standalone-script-documentation/' : 'https://greenforms.pro/documentation/').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>
	<div class="leform-tabs leform-tabs-main">
		<a class="leform-tab" href="'.admin_url('admin.php').'?page=leform-settings">'.esc_html__('General', 'leform').'</a>
		<a class="leform-tab leform-tab-active" href="'.admin_url('admin.php').'?page=leform-settings&subpage=advanced">'.esc_html__('Advanced', 'leform').'</a>
	</div>
	<form class="leform-settings-form" enctype="multipart/form-data" method="post" style="margin: 0px" action="'.admin_url('admin.php').'">
		<div class="leform-settings" style="position: relative;">
			<h3>'.esc_html__('Plugin Modules', 'leform').'</h3>
			<table class="leform-useroptions">
				<tr>
					<th>'.esc_html__('Basic', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-custom-js" name="leform-advanced-enable-custom-js" '.($leform->advanced_options['enable-custom-js'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-custom-js"></label><span>'.esc_html__('Activate Custom JavaScript Handlers module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to use custom javascript event handlers for forms. Configure them on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-htmlform" name="leform-advanced-enable-htmlform" '.($leform->advanced_options['enable-htmlform'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-htmlform"></label><span>'.esc_html__('Activate HTML Form Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to re-submit form data as a part of 3rd party HTML form. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr><td colspan="2"><hr /></td></tr>
				<tr>
					<th>'.esc_html__('Marketing Systems, Newsletters and CRM', 'leform').':</th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-activecampaign" name="leform-advanced-enable-activecampaign" '.($leform->advanced_options['enable-activecampaign'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-activecampaign"></label><span>'.esc_html__('Activate ActiveCampaign Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to ActiveCampaign. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-activetrail" name="leform-advanced-enable-activetrail" '.($leform->advanced_options['enable-activetrail'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-activetrail"></label><span>'.esc_html__('Activate ActiveTrail Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to ActiveTrail. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-agilecrm" name="leform-advanced-enable-agilecrm" '.($leform->advanced_options['enable-agilecrm'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-agilecrm"></label><span>'.esc_html__('Activate AgileCRM Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to AgileCRM. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-avangemail" name="leform-advanced-enable-avangemail" '.($leform->advanced_options['enable-avangemail'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-avangemail"></label><span>'.esc_html__('Activate AvangEmail Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to AvangEmail. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-aweber" name="leform-advanced-enable-aweber" '.($leform->advanced_options['enable-aweber'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-aweber"></label><span>'.esc_html__('Activate AWeber Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to AWeber. Connect to AWeber on General Settings page and configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-campaignmonitor" name="leform-advanced-enable-campaignmonitor" '.($leform->advanced_options['enable-campaignmonitor'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-campaignmonitor"></label><span>'.esc_html__('Activate Campaign Monitor Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Campaign Monitor. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-conversio" name="leform-advanced-enable-conversio" '.($leform->advanced_options['enable-conversio'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-conversio"></label><span>'.esc_html__('Activate Conversio Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Conversio. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-freshmail" name="leform-advanced-enable-freshmail" '.($leform->advanced_options['enable-freshmail'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-freshmail"></label><span>'.esc_html__('Activate FreshMail Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to FreshMail. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-getresponse" name="leform-advanced-enable-getresponse" '.($leform->advanced_options['enable-getresponse'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-getresponse"></label><span>'.esc_html__('Activate GetResponse Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to GetResponse. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		if (!defined('UAP_CORE')) {
			echo '
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-jetpack" name="leform-advanced-enable-jetpack" '.($leform->advanced_options['enable-jetpack'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-jetpack"></label><span>'.esc_html__('Activate Jetpack Subscriptions Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Jetpack Subscriptions. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		}
		echo '
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-madmimi" name="leform-advanced-enable-madmimi" '.($leform->advanced_options['enable-madmimi'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-madmimi"></label><span>'.esc_html__('Activate Mad Mimi Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Mad Mimi. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mailautic" name="leform-advanced-enable-mailautic" '.($leform->advanced_options['enable-mailautic'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailautic"></label><span>'.esc_html__('Activate Mailautic Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Mailautic. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mailchimp" name="leform-advanced-enable-mailchimp" '.($leform->advanced_options['enable-mailchimp'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailchimp"></label><span>'.esc_html__('Activate MailChimp Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to MailChimp. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mailerlite" name="leform-advanced-enable-mailerlite" '.($leform->advanced_options['enable-mailerlite'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailerlite"></label><span>'.esc_html__('Activate MailerLite Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to MailerLite. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		if (!defined('UAP_CORE')) {
			echo '
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-mailpoet" name="leform-advanced-enable-mailpoet" '.($leform->advanced_options['enable-mailpoet'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailpoet"></label><span>'.esc_html__('Activate MailPoet Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to MailPoet. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input type="checkbox" id="leform-advanced-enable-mailster" name="leform-advanced-enable-mailster" '.($leform->advanced_options['enable-mailster'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailster"></label><span>'.esc_html__('Activate Mailster Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Mailster. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>';
		}
		echo '
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mailwizz" name="leform-advanced-enable-mailwizz" '.($leform->advanced_options['enable-mailwizz'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mailwizz"></label><span>'.esc_html__('Activate MailWizz Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to MailWizz. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-mumara" name="leform-advanced-enable-mumara" '.($leform->advanced_options['enable-mumara'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-mumara"></label><span>'.esc_html__('Activate Mumara Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Mumara. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-omnisend" name="leform-advanced-enable-omnisend" '.($leform->advanced_options['enable-omnisend'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-omnisend"></label><span>'.esc_html__('Activate Omnisend Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Omnisend. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-ontraport" name="leform-advanced-enable-ontraport" '.($leform->advanced_options['enable-ontraport'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-ontraport"></label><span>'.esc_html__('Activate Ontraport Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Ontraport. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-rapidmail" name="leform-advanced-enable-rapidmail" '.($leform->advanced_options['enable-rapidmail'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-rapidmail"></label><span>'.esc_html__('Activate Rapidmail Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Rapidmail. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-zohocrm" name="leform-advanced-enable-zohocrm" '.($leform->advanced_options['enable-zohocrm'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-zohocrm"></label><span>'.esc_html__('Activate Zoho CRM Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to submit form data to Zoho CRM. Connect to Zoho CRM on General Settings page and configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr><td colspan="2"><hr /></td></tr>
				<tr>
					<th>'.esc_html__('Payment Providers', 'leform').':</th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-blockchain" name="leform-advanced-enable-blockchain" '.($leform->advanced_options['enable-blockchain'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-blockchain"></label><span>'.esc_html__('Activate Blockchain Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Blockchain. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-interkassa" name="leform-advanced-enable-interkassa" '.($leform->advanced_options['enable-interkassa'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-interkassa"></label><span>'.esc_html__('Activate InterKassa Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via InterKassa. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-paypal" name="leform-advanced-enable-paypal" '.($leform->advanced_options['enable-paypal'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-paypal"></label><span>'.esc_html__('Activate PayPal Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via PayPal. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-perfectmoney" name="leform-advanced-enable-perfectmoney" '.($leform->advanced_options['enable-perfectmoney'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-perfectmoney"></label><span>'.esc_html__('Activate Perfect Money Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Perfect Money. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-skrill" name="leform-advanced-enable-skrill" '.($leform->advanced_options['enable-skrill'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-skrill"></label><span>'.esc_html__('Activate Skrill Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Skrill. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
				<tr>
					<th></th>
					<td>
						<input '.($is_curl ? '' : 'disabled="disabled" ').'type="checkbox" id="leform-advanced-enable-stripe" name="leform-advanced-enable-stripe" '.($leform->advanced_options['enable-stripe'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-enable-stripe"></label><span>'.esc_html__('Activate Stripe Integration module', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this module on if you want to accept payments via Stripe. Configure integration on form editor.', 'leform').'</em>
					</td>
				</tr>
			</table>
			<h3>'.esc_html__('Miscellaneous', 'leform').'</h3>
			<table class="leform-useroptions">
				<tr>
					<th>'.esc_html__('Minification', 'leform').':</th>
					<td>
						<input type="checkbox" id="leform-advanced-minified-sources" name="leform-advanced-minified-sources" '.($leform->advanced_options['minified-sources'] == "on" ? 'checked="checked"' : '').' /><label for="leform-advanced-minified-sources"></label><span>'.esc_html__('Use minified JS and CSS files', 'leform').'</span>
						<br /><em>'.esc_html__('Turn this feature on to use minified JS and CSS files.', 'leform').'</em>
					</td>
				</tr>
			</table>
			<hr>
			<div class="leform-button-container">
				<input type="hidden" name="action" value="leform-advanced-settings-save" />
				<a class="leform-button" onclick="return leform_settings_save(this);"><i class="fas fa-check"></i><label>'.esc_html__('Save Settings', 'leform').'</label></a>
			</div>
		</div>
	</form>
</div>
<div id="leform-global-message"></div>';
	}

	function admin_forms() {
		global $wpdb, $leform;
		
		if (isset($_GET["s"])) $search_query = trim(stripslashes($_GET["s"]));
		else $search_query = "";
		
		$tmp = $wpdb->get_row("SELECT COUNT(*) AS total FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0'".((strlen($search_query) > 0) ? " AND name LIKE '%".esc_sql($wpdb->esc_like($search_query))."%'" : ""), ARRAY_A);
		$total = $tmp["total"];
		$totalpages = ceil($total/LEFORM_RECORDS_PER_PAGE);
		if ($totalpages == 0) $totalpages = 1;
		if (isset($_GET["p"])) $page = intval($_GET["p"]);
		else $page = 1;
		if ($page < 1 || $page > $totalpages) $page = 1;
		$switcher = $leform->page_switcher(admin_url('admin.php').'?page=leform'.((strlen($search_query) > 0) ? '&s='.rawurlencode($search_query) : ''), $page, $totalpages);

		if (isset($_GET['o'])) {
			$sort = $_GET['o'];
			if (in_array($sort, $leform->sort_methods)) {
				if ($sort != $leform->options['sort-forms']) {
					update_option('leform-sort-forms', $sort);
					$leform->options['sort-forms'] = $sort;
				}
			} else $sort = $leform->options['sort-forms'];
		} else $sort = $leform->options['sort-forms'];
		$orderby = 't1.created DESC';
		switch ($sort) {
			case 'name-az':
				$orderby = 't1.name ASC';
				break;
			case 'name-za':
				$orderby = 't1.name DESC';
				break;
			case 'date-az':
				$orderby = 't1.created ASC';
				break;
			default:
				$orderby = 't1.created DESC';
				break;
		}
		
		$sql = "SELECT t1.*, t2.entries FROM ".$wpdb->prefix."leform_forms t1 LEFT JOIN (SELECT COUNT(*) AS entries, form_id FROM ".$wpdb->prefix."leform_records WHERE deleted = '0' GROUP BY form_id) t2 ON t2.form_id = t1.id WHERE t1.deleted = '0'".((strlen($search_query) > 0) ? " AND t1.name LIKE '%".esc_sql($wpdb->esc_like($search_query))."%'" : "")." ORDER BY ".$orderby." LIMIT ".esc_sql(($page-1)*LEFORM_RECORDS_PER_PAGE).", ".esc_sql(LEFORM_RECORDS_PER_PAGE);
		$rows = $wpdb->get_results($sql, ARRAY_A);
		
		$upload_dir = wp_upload_dir();
		if (!class_exists('ZipArchive') || !class_exists('DOMDocument') || !file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/temp')) $export_full = false;
		else $export_full = true;
		
		echo '
<div class="wrap leform-admin">
	<h2>'.esc_html__('Green Forms - Forms', 'leform').'
		<a class="add-new-h2" href="'.admin_url('admin.php').'?page=leform-add">'.esc_html__('Create New Form', 'leform').'</a>
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/standalone-script-documentation/' : 'https://greenforms.pro/documentation/').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>
	<div class="leform-top-forms">
		<div class="leform-top-form-left">
			<form action="'.admin_url('admin.php').'" method="get" class="uap-filter-form leform-filter-form">
				<input type="hidden" name="page" value="leform" />
				<label>'.esc_html__('Search:', 'leform').'</label>
				<input type="text" name="s" style="width: 200px;" class="form-control" value="'.esc_html($search_query).'">
				<input type="submit" class="button-secondary action" value="'.esc_html__('Search', 'leform').'" />
				'.((strlen($search_query) > 0) ? '<input type="button" class="button-secondary action" value="'.esc_html__('Reset search results', 'leform').'" onclick="window.location.href=\''.admin_url('admin.php').'?page=leform\';" />' : '').'
			</form>
		</div>
		<div class="leform-top-form-right">
			<form id="leform-sorting-form" action="'.admin_url('admin.php').'" method="get" class="uap-filter-form leform-filter-form">
			<input type="hidden" name="page" value="leform" />
			<label>'.esc_html__('Sort:', 'leform').'</label>
			'.((strlen($search_query) > 0) ? '<input type="hidden" name="s" value="'.esc_html($search_query).'">' : '').'
			'.(($page > 1) ? '<input type="hidden" name="p" value="'.esc_html($page).'">' : '').'
			<select name="o" onchange="jQuery(\'#leform-sorting-form\').submit();" style="width: 150px;" class="form-control">
				<option value="name-az"'.($sort == 'name-az' ? ' selected="selected"' : '').'>'.esc_html__('Alphabetically', 'leform').' ▲</option>
				<option value="name-za"'.($sort == 'name-za' ? ' selected="selected"' : '').'>'.esc_html__('Alphabetically', 'leform').' ▼</option>
				<option value="date-az"'.($sort == 'date-az' ? ' selected="selected"' : '').'>'.esc_html__('Created', 'leform').' ▲</option>
				<option value="date-za"'.($sort == 'date-za' ? ' selected="selected"' : '').'>'.esc_html__('Created', 'leform').' ▼</option>
			</select>
			</form>
		</div>
	</div>
	<div class="leform-table-list-buttons"><a href="'.admin_url('admin.php').'?page=leform-add" class="leform-button leform-button-small"><i class="fas fa-plus"></i><label>'.esc_html__('Create New Form', 'leform').'</label></a></div>
	<div class="leform-pageswitcher">'.$switcher.'</div>
	<table class="leform-table-list widefat">
		<tr>
			<th>'.esc_html__('Name', 'leform').'</th>
			<th style="width: 360px;">'.esc_html__('Shortcode', 'leform').'</th>
			<th style="width: 60px;">'.esc_html__('Entries', 'leform').'</th>
			<th style="width: 35px;"></th>
		</tr>';
		if (sizeof($rows) > 0) {
			foreach ($rows as $row) {
				echo '
				<tr>
					<td><a href="'.admin_url('admin.php').'?page=leform-add&id='.esc_html($row['id']).'"><strong>'.esc_html($row['name']).'</strong></a><span class="leform-table-list-badge-status">'.($row['active'] < 1 ? '<span class="leform-badge leform-badge-danger">'.esc_html__('Inactive', 'leform').'</span>' : '').'</span><label class="leform-table-list-created">'.esc_html__('Created', 'leform').': '.date("Y-m-d H:i", $row['created']).'</label></td>
					<td class="leform-table-list-column-shortcode"><span class="leform-more-using" data-id="'.esc_html($row['id']).'" title="'.esc_html__('Click the icon for more options.', 'leform').'" onclick="leform_more_using_open(this);"><i class="fas fa-code"></i></span><div><input type="text" value="'.(!defined('UAP_CORE') ? '[leform id=\''.esc_html($row['id']).'\' name=\''.esc_html(str_replace("'", "", $row['name'])).'\']' : '<div class=\'leform-inline\' data-id=\''.esc_html($row['id']).'\'></div>').'" readonly="readonly" style="" onclick="this.focus();this.select();"></div></td>
					<td><a href="'.admin_url('admin.php').'?page=leform-log&form='.esc_html($row['id']).'">'.intval($row['entries']).'</a></td>
					<td>
						<div class="leform-table-list-actions">
							<span><i class="fas fa-ellipsis-v"></i></span>
							<div class="leform-table-list-menu">
								<ul>
									<li><a href="'.admin_url('admin.php').'?page=leform-add&id='.esc_html($row['id']).'">'.esc_html__('Edit', 'leform').'</a></li>
									<li><a href="#" data-status="'.($row['active'] > 0 ? 'active' : 'inactive').'" data-id="'.esc_html($row['id']).'" data-doing="'.($row['active'] > 0 ? esc_html__('Deactivating...', 'leform') : esc_html__('Activating...', 'leform')).'" onclick="return leform_forms_status_toggle(this);">'.($row['active'] > 0 ? esc_html__('Deactivate', 'leform') : esc_html__('Activate', 'leform')).'</a></li>
									<li><a href="#" data-id="'.esc_html($row['id']).'" data-doing="'.esc_html__('Duplicating...', 'leform').'" onclick="return leform_forms_duplicate(this);">'.esc_html__('Duplicate', 'leform').'</a></li>
									<li><a href="'.admin_url('admin.php').'?page=leform&leform-action=export&id='.esc_html($row['id']).'">'.esc_html__('Export', 'leform').'</a></li>
									<li><a href="'.admin_url('admin.php').'?page=leform-stats&form='.esc_html($row['id']).'">'.esc_html__('Statistics', 'leform').'</a></li>
									<li><a href="#" data-id="'.esc_html($row['id']).'" data-doing="'.esc_html__('Reseting...', 'leform').'" onclick="return leform_stats_reset(this);">'.esc_html__('Reset Statistics', 'leform').'</a></li>
									<li><a href="'.admin_url('admin.php').'?page=leform-field-analytics&form='.esc_html($row['id']).'">'.esc_html__('Field Analytics', 'leform').'</a></li>
									<li class="leform-table-list-menu-line"></li>
									<li><a href="#" data-id="'.esc_html($row['id']).'" data-doing="'.esc_html__('Deleting...', 'leform').'" onclick="return leform_forms_delete(this);">'.esc_html__('Delete', 'leform').'</a></li>
								</ul>
							</div>
						</div>
					</td>
				</tr>';
			}
		} else {
			echo '
				<tr><td colspan="4" class="leform-table-list-empty">'.((strlen($search_query) > 0) ? esc_html__('No results found for', 'leform').' "<strong>'.esc_html($search_query).'</strong>"' : esc_html__('List is empty.', 'leform')).'</td></tr>';
		}
		echo '
	</table>
	<div class="leform-pageswitcher">'.$switcher.'</div>
	<div class="leform-table-list-buttons">
		<form id="leform-import-form" enctype="multipart/form-data" method="post" action="'.admin_url('admin.php').'?page=leform&leform-action=import">
			<input id="leform-import-form-file" type="file" accept=".txt, .zip" name="leform-file" onchange="jQuery(\'#leform-import-form\').submit();">
		</form>
		<a class="leform-button leform-button-small" onclick="jQuery(\'#leform-import-form-file\').click(); return false;"><i class="fas fa-upload"></i><label>'.esc_html__('Import Form', 'leform').'</label></a>
		<a href="'.admin_url('admin.php').'?page=leform-add" class="leform-button leform-button-small"><i class="fas fa-plus"></i><label>'.esc_html__('Create New Form', 'leform').'</label></a>
	</div>
	
</div>
<div id="leform-global-message"></div>';
		echo $this->admin_modal_html();
		if (!empty($this->error_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("danger", "'.esc_html($this->error_message).'");});</script>';
		} else if (!empty($this->success_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("success", "'.esc_html($this->success_message).'");});</script>';
		}
		echo '
<div class="leform-admin-popup-overlay" id="leform-more-using-overlay"></div>
<div class="leform-admin-popup" id="leform-more-using">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_more_using_close();"><i class="fas fa-times"></i></a>
			<h3><i class="fas fa-code"></i> '.esc_html__('How To Use', 'leform').'<span></span></h3>
		</div>
		<div class="leform-admin-popup-content">
			<div class="leform-admin-popup-content-form">
			</div>
		</div>
		<div class="leform-admin-popup-loading"><i class="fas fa-spinner fa-spin"></i></div>
	</div>
</div>
<script>jQuery(document).ready(function(){leform_forms_ready();});</script>';
	}
	
	function admin_add_form() {
		global $wpdb, $leform;
		$default_form_options = $leform->default_form_options();
		$form_id = null;
		$form_options = null;
		$form_details = array();
		$form_elements = array();
		if (array_key_exists('id', $_REQUEST)) {
			$form_id = intval($_REQUEST['id']);
			$form_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0' AND id = '".esc_sql($form_id)."'", ARRAY_A);
			if (!empty($form_details)) $form_options = json_decode($form_details['options'], true);
			else $form_id = null;
		}
		if (!empty($form_options)) $form_options = array_merge($default_form_options, $form_options);
		else $form_options = $default_form_options;

		$default_page_options = $leform->default_form_options('page');
		$default_page_confirmation_options = $leform->default_form_options('page-confirmation');
		$form_pages = array(array_merge($default_page_options, array('id' => 1, 'type' => 'page')));
		
		if (!empty($form_details)) {
			$form_options['name'] = $form_details['name'];
			$form_options['active'] = $form_details['active'] > 0 ? 'on' : 'off';

			$form_pages = json_decode($form_details['pages'], true);
			if (is_array($form_pages)) {
				foreach($form_pages as $key => $page_options) {
					if (is_array($page_options)) {
						if ($page_options['type'] == 'page') $page_options = array_merge($default_page_options, $page_options);
						else $page_options = array_merge($default_page_confirmation_options, $page_options);
						$form_pages[$key] = $page_options;
					} else unset($form_pages[$key]);
				}
				$form_pages = array_values($form_pages);
			} else $form_pages = array(array_merge($default_page_options, array('id' => 1)));
			
			$form_elements = json_decode($form_details['elements'], true);
			if (is_array($form_elements)) {
				foreach($form_elements as $key => $form_element_raw) {
					$element_options = json_decode($form_element_raw, true);
					if (is_array($element_options) && array_key_exists('type', $element_options)) {
						$default_element_options = $leform->default_form_options($element_options['type']);
						$element_options = array_merge($default_element_options, $element_options);
						$form_elements[$key] = json_encode($element_options);
					} else unset($form_elements[$key]);
				}
				$form_elements = array_values($form_elements);
			} else $form_elements = array();
		}
		
		$confirmation_found = false;
		foreach($form_pages as $form_page) {
			if ($form_page['id'] == 'confirmation') {
				$confirmation_found = true;
				break;
			}
		}
		if (!$confirmation_found) {
			$form_pages[] = array_merge($default_page_confirmation_options, array('id' => 'confirmation', 'type' => 'page-confirmation', 'name' => esc_html__('Confirmation', 'leform')));
			$default_element_options = $leform->default_form_options('html');
			$element_options = array(
				"type" => 'html',
				"_parent" => 'confirmation',
				"_parent-col" => 0, 
				"_seq" => 0, 
				"id" => 0,
				"content" => '<h4 style="text-align: center;">Thank you!</h4><p style="text-align: center;">We will contact you soon.</p>'
			);
			$element_options = array_merge($default_element_options, $element_options);
			$form_elements[] = json_encode($element_options);
		}
		echo (!empty($form_id) ? '<script>leform_gettingstarted_enable = "off";</script>' : '').'
<style>body {position: absolute; width: 100%;}
.mce-menu .mce-menu-item-normal.mce-active, .mce-menu .mce-menu-item-preview.mce-active, .mce-menu .mce-menu-item.mce-selected, .mce-menu .mce-menu-item:focus, .mce-menu .mce-menu-item:hover {background: #26B99A; color: #fff !important;}
.mce-menu .mce-menu-item-normal.mce-active span, .mce-menu .mce-menu-item-preview.mce-active span, .mce-menu .mce-menu-item.mce-selected span, .mce-menu .mce-menu-item:focus span, .mce-menu .mce-menu-item:hover span {color: #fff !important;}
</style>
<div class="wrap leform-admin leform-admin-editor">
	<h2>'.esc_html__('Green Forms - Edit Form', 'leform').'
		<a class="add-new-h2" href="'.admin_url('admin.php').'?page=leform-add">'.esc_html__('Create New Form', 'leform').'</a>
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/standalone-script-documentation/' : 'https://greenforms.pro/documentation/').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>
<div class="">
	<div class="leform-header">
		<div class="leform-header-settings"><span data-type="settings" onclick="return leform_properties_open(this);"><i class="fas fa-cogs"></i></span></div>
		<div class="leform-header-save"><span onclick="return leform_save(this);"><i class="far fa-save"></i>'.esc_html__('Save', 'leform').'</span></div>
		<div class="leform-header-preview"><span'.(!empty($form_id) ? ' data-id="'.esc_html($form_id).'"' : ' style="display: none;"').' onclick="leform_preview(this);"><i class="far fa-eye"></i></span></div>
		<div class="leform-header-using"><span'.(!empty($form_id) ? ' data-id="'.esc_html($form_id).'"' : ' style="display: none;"').' onclick="leform_more_using_open(this);"><i class="fas fa-code"></i></span></div>
	</div>
	<div class="leform-pages-bar">
		<ul class="leform-pages-bar-items">';
		foreach ($form_pages as $form_page) {
			if ($form_page['id'] == 'confirmation') {
				echo '
			<li class="leform-pages-bar-item-confirmation" data-id="'.esc_html($form_page['id']).'" data-name="'.esc_html($form_page['name']).'"><label onclick="return leform_pages_activate(this);">'.esc_html($form_page['name']).'</label><span><a href="#" data-type="page-confirmation" onclick="return leform_properties_open(this);"><i class="fas fa-cog"></i></a></span></li>';
			} else {
				echo '
			<li class="leform-pages-bar-item" data-id="'.esc_html($form_page['id']).'" data-name="'.esc_html($form_page['name']).'"><label onclick="return leform_pages_activate(this);">'.esc_html($form_page['name']).'</label><span><a href="#" data-type="page" onclick="return leform_properties_open(this);"><i class="fas fa-cog"></i></a><a href="#" class="leform-pages-bar-item-delete'.(sizeof($form_pages) <= 1 ? ' leform-pages-bar-item-delete-disabled' : '').'" onclick="return leform_pages_delete(this);"><i class="fas fa-trash-alt"></i></a></span></li>';
			}
		}
		echo '
			<li class="leform-pages-add" onclick="return leform_pages_add();"><label><i class="fas fa-plus"></i> '.esc_html__('Add Page', 'leform').'</label></li>
		</ul>
	</div>
	<div class="leform-toolbar">
		<ul class="leform-toolbar-list">';
		foreach ($leform->toolbar_tools as $key => $value) {
			if (array_key_exists('options', $value)) {
				echo '
			<li class="leform-toolbar-tool-'.esc_html($value['type']).'" class="leform-toolbar-list-options" data-type="'.esc_html($key).'" data-option="2"><a href="#" title="'.esc_html($value['title']).'"><i class="'.esc_html($value['icon']).'"></i></a><ul>';
				foreach ($value['options'] as $option_key => $option_value) {
					echo '<li data-type="'.esc_html($key).'" data-option="'.esc_html($option_key).'" title=""><a href="#" title="'.esc_html($value['title']).'">'.esc_html($option_value).'</a></li>';
				}
				echo '</ul></li>';
				
			} else {
				echo '
			<li class="leform-toolbar-tool-'.esc_html($value['type']).'" data-type="'.esc_html($key).'"><a href="#" title="'.esc_html($value['title']).'"><i class="'.esc_html($value['icon']).'"></i></a></li>';
			}
		}
		echo '
		</ul>
	</div>
	<div class="leform-builder"><div class="leform-form-global-style"></div>';
		foreach ($form_pages as $form_page) {
			echo '
			<div id="leform-form-'.esc_html($form_page['id']).'" class="leform-form leform-elements" _data-parent="'.esc_html($form_page['id']).'" _data-parent-col="0"></div>';
		}
		echo '
	</div>
</div>

<div class="leform-admin-popup-overlay" id="leform-element-properties-overlay"></div>
<div class="leform-admin-popup" id="leform-element-properties">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_properties_close();"><i class="fas fa-times"></i></a>
			<h3><i class="fas fa-cog"></i> '.esc_html__('Element Properties', 'leform').'</h3>
		</div>
		<div class="leform-admin-popup-content">
			<div class="leform-admin-popup-content-form">
			</div>
		</div>
		<div class="leform-admin-popup-buttons">
			<a class="leform-admin-button" href="#" onclick="return leform_properties_save();"><i class="fas fa-check"></i><label>'.esc_html__('Save Details', 'leform').'</label></a>
		</div>
		<div class="leform-admin-popup-loading"><i class="fas fa-spinner fa-spin"></i></div>
	</div>
</div>
<div class="leform-fa-selector-overlay"></div>
<div class="leform-fa-selector">
	<div class="leform-fa-selector-inner">
		<div class="leform-fa-selector-header">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_fa_selector_close();"><i class="fas fa-times"></i></a>
			<input type="text" placeholder="'.esc_html__('Search...', 'leform').'">
		</div>
		<div class="leform-fa-selector-content">
			<span title="No icon" onclick="leform_fa_selector_set(this);"><i class=""></i></span>';
		if ($leform->options['fa-enable'] == 'on') {
			if ($leform->options['fa-solid-enable'] == 'on') {
				foreach ($leform->fa_solid as $value) {
					echo '<span title="'.esc_html(ucwords(str_replace(array("-"), array(" "), $value))).'" onclick="leform_fa_selector_set(this);"><i class="fas fa-'.esc_html($value).'"></i></span>';
				}
			}
			if ($leform->options['fa-regular-enable'] == 'on') {
				foreach ($leform->fa_regular as $value) {
					echo '<span title="'.esc_html(ucwords(str_replace(array("-"), array(" "), $value))).'" onclick="leform_fa_selector_set(this);"><i class="far fa-'.esc_html($value).'"></i></span>';
				}
			}
			if ($leform->options['fa-brands-enable'] == 'on') {
				foreach ($leform->fa_brands as $value) {
					echo '<span title="'.esc_html(ucwords(str_replace(array("-"), array(" "), $value))).'" onclick="leform_fa_selector_set(this);"><i class="fab fa-'.esc_html($value).'"></i></span>';
				}
			}
		} else {
			foreach ($leform->font_awesome_basic as $value) {
				echo '<span title="'.esc_html(ucwords(str_replace(array("-"), array(" "), $value))).'" onclick="leform_fa_selector_set(this);"><i class="leform-fa leform-fa-'.esc_html($value).'"></i></span>';
			}
		}
		echo '
		</div>
	</div>
</div>
<div class="leform-admin-popup-overlay" id="leform-bulk-options-overlay"></div>
<div class="leform-admin-popup" id="leform-bulk-options">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_bulk_options_close();"><i class="fas fa-times"></i></a>
			<h3><i class="fas fa-list-ul"></i> '.esc_html__('Add Bulk Options', 'leform').'</h3>
		</div>
		<div class="leform-admin-popup-content">
			<div class="leform-admin-popup-content-form">
				<div class="leform-bulk-options-text">'.esc_html__('Click a category on the left side to insert predefined options. You can edit the options on the right side or enter your own options. One option per line!', 'leform').'</div>
				<div class="leform-bulk-options-container">
					<div class="leform-bulk-categories">
						<ul>
							<li data-category="existing" onclick="return leform_bulk_category_add(this);"><i class="fas fa-plus"></i> '.esc_html__('Existing Options', 'leform').'</li>';
		foreach($leform->predefined_options as $key => $value) {
			echo '
							<li data-category="'.esc_html($key).'" onclick="return leform_bulk_category_add(this);"><i class="fas fa-plus"></i> '.esc_html($value['label']).'</li>';
		}
		echo '
						</ul>
					</div>
					<div class="leform-bulk-editor">
						<textarea></textarea>
					</div>
				</div>
				<div class="leform-bulk-options-text"><input class="leform-checkbox-toggle" type="checkbox" id="leform-bulk-options-overwrite"><label for="leform-bulk-options-overwrite"></label> '.esc_html__('Overwrite existing options', 'leform').'</div>
			</div>
		</div>
		<div class="leform-admin-popup-buttons">
			<a class="leform-admin-button" href="#" onclick="return leform_bulk_options_add();"><i class="fas fa-plus"></i><label>'.esc_html__('Add Options', 'leform').'</label></a>
		</div>
	</div>
</div>
<div class="leform-admin-popup-overlay" id="leform-more-using-overlay"></div>
<div class="leform-admin-popup" id="leform-more-using">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_more_using_close();"><i class="fas fa-times"></i></a>
			<h3><i class="fas fa-code"></i> '.esc_html__('How To Use', 'leform').'<span></span></h3>
		</div>
		<div class="leform-admin-popup-content">
			<div class="leform-admin-popup-content-form">
			</div>
		</div>
		<div class="leform-admin-popup-loading"><i class="fas fa-spinner fa-spin"></i></div>
	</div>
</div>
<div class="leform-admin-popup-overlay" id="leform-preview-overlay"></div>
<div class="leform-admin-popup" id="leform-preview" data-width="1600">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_preview_close();"><i class="fas fa-times"></i></a>
			<span class="leform-preview-size-mobile" data-width="480" onclick="leform_preview_size(this);"><i class="fas fa-mobile-alt"></i></span>
			<span class="leform-preview-size-tablet" data-width="960" onclick="leform_preview_size(this);"><i class="fas fa-tablet-alt"></i></span>
			<span class="leform-preview-size-desktop leform-preview-size-active" data-width="1600" onclick="leform_preview_size(this);"><i class="fas fa-tv"></i></span>
			<h3><i class="far fa-eye"></i> '.esc_html__('Preview', 'leform').'<span></span></h3>
		</div>
		<div class="leform-admin-popup-content"><iframe data-loading="false" id="leform-preview-iframe" name="leform-preview-iframe" src="about:blank" onload="leform_preview_loaded(this);"></iframe></div>
	</div>
</div>
<div id="leform-global-message"></div>';
		if (empty($form_id)) {
			echo '
<div class="leform-admin-create-overlay">
	<div class="leform-admin-create">
		<div class="leform-admin-create-content">
			<div>
				<input type="text" id="leform-create-name" value="" placeholder="'.esc_html__('Please enter the form name...', 'leform').'" />
			</div>
			<div class="leform-admin-buttons-create">
				<a class="leform-admin-button leform-admin-button-create" onclick="return leform_create();"><i class="fas fa-check"></i> '.esc_html__('Create New Form', 'leform').'</a>
			</div>
		</div>
	</div>
</div>';
		}
		echo $this->admin_modal_html();
		$webfonts_array = $wpdb->get_results("SELECT * FROM ".$wpdb->prefix."leform_webfonts WHERE deleted = '0' ORDER BY family", ARRAY_A);
		$webfonts = array();
		foreach ($webfonts_array as $webfont) {
			$webfonts[] = $webfont['family'];
		}
		$providers = array();
		$providers = apply_filters('leform_providers', $providers);
		$payment_providers = array();
		$payment_providers = apply_filters('leform_payment_providers', $payment_providers);
		echo '
<input type="hidden" id="leform-id" value="'.intval($form_id).'" />
<script>
	var leform_webfonts = '.json_encode($webfonts).';
	var leform_localfonts = '.json_encode($leform->local_fonts).';
	var leform_toolbar_tools = '.json_encode($leform->toolbar_tools).';
	var leform_meta = '.json_encode($leform->element_properties_meta).';
	var leform_validators = '.json_encode($leform->validators_meta).';
	var leform_filters = '.json_encode($leform->filters_meta).';
	var leform_confirmations = '.json_encode($leform->confirmations_meta).';
	var leform_notifications = '.json_encode($leform->notifications_meta).';
	var leform_integrations = '.json_encode($leform->integrations_meta).';
	var leform_payment_gateway = '.json_encode($leform->payment_gateways_meta).';
	var leform_math_expressions_meta = '.json_encode($leform->math_meta).';
	var leform_logic_rules = '.json_encode($leform->logic_rules).';
	var leform_predefined_options = '.json_encode($leform->predefined_options).';
	var leform_form_options = '.json_encode($form_options).';
	var leform_form_pages_raw = '.json_encode($form_pages).';
	var leform_form_elements_raw = '.json_encode($form_elements).';
	var leform_integration_providers = '.json_encode($providers).';
	var leform_payment_providers = '.json_encode($payment_providers).';
	jQuery(document).ready(function(){leform_form_ready();});
</script>
</div>';
	}

	function admin_modal_html() {
		return '
<div class="leform-modal-overlay"></div>
<div class="leform-modal">
	<div class="leform-modal-content">
		<div class="leform-modal-message"></div>
		<div class="leform-modal-buttons">
			<a class="leform-modal-button" id="leform-modal-button-ok" href="#" onclick="return false;"><i class="fas fa-check"></i><label></label></a>
			<a class="leform-modal-button" id="leform-modal-button-cancel" href="#" onclick="return false;"><i class="fas fa-times"></i><label></label></a>
		</div>
	</div>
</div>';
	}

	function admin_records() {
		global $wpdb, $leform;

		if (isset($_GET["s"])) $search_query = trim(stripslashes($_GET["s"]));
		else $search_query = "";
		
		if (isset($_GET["form"])) $form_id = intval(stripslashes($_GET["form"]));
		else $form_id = 0;
		$forms = $wpdb->get_results("SELECT DISTINCT t1.form_id, t2.deleted, t2.name AS form_name FROM ".$wpdb->prefix."leform_records t1 LEFT JOIN ".$wpdb->prefix."leform_forms t2 ON t2.id = t1.form_id WHERE t1.deleted = '0' ORDER BY t2.name ASC", ARRAY_A);

		$filter = '';
		if ($form_id > 0) $filter = " AND t1.form_id = '".esc_sql($form_id)."'";
		if (!empty($search_query)) $filter .= " AND t1.fields LIKE '%".esc_sql($wpdb->esc_like($search_query))."%'";
		
		$tmp = $wpdb->get_row("SELECT COUNT(*) AS total FROM ".$wpdb->prefix."leform_records t1 WHERE t1.deleted = '0'".$filter, ARRAY_A);
		$total = $tmp["total"];
		$totalpages = ceil($total/LEFORM_RECORDS_PER_PAGE);
		if ($totalpages == 0) $totalpages = 1;
		if (isset($_GET["p"])) $page = intval($_GET["p"]);
		else $page = 1;
		if ($page < 1 || $page > $totalpages) $page = 1;
		$switcher = $leform->page_switcher(admin_url('admin.php').'?page=leform-log'.($form_id > 0 ? '&form='.rawurlencode($form_id) : '').((strlen($search_query) > 0) ? '&s='.rawurlencode($search_query) : ''), $page, $totalpages);
		
		$sql = "SELECT t1.*, t2.name AS form_name, t2.options AS form_options FROM ".$wpdb->prefix."leform_records t1 LEFT JOIN ".$wpdb->prefix."leform_forms t2 ON t2.id = t1.form_id WHERE t1.deleted = '0'".$filter." ORDER BY t1.created DESC LIMIT ".esc_sql(($page-1)*LEFORM_RECORDS_PER_PAGE).", ".esc_sql(LEFORM_RECORDS_PER_PAGE);
		$rows = $wpdb->get_results($sql, ARRAY_A);
		
		echo '
<div class="wrap leform-admin">
	<h2>'.esc_html__('Green Forms - Log', 'leform').'
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/standalone-script-documentation/' : 'https://greenforms.pro/documentation/').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>

	<div class="leform-top-forms">
		<div class="leform-top-form-left">
			<form action="'.admin_url('admin.php').'" method="get"  class="uap-filter-form leform-filter-form">
			<input type="hidden" name="page" value="leform-log" />
			'.($form_id > 0 ? '<input type="hidden" name="form" value="'.esc_html($form_id).'" />' : '').'
			<label>'.esc_html__('Search', 'leform').':</label>
			<input type="text" name="s" class="form-control" style="width: 200px;" value="'.esc_html($search_query).'">
			<input type="submit" class="button-secondary action" value="'.esc_html__('Search', 'leform').'" />
			'.((strlen($search_query) > 0) ? '<input type="button" class="button-secondary action" value="'.esc_html__('Reset search results', 'leform').'" onclick="window.location.href=\''.admin_url('admin.php').'?page=leform-log'.($form_id > 0 ? '&form='.rawurlencode($form_id) : '').'\';" />' : '').'
			</form>
		</div>
		<div class="leform-top-form-right">
			<form id="leform-filter-form" action="'.admin_url('admin.php').'" method="get"  class="uap-filter-form leform-filter-form">
			<input type="hidden" name="page" value="leform-log" />
			<label>'.esc_html__('Filter:', 'leform').'</label>
			<select name="form" class="form-control" style="width: 150px;" onchange="jQuery(\'#leform-filter-form\').submit();">
				<option value="">'.esc_html__('All Forms', 'leform').'</option>';
			foreach ($forms as $form) {
				echo '
				<option value="'.esc_html($form['form_id']).'"'.($form['form_id'] == $form_id ? ' selected="selected"' : '').'>'.esc_html($form['form_name']).($form['deleted'] == 1 ? ' [deleted]': '').'</option>';
			}
			echo '
			</select>
			</form>
		</div>
	</div>
	<div class="leform-table-list-buttons"></div>
	<div class="leform-pageswitcher">'.$switcher.'</div>
	<table class="leform-table-list widefat">
		<tr>
			<th>'.esc_html__('Primary Field', 'leform').'</th>
			<th>'.esc_html__('Secondray Field', 'leform').'</th>
			<th>'.esc_html__('Form', 'leform').'</th>
			<th style="width: 100px;">'.esc_html__('Amount', 'leform').'</th>
			<th style="width: 130px;">'.esc_html__('Created', 'leform').'</th>
			<th style="width: 35px;"></th>
		</tr>';
		if (sizeof($rows) > 0) {
			foreach ($rows as $row) {
				$primary_field = '<a href="#" onclick="return leform_record_details_open(this);" data-id="'.esc_html($row['id']).'"><strong>-</strong></a>';
				$secondary_field = '-';
				$form_options = json_decode($row['form_options'], true);
				if (!empty($form_options) && is_array($form_options)) {
					$fields = json_decode($row['fields'], true);
					if (!empty($fields) && is_array($fields)) {
						if (array_key_exists($form_options['key-fields-primary'], $fields)) {
							$primary_field = '<a href="#" onclick="return leform_record_details_open(this);" data-id="'.esc_html($row['id']).'"><strong>'.esc_html($fields[$form_options['key-fields-primary']]).'</strong></a>';
						}
						if (array_key_exists($form_options['key-fields-secondary'], $fields)) {
							$secondary_field = esc_html($fields[$form_options['key-fields-secondary']]);
						}
					}
				}
				
				echo '
				<tr>
					<td>'.$primary_field.'</td>
					<td>'.$secondary_field.'</td>
					<td><a href="'.admin_url('admin.php').'?page=leform-add&id='.esc_html($row['form_id']).'">'.esc_html($row['form_name']).'</a></td>
					<td>'.($row['amount'] > 0 ? '<a href="'.admin_url('admin.php').'?page=leform-transactions&record='.rawurlencode($row['id']).'">'.($row['currency'] != 'BTC' ? number_format($row['amount'], 2, '.', '') : number_format($row['amount'], 8, '.', '')).' '.esc_html($row['currency']).'</a>'.($row['status'] == LEFORM_RECORD_STATUS_PAID ? '<span class="leform-badge leform-badge-success">'.esc_html__('Paid', 'leform').'</span>' : '<span class="leform-badge leform-badge-danger">'.esc_html__('Unpaid', 'leform').'</span>') : '-').'</td>
					<td>'.date('Y-m-d H:i', $row['created']).'</td>
					<td>
						<div class="leform-table-list-actions">
							<span><i class="fas fa-ellipsis-v"></i></span>
							<div class="leform-table-list-menu">
								<ul>
									<li><a href="#" onclick="return leform_record_details_open(this);" data-id="'.esc_html($row['id']).'">'.esc_html__('Details', 'leform').'</a></li>
									<li><a href="'.admin_url('admin.php').'?page=leform-transactions&record='.esc_html($row['id']).'">'.esc_html__('Transactions', 'leform').'</a></li>
									<li><a href="#" data-id="'.esc_html($row['id']).'" data-doing="'.esc_html__('Deleting...', 'leform').'" onclick="return leform_records_delete(this);">'.esc_html__('Delete', 'leform').'</a></li>
								</ul>
							</div>
						</div>
					</td>
				</tr>';
			}
		} else {
			echo '
				<tr><td colspan="6" class="leform-table-list-empty">'.((strlen($search_query) > 0) ? esc_html__('No results found for', 'leform').' "<strong>'.esc_html($search_query).'</strong>"' : esc_html__('List is empty.', 'leform')).'</td></tr>';
		}
		echo '
	</table>
	<div class="leform-pageswitcher">'.$switcher.'</div>
</div>
<div id="leform-global-message"></div>';
		echo $this->admin_modal_html();
		if (!empty($this->error_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("danger", "'.esc_html($this->error_message).'");});</script>';
		} else if (!empty($this->success_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("success", "'.esc_html($this->success_message).'");});</script>';
		}
		echo '
<div class="leform-admin-popup-overlay" id="leform-record-details-overlay"></div>
<div class="leform-admin-popup" id="leform-record-details">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_record_details_close();"><i class="fas fa-times"></i></a>
			<h3><i class="fas fa-cog"></i> '.esc_html__('Record Details', 'leform').'<span></span></h3>
		</div>
		<div class="leform-admin-popup-content">
			<div class="leform-admin-popup-content-form">
			</div>
		</div>
		<div class="leform-admin-popup-loading"><i class="fas fa-spinner fa-spin"></i></div>
	</div>
</div>
<script>jQuery(document).ready(function(){leform_log_ready();});</script>';
 	}

	function admin_stats() {
		global $wpdb, $leform;

		if (array_key_exists('form', $_REQUEST) && $_REQUEST['form'] > 0) $form_id = intval(stripslashes($_REQUEST["form"]));
		else $form_id = null;
		$forms = $wpdb->get_results("SELECT DISTINCT t1.form_id, t2.deleted, t2.name AS form_name FROM ".$wpdb->prefix."leform_stats t1 LEFT JOIN ".$wpdb->prefix."leform_forms t2 ON t2.id = t1.form_id WHERE t1.deleted = '0' ORDER BY t2.name ASC", ARRAY_A);

		$start_date = new DateTime(date("Y-m-01"));
		$end_date = new DateTime(date("Y-m-t"));
		
		$output = $leform->stats_array($form_id, $start_date, $end_date);
		
		echo '
<div class="wrap leform-admin">
	<h2>'.esc_html__('Green Forms - Stats', 'leform').'
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/standalone-script-documentation/' : 'https://greenforms.pro/documentation/').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>

	<div class="leform-top-forms">
		<div class="leform-top-form-left">
			<div class="leform-stats-filter">
				<div class="leform-stats-select-container">
					<select id="leform-stats-form" onchange="">
						<option value="0">'.esc_html__('All Forms', 'leform').'</option>';
				foreach ($forms as $form) {
					echo '
						<option value="'.esc_html($form['form_id']).'"'.($form['form_id'] == $form_id ? ' selected="selected"' : '').'>'.esc_html($form['form_name']).($form['deleted'] == 1 ? ' [deleted]': '').'</option>';
				}
				echo '
					</select>
					<label>'.esc_html__('Form', 'leform').'</label>
				</div>
				<div class="leform-stats-input-container">
					<input type="text" id="leform-stats-date-start" class="leform-stats-date" value="'.date('Y-m-01').'" />
					<label>'.esc_html__('Start date', 'leform').'</label>
				</div>
				<div class="leform-stats-input-container">
					<input type="text" id="leform-stats-date-end" class="leform-stats-date" value="'.date('Y-m-t').'" />
					<label>'.esc_html__('End date', 'leform').'</label>
				</div>
				<a class="leform-stats-button" onclick="return leform_stats_load(this);"><i class="fas fa-check"></i><label>'.esc_html__('Apply', 'leform').'</label></a>
			</div>
		</div>
	</div>
	<canvas id="leform-stats"></canvas>
</div>
<input type="hidden" id="leform-stats-initial-data" value="'.esc_html(json_encode($output)).'" />
<script>jQuery(document).ready(function(){leform_stats_ready();});</script>
<div id="leform-global-message"></div>';
		echo $this->admin_modal_html();
		if (!empty($this->error_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("danger", "'.esc_html($this->error_message).'");});</script>';
		} else if (!empty($this->success_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("success", "'.esc_html($this->success_message).'");});</script>';
		}
 	}

	function admin_field_analytics() {
		global $wpdb, $leform;

		if (array_key_exists('form', $_REQUEST) && $_REQUEST['form'] > 0) $form_id = intval(stripslashes($_REQUEST["form"]));
		else $form_id = null;
		$forms = $wpdb->get_results("SELECT DISTINCT t1.form_id, t2.deleted, t2.name AS form_name FROM ".$wpdb->prefix."leform_stats t1 LEFT JOIN ".$wpdb->prefix."leform_forms t2 ON t2.id = t1.form_id WHERE t1.deleted = '0' ORDER BY t2.name ASC", ARRAY_A);

		$start_date = new DateTime('2000-01-01');
		$end_date = new DateTime('2030-12-31');
		
		$output = array();
		if ($form_id > 0) {
			if (!class_exists("leform_form")) include_once(dirname(__FILE__).'/core-form.php');
			$form_object = new leform_form(intval($form_id), true);
			if (!empty($form_object->id)) {
				$output = $form_object->field_analytics_array($start_date, $end_date);
			} else $form_id = null;
		}
		echo '
<div class="wrap leform-admin">
	<h2>'.esc_html__('Green Forms - Field Analytics', 'leform').'
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/standalone-script-documentation/' : 'https://greenforms.pro/documentation/').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>

	<div class="leform-top-forms">
		<div class="leform-top-form-left">
			<div class="leform-stats-filter">
				<div class="leform-stats-select-container">
					<select id="leform-stats-form" onchange="">
						<option value="0">'.esc_html__('Select the form', 'leform').'</option>';
				foreach ($forms as $form) {
					echo '
						<option value="'.esc_html($form['form_id']).'"'.($form['form_id'] == $form_id ? ' selected="selected"' : '').'>'.esc_html($form['form_name']).($form['deleted'] == 1 ? ' [deleted]': '').'</option>';
				}
				echo '
					</select>
					<label>'.esc_html__('Form', 'leform').'</label>
				</div>
				<div class="leform-stats-radio-container">
					<div class="leform-stats-radio-toggle-container">
						<input class="leform-checkbox-toggle" type="checkbox" value="off" id="leform-stats-period" /><label for="leform-stats-period"></label>
					</div>
					<label>'.esc_html__('Period', 'leform').'</label>
				</div>
				<div class="leform-stats-input-container" style="display:none;">
					<input type="text" id="leform-stats-date-start" class="leform-stats-date" value="'.date('Y-m-01').'" />
					<label>'.esc_html__('Start date', 'leform').'</label>
				</div>
				<div class="leform-stats-input-container" style="display:none;">
					<input type="text" id="leform-stats-date-end" class="leform-stats-date" value="'.date('Y-m-t').'" />
					<label>'.esc_html__('End date', 'leform').'</label>
				</div>
				<a class="leform-stats-button" onclick="return leform_field_analytics_load(this);"><i class="fas fa-check"></i><label>'.esc_html__('Apply', 'leform').'</label></a>
			</div>
		</div>
	</div>
	<div class="leform-field-analytics-container">
		'.(empty($form_id) ? '<div class="leform-field-analytics-noform">'.esc_html__('No form selected.', 'leform').'</div>' : '').'
	</div>
</div>
<input type="hidden" id="leform-field-analytics-initial-data" value="'.esc_html(json_encode($output)).'" />
<script>jQuery(document).ready(function(){leform_field_analytics_ready();});</script>
<div id="leform-global-message"></div>';
		echo $this->admin_modal_html();
		if (!empty($this->error_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("danger", "'.esc_html($this->error_message).'");});</script>';
		} else if (!empty($this->success_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("success", "'.esc_html($this->success_message).'");});</script>';
		}
 	}

	function admin_transactions() {
		global $wpdb, $leform;

		if (isset($_GET["s"])) $search_query = trim(stripslashes($_GET["s"]));
		else $search_query = "";
		if (isset($_GET["record"])) $record_id = intval(stripslashes($_GET["record"]));
		else $record_id = 0;
		
		$filter = '';
		if ($record_id > 0) $filter = " AND t1.record_id = '".esc_sql($record_id)."'";
		if (!empty($search_query)) $filter .= " AND (t1.payer_name LIKE '%".esc_sql($wpdb->esc_like($search_query))."%' OR t1.payer_email LIKE '%".esc_sql($wpdb->esc_like($search_query))."%' OR t1.details LIKE '%".esc_sql($wpdb->esc_like($search_query))."%')";
		
		$tmp = $wpdb->get_row("SELECT COUNT(*) AS total FROM ".$wpdb->prefix."leform_transactions t1 WHERE t1.deleted = '0'".$filter, ARRAY_A);
		$total = $tmp["total"];
		$totalpages = ceil($total/LEFORM_RECORDS_PER_PAGE);
		if ($totalpages == 0) $totalpages = 1;
		if (isset($_GET["p"])) $page = intval($_GET["p"]);
		else $page = 1;
		if ($page < 1 || $page > $totalpages) $page = 1;
		$switcher = $leform->page_switcher(admin_url('admin.php').'?page=leform-transactions'.($record_id > 0 ? '&record='.rawurlencode($record_id) : '').((strlen($search_query) > 0) ? '&s='.rawurlencode($search_query) : ''), $page, $totalpages);
		
		$sql = "SELECT t1.*, t2.form_id AS form_id FROM ".$wpdb->prefix."leform_transactions t1 LEFT JOIN ".$wpdb->prefix."leform_records t2 ON t2.id = t1.record_id WHERE t1.deleted = '0'".$filter." ORDER BY t1.created DESC LIMIT ".esc_sql(($page-1)*LEFORM_RECORDS_PER_PAGE).", ".esc_sql(LEFORM_RECORDS_PER_PAGE);
		$rows = $wpdb->get_results($sql, ARRAY_A);
		
		echo '
<div class="wrap leform-admin">
	<h2>'.esc_html__('Green Forms - Transactions', 'leform').'
		<a href="'.(defined('UAP_CORE') ? 'https://greenforms.pro/standalone-script-documentation/' : 'https://greenforms.pro/documentation/').'" class="add-new-h2" target="_blank">'.esc_html__('Online Documentation', 'leform').'</a>
	</h2>

	<div class="leform-top-forms">
		<div class="leform-top-form-left">
			<form action="'.admin_url('admin.php').'" method="get"  class="uap-filter-form leform-filter-form">
			<input type="hidden" name="page" value="leform-transactions" />
			'.($record_id > 0 ? '<input type="hidden" name="record" value="'.esc_html($record_id).'" />' : '').'
			<label>'.esc_html__('Search', 'leform').':</label>
			<input type="text" name="s" class="form-control" style="width: 200px;" value="'.esc_html($search_query).'">
			<input type="submit" class="button-secondary action" value="'.esc_html__('Search', 'leform').'" />
			'.((strlen($search_query) > 0) ? '<input type="button" class="button-secondary action" value="'.esc_html__('Reset search results', 'leform').'" onclick="window.location.href=\''.admin_url('admin.php').'?page=leform-transactions'.($record_id > 0 ? '&record='.rawurlencode($record_id) : '').'\';" />' : '').'
			</form>
		</div>
		<div class="leform-top-form-right">
		</div>
	</div>
	<div class="leform-table-list-buttons"></div>
	<div class="leform-pageswitcher">'.$switcher.'</div>
	<table class="leform-table-list widefat">
		<tr>
			<th>'.esc_html__('Payer', 'leform').'</th>
			<th>'.esc_html__('Status', 'leform').'</th>
			<th style="width: 120px;">'.esc_html__('Amount', 'leform').'</th>
			<th style="width: 130px;">'.esc_html__('Created', 'leform').'</th>
			<th style="width: 35px;"></th>
		</tr>';
		if (sizeof($rows) > 0) {
			foreach ($rows as $row) {
				echo '
				<tr>
					<td><a href="#" onclick="return leform_transaction_details_open(this);" data-id="'.esc_html($row['id']).'"><strong>'.esc_html($row['payer_name']).'</strong><label class="leform-table-list-created">'.esc_html($row['payer_email']).'</label></a></td>
					<td><a href="#" onclick="return leform_transaction_details_open(this);" data-id="'.esc_html($row['id']).'">'.esc_html($row["payment_status"]).'</a><label class="leform-table-list-created">'.esc_html($row["transaction_type"]).'</label></td>
					<td>'.($row['currency'] == 'BTC' ? number_format($row['gross'], 8, ".", "") : number_format($row['gross'], 2, ".", "")).' '.$row['currency'].'</td>
					<td>'.date('Y-m-d H:i', $row['created']).'</td>
					<td>
						<div class="leform-table-list-actions">
							<span><i class="fas fa-ellipsis-v"></i></span>
							<div class="leform-table-list-menu">
								<ul>
									<li><a href="#" onclick="return leform_transaction_details_open(this);" data-id="'.esc_html($row['id']).'">'.esc_html__('Details', 'leform').'</a></li>
									<li><a href="#" data-id="'.esc_html($row['id']).'" data-doing="'.esc_html__('Deleting...', 'leform').'" onclick="return leform_transactions_delete(this);">'.esc_html__('Delete', 'leform').'</a></li>
								</ul>
							</div>
						</div>
					</td>
				</tr>';
			}
		} else {
			echo '
				<tr><td colspan="5" class="leform-table-list-empty">'.((strlen($search_query) > 0) ? esc_html__('No results found for', 'leform').' "<strong>'.esc_html($search_query).'</strong>"' : esc_html__('List is empty.', 'leform')).'</td></tr>';
		}
		echo '
	</table>
	<div class="leform-pageswitcher">'.$switcher.'</div>
</div>
<div id="leform-global-message"></div>';
		echo $this->admin_modal_html();
		if (!empty($this->error_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("danger", "'.esc_html($this->error_message).'");});</script>';
		} else if (!empty($this->success_message)) {
			echo '
<script>jQuery(document).ready(function(){leform_global_message_show("success", "'.esc_html($this->success_message).'");});</script>';
		}
		echo '
<div class="leform-admin-popup-overlay" id="leform-record-details-overlay"></div>
<div class="leform-admin-popup" id="leform-record-details">
	<div class="leform-admin-popup-inner">
		<div class="leform-admin-popup-title">
			<a href="#" title="'.esc_html__('Close', 'leform').'" onclick="return leform_record_details_close();"><i class="fas fa-times"></i></a>
			<h3><i class="fas fa-cog"></i> '.esc_html__('Transaction Details', 'leform').'<span></span></h3>
		</div>
		<div class="leform-admin-popup-content">
			<div class="leform-admin-popup-content-form">
			</div>
		</div>
		<div class="leform-admin-popup-loading"><i class="fas fa-spinner fa-spin"></i></div>
	</div>
</div>
<script>jQuery(document).ready(function(){leform_log_ready();});</script>';
 	}
	
	function admin_init() {
		global $wpdb, $leform;
		if (!current_user_can('manage_options') && !$leform->demo_mode) return;
		if (array_key_exists('leform-action', $_REQUEST)) {
			switch ($_REQUEST['leform-action']) {
				case 'download':
					if ($leform->demo_mode) {
						$this->error_message = esc_html__('This operation disabled in DEMO mode.', 'leform');
						return;
					}
					$upload_id = intval($_REQUEST["id"]);
					$upload_dir = wp_upload_dir();
					$upload_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_uploads WHERE deleted = '0' AND id = '".esc_sql($upload_id)."'", ARRAY_A);
					if (!empty($upload_details)) {
						$filename = $upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/'.$upload_details['form_id'].'/'.$upload_details['filename'];
						if (file_exists($filename) && is_file($filename)) {
							error_reporting(0);
							ob_start();
							if(!ini_get('safe_mode')) set_time_limit(0);
							ob_end_clean();
							$length = filesize($filename);
							if (strstr($_SERVER["HTTP_USER_AGENT"],"MSIE")) {
								header("Pragma: public");
								header("Expires: 0");
								header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
								header("Content-type: application-download");
								header("Content-Length: ".$length);
								header("Content-Disposition: attachment; filename=\"".$upload_details['filename_original']."\"");
								header("Content-Transfer-Encoding: binary");
							} else {
								header("Content-type: application-download");
								header("Content-Length: ".$length);
								header("Content-Disposition: attachment; filename=\"".$upload_details['filename_original']."\"");
							}

							$handle_read = fopen($filename, "rb");
							while (!feof($handle_read) && $length > 0) {
								$content = fread($handle_read, 1024);
								echo substr($content, 0, min($length, 1024));
								flush();
								ob_flush();
								$length = $length - strlen($content);
								if ($length < 0) $length = 0;
							}
							fclose($handle_read);
							exit;
						}
					}
					$this->error_message = esc_html__('Requested file not found.', 'leform');
					return;
					break;
				case 'export':
					if ($leform->demo_mode) {
						$this->error_message = esc_html__('This operation disabled in DEMO mode.', 'leform');
						return;
					}
					$form_id = intval($_REQUEST["id"]);
					$export = $leform->export($form_id);
					$this->error_message = esc_html__('Requested form not found.', 'leform');
					return;
					break;
				case 'import':
					if ($leform->demo_mode) {
						$this->error_message = esc_html__('This operation disabled in DEMO mode.', 'leform');
						return;
					}
					if (!array_key_exists('leform-file', $_FILES)) return;
					if (is_uploaded_file($_FILES["leform-file"]["tmp_name"])) {
						$dot_pos = strrpos($_FILES["leform-file"]["name"], '.');
						if ($dot_pos === false) {
							$this->error_message = esc_html__('Invalid form file.', 'leform');
							return;
						}
						$ext = strtolower(substr($_FILES["leform-file"]["name"], $dot_pos));
						if ($ext == '.txt') {
							$this->_import_form($_FILES["leform-file"]["tmp_name"]);
							if (!empty($this->error_message)) return;
							$this->success_message = esc_html__('The new form successfully imported.', 'leform');
							return;
						} else if ($ext == '.zip') {
							$str_id = $leform->random_string(16);
							$upload_dir = wp_upload_dir();
							$temp_dir = $upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/'.$str_id;
							if (!file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/temp') || !wp_mkdir_p($temp_dir)) {
								$this->error_message = esc_html__('Make sure that "temp" folder has write permissions.', 'leform');
								return;
							}
							if (!defined('UAP_CORE')) {
								require_once(ABSPATH.'wp-admin/includes/file.php');
								WP_Filesystem();
								$result = unzip_file($_FILES["leform-file"]["tmp_name"], $temp_dir);
							} else {
								$result = new WP_Error();
							}
							if (is_wp_error($result)) {
								try {
									$zip = new ZipArchive;
								} catch(Exception $e){
									$this->error_message = esc_html__('This operation requires ZipArchive module. It is not found.', 'leform');
									return;
								}
								if ($zip->open($_FILES["leform-file"]["tmp_name"]) === TRUE) {
									$zip->extractTo($temp_dir);
									$zip->close();
								} else {
									$this->error_message = esc_html__('Can not unzip archive into folder.', 'leform');
									return;
								}
							}
							$upload_url = trailingslashit($upload_dir['baseurl']).LEFORM_UPLOADS_DIR.'/'.$str_id;
							if (strtolower(substr($upload_url, 0, 7)) == 'http://') $upload_url = substr($upload_url, 5);
							else if (strtolower(substr($upload_url, 0, 8)) == 'https://') $upload_url = substr($upload_url, 6);
							
							$this->_import_form($temp_dir.'/form.txt', $upload_url);
							
							unlink($temp_dir.'/form.txt');
							
							if (!empty($this->error_message)) {
								$this->_remove_dir($temp_dir);
								return;
							}
							$this->success_message = esc_html__('The new form successfully imported.', 'leform');
							return;
						} else {
							$this->error_message = esc_html__('Invalid form file.', 'leform');
							return;
						}
					}
					$this->error_message = esc_html__('Form file was not uploaded.', 'leform');
					return;
					break;
				case 'preview':
					$form_id = intval($_REQUEST["id"]);
					if (!class_exists("leform_form")) include_once(dirname(__FILE__).'/core-form.php');
					$form_object = new leform_form($form_id, true);
					$content = '<div class="not-found">'.esc_html__('Requested form not found', 'leform').'</div>';
					if (!class_exists("leform_front_class")) include_once(dirname(__FILE__).'/core-front.php');
					if (!empty($form_object->id)) {
						$content = leform_front_class::shortcode_handler(array('id' => $form_object->id, 'preview' => true));
					}
					echo '
<!DOCTYPE html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
	<meta name="robots" content="noindex, nofollow, noarchive, nosnippet">
	<title>'.esc_html__('Form Preview', 'leform').': '.(empty($form_object->id) ? esc_html__('Form not found', 'leform') : esc_html($form_object->name)).'</title>
	<style>body{font-family:arial;font-size:15px;}body::-webkit-scrollbar{width: 5px;}body::-webkit-scrollbar-track{box-shadow:inset 0 0 6px rgba(0,0,0,0.1);}body::-webkit-scrollbar-thumb{background-color:#26B99A;}div.not-found{margin: 40px;text-align:center;}</style>
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/style.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
					if ($leform->options['fa-enable'] == 'on') {
						if ($leform->options['fa-solid-enable'] == 'on' && $leform->options['fa-regular-enable'] == 'on' && $leform->options['fa-brands-enable'] == 'on') {
							echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/fontawesome-all.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
						} else {
							echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/fontawesome.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
							if ($leform->options['fa-solid-enable'] == 'on') echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/fontawesome-solid.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
							if ($leform->options['fa-regular-enable'] == 'on') echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/fontawesome-regular.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
							if ($leform->options['fa-brands-enable'] == 'on') echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/fontawesome-brands.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
						}
						echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/font-awesome.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
					} else {
						echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/leform-fa.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />';
					}
					echo '
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/font-awesome.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />
	<link rel="stylesheet" href="'.$leform->plugins_url.'/css/airdatepicker.css?ver='.LEFORM_VERSION.'" type="text/css" media="all" />
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/jquery.min.js?ver='.LEFORM_VERSION.'"></script>
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/jsep.min.js?ver='.LEFORM_VERSION.'"></script>
	<script type="text/javascript">var leform_preview_mode = "on"; var leform_customjs_handlers = {};</script>
</head>
<body>
'.$content;
					leform_front_class::front_footer();
					echo '
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/leform.js?ver='.LEFORM_VERSION.'"></script>
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/airdatepicker.js?ver='.LEFORM_VERSION.'"></script>
	<script type="text/javascript" src="'.$leform->plugins_url.'/js/jquery.mask.min.js?ver='.LEFORM_VERSION.'"></script>
</body>
</html>';
					exit;
					break;
				default:
					break;
			}
		} else if (array_key_exists('leform-gettingstarted', $_REQUEST)) {
			if ($_REQUEST['leform-gettingstarted'] == 'on') {
				$leform->options['gettingstarted-enable'] = 'on';
				update_option('leform-gettingstarted-enable', 'on');
			} else {
				$leform->options['gettingstarted-enable'] = 'off';
				update_option('leform-gettingstarted-enable', 'off');
			}
		}
	}

	function _import_form($_file, $_url = null) {
		global $leform, $wpdb;
		if (!file_exists($_file)) {
			$this->error_message = esc_html__('Please make sure that you uploaded valid form file.', 'leform');
			return;
		}
		$lines = file($_file);
		if (sizeof($lines) != 3) {
			$this->error_message = esc_html__('Invalid form file.', 'leform');
			return;
		}
		$version = intval(trim($lines[0]));
		if ($version > intval(LEFORM_EXPORT_VERSION)) {
			$this->error_message = esc_html__('Version of the form file is not supported.', 'leform');
			return;
		}
		$md5_hash = trim($lines[1]);
		$form_data = trim($lines[2]);
		$form_data = base64_decode($form_data);
		if (!$form_data || md5($form_data) != $md5_hash) {
			$this->error_message = esc_html__('Form file corrupted.', 'leform');
			return;
		}
		$form_details = json_decode($form_data, true);
		if (!$form_details || !is_array($form_details) || !array_key_exists('name', $form_details) || !array_key_exists('options', $form_details) || !array_key_exists('pages', $form_details) || !array_key_exists('elements', $form_details)) {
			$this->error_message = esc_html__('Form file corrupted.', 'leform');
			return;
		}

		$default_form_options = $leform->default_form_options();
		$form_options = array_merge($default_form_options, $form_details['options']);
		if (!empty($_url)) {
			foreach ($leform->element_properties_meta['settings'] as $key => $element) {
				if (array_key_exists('type', $element) && $element['type'] == 'background-style') {
					if (array_key_exists($key.'-image', $form_options)) {
						$form_options[$key.'-image'] = str_replace('LEFORM-FORM-DIR', $_url, $form_options[$key.'-image']);
					}
				}
			}
			if (array_key_exists('confirmations', $form_options) && !empty($form_options['confirmations'])) {
				foreach ($form_options['confirmations'] as $key => $confirmation) {
					$form_options['confirmations'][$key]['message'] = str_replace('LEFORM-FORM-DIR', $_url, $form_options['confirmations'][$key]['message']);
				}
			}
			if (array_key_exists('double-email-message', $form_options) && !empty($form_options['double-email-message'])) {
				$form_options['double-email-message'] = str_replace('LEFORM-FORM-DIR', $_url, $form_options['double-email-message']);
			}
			if (array_key_exists('double-message', $form_options) && !empty($form_options['double-message'])) {
				$form_options['double-message'] = str_replace('LEFORM-FORM-DIR', $_url, $form_options['double-message']);
			}
			if (array_key_exists('notifications', $form_options) && !empty($form_options['notifications'])) {
				foreach ($form_options['notifications'] as $key => $notification) {
					$form_options['notifications'][$key]['message'] = str_replace('LEFORM-FORM-DIR', $_url, $form_options['notifications'][$key]['message']);
				}
			}
		}

		$form_pages = array();
		$default_page_options = $leform->default_form_options("page");
		$default_page_confirmation_options = $leform->default_form_options("page-confirmation");
		foreach ($form_details['pages'] as $page_options) {
			if (is_array($page_options)) {
				if ($page_options['type'] == 'page') $page_options = array_merge($default_page_options, $page_options);
				else $page_options = array_merge($default_page_confirmation_options, $page_options);
				$form_pages[] = $page_options;
			}
		}

		$form_elements = array();
		foreach($form_details['elements'] as $element_options) {
			if (is_array($element_options) && array_key_exists('type', $element_options)) {
				$default_element_options = $leform->default_form_options($element_options['type']);
				$element_options = array_merge($default_element_options, $element_options);
				if (!empty($_url)) {
					if ($element_options['type'] == 'html') {
						$element_options['content'] = str_replace('LEFORM-FORM-DIR', $_url, $element_options['content']);
					} else if ($element_options['type'] == 'imageselect') {
						foreach($element_options['options'] as $option_key => $option) {
							$element_options['options'][$option_key]['image'] = str_replace('LEFORM-FORM-DIR', $_url, $element_options['options'][$option_key]['image']);
						}
					}
				}
				$form_elements[] = json_encode($element_options);
			}
		}
		
		$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_forms (name,options,pages,elements,active,created,modified,deleted) VALUES (
			'".esc_sql($form_details['name'])."','".esc_sql(json_encode($form_options))."','".esc_sql(json_encode($form_pages))."','".esc_sql(json_encode($form_elements))."','0','".esc_sql(time())."','".esc_sql(time())."','0')");
		return;
	}

	function _remove_dir($_dir) { 
		$files = array_diff(scandir($_dir), array('.','..')); 
		foreach ($files as $file) { 
			if (is_dir($_dir.'/'.$file)) {
				$this->_remove_dir($_dir.'/'.$file);
			} else {
				unlink($_dir.'/'.$file); 
			}
		}
		return rmdir($_dir);
	}

	function check_for_plugin_update($checked_data) {
		global $wp_version, $leform;
		
		$file = basename(dirname(dirname(__FILE__))).'/green-forms.php';
		$purchase_code = preg_replace('/[^a-zA-Z0-9-]/', '', $leform->options['purchase-code']);
		
		if (empty($checked_data->checked))
			return $checked_data;

		if (!array_key_exists($file, (array)$checked_data->checked))
			return $checked_data;
		
		$args = array(
			'slug' => 'green-forms',
			'version' => $checked_data->checked[$file],
		);
		$request_string = array(
				'body' => array(
					'action' => 'basic_check', 
					'request' => serialize($args),
					'api-key' => $purchase_code
				),
				'user-agent' => 'WordPress/'.$wp_version.'; '.get_bloginfo('url')
			);
		
		$raw_response = wp_remote_post(LEFORM_API_URL, $request_string);
		
		if (!is_wp_error($raw_response) && ($raw_response['response']['code'] == 200)) {
			$response = unserialize($raw_response['body']);
		}
		if (!empty($response) && is_object($response)) {
			$checked_data->response[$file] = $response;
		}
		return $checked_data;
	}
	
	function plugin_api_call($def, $action, $args) {
		global $wp_version, $leform;

		$file = basename(dirname(dirname(__FILE__))).'/green-forms.php';
		$purchase_code = preg_replace('/[^a-zA-Z0-9-]/', '', $leform->options['purchase-code']);
		
		if (!isset($args->slug) || ($args->slug != 'green-forms'))
			return false;
		
		$plugin_info = get_site_transient('update_plugins');
		$current_version = $plugin_info->checked[$file];
		$args->version = $current_version;
		
		$request_string = array(
				'body' => array(
					'action' => $action, 
					'request' => serialize($args),
					'api-key' => $purchase_code
				),
				'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url')
			);
		
		$request = wp_remote_post(LEFORM_API_URL, $request_string);
		
		if (is_wp_error($request)) {
			$res = new WP_Error('plugins_api_failed', esc_html__('An Unexpected HTTP Error occurred during the API request.', 'leform').' <a href="#" onclick="document.location.reload(); return false;">'.esc_html__('Try again.', 'leform').'</a>', $request->get_error_message());
		} else {
			$res = unserialize($request['body']);
			if ($res === false) {
				$res = new WP_Error('plugins_api_failed', esc_html__('An unknown error occurred', 'leform'), $request['body']);
			}
		}
		return $res;
	}
}
?>