<?php
/*
Plugin Name: Green Forms
Plugin URI: https://greenforms.pro/
Description: The most advaced form builder for WordPress.
Version: 1.10
Author: Halfdata, Inc.
Author URI: https://codecanyon.net/user/halfdata?ref=halfdata
*/
if (!defined('UAP_CORE') && !defined('ABSPATH')) exit;
define('LEFORM_RECORDS_PER_PAGE', '50');
define('LEFORM_VERSION', 1.10);
define('LEFORM_WEBFONTS_VERSION', 3);
define('LEFORM_EXPORT_VERSION', '0001');
define('LEFORM_API_URL', 'https://greenforms.pro/updates/');
define('LEFORM_UPLOADS_DIR', 'green-forms');
define('LEFORM_RECORD_STATUS_NONE', 0);
define('LEFORM_RECORD_STATUS_UNCONFIRMED', 1);
define('LEFORM_RECORD_STATUS_CONFIRMED', 2);
define('LEFORM_RECORD_STATUS_UNPAID', 3);
define('LEFORM_RECORD_STATUS_PAID', 4);
define('LEFORM_UPLOAD_STATUS_OK', 0);
define('LEFORM_UPLOAD_STATUS_ERROR', 1);
define('LEFORM_UPLOAD_STATUS_DELETED', 2);

session_start();

register_activation_hook(__FILE__, array("leform_class", "install"));
register_deactivation_hook(__FILE__, array("leform_class", "uninstall"));

class leform_class {
	var $options;
	var $plugins_url;
	var $demo_mode = false;
	var $google_fonts = array();
	var $element_properties_meta = array();
	var $toolbar_tools = array();
	var $validators_meta = array();
	var $autocomplete_meta = array();
	var $filters_meta = array();
	var $local_fonts = array('Arial','Bookman','Century Gothic','Comic Sans MS','Courier','Garamond','Georgia','Helvetica','Lucida Grande','Palatino','Tahoma','Times','Trebuchet MS','Verdana');
	var $fa_solid = array("ad","address-book","address-card","adjust","air-freshener","align-center","align-justify","align-left","align-right","allergies","ambulance","american-sign-language-interpreting","anchor","angle-double-down","angle-double-left","angle-double-right","angle-double-up","angle-down","angle-left","angle-right","angle-up","angry","ankh","apple-alt","archive","archway","arrow-alt-circle-down","arrow-alt-circle-left","arrow-alt-circle-right","arrow-alt-circle-up","arrow-circle-down","arrow-circle-left","arrow-circle-right","arrow-circle-up","arrow-down","arrow-left","arrow-right","arrow-up","arrows-alt","arrows-alt-h","arrows-alt-v","assistive-listening-systems","asterisk","at","atlas","atom","audio-description","award","baby","baby-carriage","backspace","backward","bacon","balance-scale","ban","band-aid","barcode","bars","baseball-ball","basketball-ball","bath","battery-empty","battery-full","battery-half","battery-quarter","battery-three-quarters","bed","beer","bell","bell-slash","bezier-curve","bible","bicycle","binoculars","biohazard","birthday-cake","blender","blender-phone","blind","blog","bold","bolt","bomb","bone","bong","book","book-dead","book-medical","book-open","book-reader","bookmark","bowling-ball","box","box-open","boxes","braille","brain","bread-slice","briefcase","briefcase-medical","broadcast-tower","broom","brush","bug","building","bullhorn","bullseye","burn","bus","bus-alt","business-time","calculator","calendar","calendar-alt","calendar-check","calendar-day","calendar-minus","calendar-plus","calendar-times","calendar-week","camera","camera-retro","campground","candy-cane","cannabis","capsules","car","car-alt","car-battery","car-crash","car-side","caret-down","caret-left","caret-right","caret-square-down","caret-square-left","caret-square-right","caret-square-up","caret-up","carrot","cart-arrow-down","cart-plus","cash-register","cat","certificate","chair","chalkboard","chalkboard-teacher","charging-station","chart-area","chart-bar","chart-line","chart-pie","check","check-circle","check-double","check-square","cheese","chess","chess-bishop","chess-board","chess-king","chess-knight","chess-pawn","chess-queen","chess-rook","chevron-circle-down","chevron-circle-left","chevron-circle-right","chevron-circle-up","chevron-down","chevron-left","chevron-right","chevron-up","child","church","circle","circle-notch","city","clinic-medical","clipboard","clipboard-check","clipboard-list","clock","clone","closed-captioning","cloud","cloud-download-alt","cloud-meatball","cloud-moon","cloud-moon-rain","cloud-rain","cloud-showers-heavy","cloud-sun","cloud-sun-rain","cloud-upload-alt","cocktail","code","code-branch","coffee","cog","cogs","coins","columns","comment","comment-alt","comment-dollar","comment-dots","comment-medical","comment-slash","comments","comments-dollar","compact-disc","compass","compress","compress-arrows-alt","concierge-bell","cookie","cookie-bite","copy","copyright","couch","credit-card","crop","crop-alt","cross","crosshairs","crow","crown","crutch","cube","cubes","cut","database","deaf","democrat","desktop","dharmachakra","diagnoses","dice","dice-d20","dice-d6","dice-five","dice-four","dice-one","dice-six","dice-three","dice-two","digital-tachograph","directions","divide","dizzy","dna","dog","dollar-sign","dolly","dolly-flatbed","donate","door-closed","door-open","dot-circle","dove","download","drafting-compass","dragon","draw-polygon","drum","drum-steelpan","drumstick-bite","dumbbell","dumpster","dumpster-fire","dungeon","edit","egg","eject","ellipsis-h","ellipsis-v","envelope","envelope-open","envelope-open-text","envelope-square","equals","eraser","ethernet","euro-sign","exchange-alt","exclamation","exclamation-circle","exclamation-triangle","expand","expand-arrows-alt","external-link-alt","external-link-square-alt","eye","eye-dropper","eye-slash","fast-backward","fast-forward","fax","feather","feather-alt","female","fighter-jet","file","file-alt","file-archive","file-audio","file-code","file-contract","file-csv","file-download","file-excel","file-export","file-image","file-import","file-invoice","file-invoice-dollar","file-medical","file-medical-alt","file-pdf","file-powerpoint","file-prescription","file-signature","file-upload","file-video","file-word","fill","fill-drip","film","filter","fingerprint","fire","fire-alt","fire-extinguisher","first-aid","fish","fist-raised","flag","flag-checkered","flag-usa","flask","flushed","folder","folder-minus","folder-open","folder-plus","font","football-ball","forward","frog","frown","frown-open","funnel-dollar","futbol","gamepad","gas-pump","gavel","gem","genderless","ghost","gift","gifts","glass-cheers","glass-martini","glass-martini-alt","glass-whiskey","glasses","globe","globe-africa","globe-americas","globe-asia","globe-europe","golf-ball","gopuram","graduation-cap","greater-than","greater-than-equal","grimace","grin","grin-alt","grin-beam","grin-beam-sweat","grin-hearts","grin-squint","grin-squint-tears","grin-stars","grin-tears","grin-tongue","grin-tongue-squint","grin-tongue-wink","grin-wink","grip-horizontal","grip-lines","grip-lines-vertical","grip-vertical","guitar","h-square","hamburger","hammer","hamsa","hand-holding","hand-holding-heart","hand-holding-usd","hand-lizard","hand-middle-finger","hand-paper","hand-peace","hand-point-down","hand-point-left","hand-point-right","hand-point-up","hand-pointer","hand-rock","hand-scissors","hand-spock","hands","hands-helping","handshake","hanukiah","hard-hat","hashtag","hat-wizard","haykal","hdd","heading","headphones","headphones-alt","headset","heart","heart-broken","heartbeat","helicopter","highlighter","hiking","hippo","history","hockey-puck","holly-berry","home","horse","horse-head","hospital","hospital-alt","hospital-symbol","hot-tub","hotdog","hotel","hourglass","hourglass-end","hourglass-half","hourglass-start","house-damage","hryvnia","i-cursor","ice-cream","icicles","id-badge","id-card","id-card-alt","igloo","image","images","inbox","indent","industry","infinity","info","info-circle","italic","jedi","joint","journal-whills","kaaba","key","keyboard","khanda","kiss","kiss-beam","kiss-wink-heart","kiwi-bird","landmark","language","laptop","laptop-code","laptop-medical","laugh","laugh-beam","laugh-squint","laugh-wink","layer-group","leaf","lemon","less-than","less-than-equal","level-down-alt","level-up-alt","life-ring","lightbulb","link","lira-sign","list","list-alt","list-ol","list-ul","location-arrow","lock","lock-open","long-arrow-alt-down","long-arrow-alt-left","long-arrow-alt-right","long-arrow-alt-up","low-vision","luggage-cart","magic","magnet","mail-bulk","male","map","map-marked","map-marked-alt","map-marker","map-marker-alt","map-pin","map-signs","marker","mars","mars-double","mars-stroke","mars-stroke-h","mars-stroke-v","mask","medal","medkit","meh","meh-blank","meh-rolling-eyes","memory","menorah","mercury","meteor","microchip","microphone","microphone-alt","microphone-alt-slash","microphone-slash","microscope","minus","minus-circle","minus-square","mitten","mobile","mobile-alt","money-bill","money-bill-alt","money-bill-wave","money-bill-wave-alt","money-check","money-check-alt","monument","moon","mortar-pestle","mosque","motorcycle","mountain","mouse-pointer","mug-hot","music","network-wired","neuter","newspaper","not-equal","notes-medical","object-group","object-ungroup","oil-can","om","otter","outdent","pager","paint-brush","paint-roller","palette","pallet","paper-plane","paperclip","parachute-box","paragraph","parking","passport","pastafarianism","paste","pause","pause-circle","paw","peace","pen","pen-alt","pen-fancy","pen-nib","pen-square","pencil-alt","pencil-ruler","people-carry","pepper-hot","percent","percentage","person-booth","phone","phone-slash","phone-square","phone-volume","piggy-bank","pills","pizza-slice","place-of-worship","plane","plane-arrival","plane-departure","play","play-circle","plug","plus","plus-circle","plus-square","podcast","poll","poll-h","poo","poo-storm","poop","portrait","pound-sign","power-off","pray","praying-hands","prescription","prescription-bottle","prescription-bottle-alt","print","procedures","project-diagram","puzzle-piece","qrcode","question","question-circle","quidditch","quote-left","quote-right","quran","radiation","radiation-alt","rainbow","random","receipt","recycle","redo","redo-alt","registered","reply","reply-all","republican","restroom","retweet","ribbon","ring","road","robot","rocket","route","rss","rss-square","ruble-sign","ruler","ruler-combined","ruler-horizontal","ruler-vertical","running","rupee-sign","sad-cry","sad-tear","satellite","satellite-dish","save","school","screwdriver","scroll","sd-card","search","search-dollar","search-location","search-minus","search-plus","seedling","server","shapes","share","share-alt","share-alt-square","share-square","shekel-sign","shield-alt","ship","shipping-fast","shoe-prints","shopping-bag","shopping-basket","shopping-cart","shower","shuttle-van","sign","sign-in-alt","sign-language","sign-out-alt","signal","signature","sim-card","sitemap","skating","skiing","skiing-nordic","skull","skull-crossbones","slash","sleigh","sliders-h","smile","smile-beam","smile-wink","smog","smoking","smoking-ban","sms","snowboarding","snowflake","snowman","snowplow","socks","solar-panel","sort","sort-alpha-down","sort-alpha-up","sort-amount-down","sort-amount-up","sort-down","sort-numeric-down","sort-numeric-up","sort-up","spa","space-shuttle","spider","spinner","splotch","spray-can","square","square-full","square-root-alt","stamp","star","star-and-crescent","star-half","star-half-alt","star-of-david","star-of-life","step-backward","step-forward","stethoscope","sticky-note","stop","stop-circle","stopwatch","store","store-alt","stream","street-view","strikethrough","stroopwafel","subscript","subway","suitcase","suitcase-rolling","sun","superscript","surprise","swatchbook","swimmer","swimming-pool","synagogue","sync","sync-alt","syringe","table","table-tennis","tablet","tablet-alt","tablets","tachometer-alt","tag","tags","tape","tasks","taxi","teeth","teeth-open","temperature-high","temperature-low","tenge","terminal","text-height","text-width","th","th-large","th-list","theater-masks","thermometer","thermometer-empty","thermometer-full","thermometer-half","thermometer-quarter","thermometer-three-quarters","thumbs-down","thumbs-up","thumbtack","ticket-alt","times","times-circle","tint","tint-slash","tired","toggle-off","toggle-on","toilet","toilet-paper","toolbox","tools","tooth","torah","torii-gate","tractor","trademark","traffic-light","train","tram","transgender","transgender-alt","trash","trash-alt","trash-restore","trash-restore-alt","tree","trophy","truck","truck-loading","truck-monster","truck-moving","truck-pickup","tshirt","tty","tv","umbrella","umbrella-beach","underline","undo","undo-alt","universal-access","university","unlink","unlock","unlock-alt","upload","user","user-alt","user-alt-slash","user-astronaut","user-check","user-circle","user-clock","user-cog","user-edit","user-friends","user-graduate","user-injured","user-lock","user-md","user-minus","user-ninja","user-nurse","user-plus","user-secret","user-shield","user-slash","user-tag","user-tie","user-times","users","users-cog","utensil-spoon","utensils","vector-square","venus","venus-double","venus-mars","vial","vials","video","video-slash","vihara","volleyball-ball","volume-down","volume-mute","volume-off","volume-up","vote-yea","vr-cardboard","walking","wallet","warehouse","water","weight","weight-hanging","wheelchair","wifi","wind","window-close","window-maximize","window-minimize","window-restore","wine-bottle","wine-glass","wine-glass-alt","won-sign","wrench","x-ray","yen-sign","yin-yang");
	var $fa_regular = array("address-book","address-card","angry","arrow-alt-circle-down","arrow-alt-circle-left","arrow-alt-circle-right","arrow-alt-circle-up","bell","bell-slash","bookmark","building","calendar","calendar-alt","calendar-check","calendar-minus","calendar-plus","calendar-times","caret-square-down","caret-square-left","caret-square-right","caret-square-up","chart-bar","check-circle","check-square","circle","clipboard","clock","clone","closed-captioning","comment","comment-alt","comment-dots","comments","compass","copy","copyright","credit-card","dizzy","dot-circle","edit","envelope","envelope-open","eye","eye-slash","file","file-alt","file-archive","file-audio","file-code","file-excel","file-image","file-pdf","file-powerpoint","file-video","file-word","flag","flushed","folder","folder-open","frown","frown-open","futbol","gem","grimace","grin","grin-alt","grin-beam","grin-beam-sweat","grin-hearts","grin-squint","grin-squint-tears","grin-stars","grin-tears","grin-tongue","grin-tongue-squint","grin-tongue-wink","grin-wink","hand-lizard","hand-paper","hand-peace","hand-point-down","hand-point-left","hand-point-right","hand-point-up","hand-pointer","hand-rock","hand-scissors","hand-spock","handshake","hdd","heart","hospital","hourglass","id-badge","id-card","image","images","keyboard","kiss","kiss-beam","kiss-wink-heart","laugh","laugh-beam","laugh-squint","laugh-wink","lemon","life-ring","lightbulb","list-alt","map","meh","meh-blank","meh-rolling-eyes","minus-square","money-bill-alt","moon","newspaper","object-group","object-ungroup","paper-plane","pause-circle","play-circle","plus-square","question-circle","registered","sad-cry","sad-tear","save","share-square","smile","smile-beam","smile-wink","snowflake","square","star","star-half","sticky-note","stop-circle","sun","surprise","thumbs-down","thumbs-up","times-circle","tired","trash-alt","user","user-circle","window-close","window-maximize","window-minimize","window-restore");
	var $fa_brands = array("500px","accessible-icon","accusoft","acquisitions-incorporated","adn","adobe","adversal","affiliatetheme","algolia","alipay","amazon","amazon-pay","amilia","android","angellist","angrycreative","angular","app-store","app-store-ios","apper","apple","apple-pay","artstation","asymmetrik","atlassian","audible","autoprefixer","avianex","aviato","aws","bandcamp","behance","behance-square","bimobject","bitbucket","bitcoin","bity","black-tie","blackberry","blogger","blogger-b","bluetooth","bluetooth-b","btc","buromobelexperte","canadian-maple-leaf","cc-amazon-pay","cc-amex","cc-apple-pay","cc-diners-club","cc-discover","cc-jcb","cc-mastercard","cc-paypal","cc-stripe","cc-visa","centercode","centos","chrome","cloudscale","cloudsmith","cloudversify","codepen","codiepie","confluence","connectdevelop","contao","cpanel","creative-commons","creative-commons-by","creative-commons-nc","creative-commons-nc-eu","creative-commons-nc-jp","creative-commons-nd","creative-commons-pd","creative-commons-pd-alt","creative-commons-remix","creative-commons-sa","creative-commons-sampling","creative-commons-sampling-plus","creative-commons-share","creative-commons-zero","critical-role","css3","css3-alt","cuttlefish","d-and-d","d-and-d-beyond","dashcube","delicious","deploydog","deskpro","dev","deviantart","dhl","diaspora","digg","digital-ocean","discord","discourse","dochub","docker","draft2digital","dribbble","dribbble-square","dropbox","drupal","dyalog","earlybirds","ebay","edge","elementor","ello","ember","empire","envira","erlang","ethereum","etsy","expeditedssl","facebook","facebook-f","facebook-messenger","facebook-square","fantasy-flight-games","fedex","fedora","figma","firefox","first-order","first-order-alt","firstdraft","flickr","flipboard","fly","font-awesome","font-awesome-alt","font-awesome-flag","fonticons","fonticons-fi","fort-awesome","fort-awesome-alt","forumbee","foursquare","free-code-camp","freebsd","fulcrum","galactic-republic","galactic-senate","get-pocket","gg","gg-circle","git","git-square","github","github-alt","github-square","gitkraken","gitlab","gitter","glide","glide-g","gofore","goodreads","goodreads-g","google","google-drive","google-play","google-plus","google-plus-g","google-plus-square","google-wallet","gratipay","grav","gripfire","grunt","gulp","hacker-news","hacker-news-square","hackerrank","hips","hire-a-helper","hooli","hornbill","hotjar","houzz","html5","hubspot","imdb","instagram","intercom","internet-explorer","invision","ioxhost","itunes","itunes-note","java","jedi-order","jenkins","jira","joget","joomla","js","js-square","jsfiddle","kaggle","keybase","keycdn","kickstarter","kickstarter-k","korvue","laravel","lastfm","lastfm-square","leanpub","less","line","linkedin","linkedin-in","linode","linux","lyft","magento","mailchimp","mandalorian","markdown","mastodon","maxcdn","medapps","medium","medium-m","medrt","meetup","megaport","mendeley","microsoft","mix","mixcloud","mizuni","modx","monero","napster","neos","nimblr","nintendo-switch","node","node-js","npm","ns8","nutritionix","odnoklassniki","odnoklassniki-square","old-republic","opencart","openid","opera","optin-monster","osi","page4","pagelines","palfed","patreon","paypal","penny-arcade","periscope","phabricator","phoenix-framework","phoenix-squadron","php","pied-piper","pied-piper-alt","pied-piper-hat","pied-piper-pp","pinterest","pinterest-p","pinterest-square","playstation","product-hunt","pushed","python","qq","quinscape","quora","r-project","raspberry-pi","ravelry","react","reacteurope","readme","rebel","red-river","reddit","reddit-alien","reddit-square","redhat","renren","replyd","researchgate","resolving","rev","rocketchat","rockrms","safari","sass","schlix","scribd","searchengin","sellcast","sellsy","servicestack","shirtsinbulk","shopware","simplybuilt","sistrix","sith","sketch","skyatlas","skype","slack","slack-hash","slideshare","snapchat","snapchat-ghost","snapchat-square","soundcloud","sourcetree","speakap","spotify","squarespace","stack-exchange","stack-overflow","staylinked","steam","steam-square","steam-symbol","sticker-mule","strava","stripe","stripe-s","studiovinari","stumbleupon","stumbleupon-circle","superpowers","supple","suse","teamspeak","telegram","telegram-plane","tencent-weibo","the-red-yeti","themeco","themeisle","think-peaks","trade-federation","trello","tripadvisor","tumblr","tumblr-square","twitch","twitter","twitter-square","typo3","uber","ubuntu","uikit","uniregistry","untappd","ups","usb","usps","ussunnah","vaadin","viacoin","viadeo","viadeo-square","viber","vimeo","vimeo-square","vimeo-v","vine","vk","vnv","vuejs","weebly","weibo","weixin","whatsapp","whatsapp-square","whmcs","wikipedia-w","windows","wix","wizards-of-the-coast","wolf-pack-battalion","wordpress","wordpress-simple","wpbeginner","wpexplorer","wpforms","wpressr","xbox","xing","xing-square","y-combinator","yahoo","yandex","yandex-international","yarn","yelp","yoast","youtube","youtube-square","zhihu");
	var $font_awesome_basic = array("star", "star-o", "check", "close", "lock", "picture-o", "upload", "download", "calendar", "clock-o", "chevron-left", "chevron-right", "phone", "envelope", "envelope-o", "pencil", "angle-double-left", "angle-double-right", "spinner", "smile-o", "frown-o", "meh-o", "send", "send-o", "user", "user-o", "building-o");
	var $sort_methods = array('date-za', 'date-az', 'name-za', 'name-az');
	var $predefined_options = array(
		'countries' => array(
			'label' => 'Countries',
			'options' => array("Afghanistan","Albania","Algeria","American Samoa","Andorra","Angola","Anguilla","Antarctica","Antigua And Barbuda","Argentina","Armenia","Aruba","Australia","Austria","Azerbaijan","Bahamas","Bahrain","Bangladesh","Barbados","Belarus","Belgium","Belize","Benin","Bermuda","Bhutan","Bolivia","Bosnia And Herzegovina","Botswana","Bouvet Island","Brazil","British Indian Ocean Territory","Brunei Darussalam","Bulgaria","Burkina Faso","Burundi","Cambodia","Cameroon","Canada","Cape Verde","Cayman Islands","Central African Republic","Chad","Chile","China","Christmas Island","Cocos (Keeling) Islands","Colombia","Comoros","Congo","Congo, The Democratic Republic Of The","Cook Islands","Costa Rica","Cote D'Ivoire","Croatia (Local Name: Hrvatska)","Cuba","Cyprus","Czech Republic","Denmark","Djibouti","Dominica","Dominican Republic","East Timor","Ecuador","Egypt","El Salvador","Equatorial Guinea","Eritrea","Estonia","Ethiopia","Falkland Islands (Malvinas)","Faroe Islands","Fiji","Finland","France","France, Metropolitan","French Guiana","French Polynesia","French Southern Territories","Gabon","Gambia","Georgia","Germany","Ghana","Gibraltar","Greece","Greenland","Grenada","Guadeloupe","Guam","Guatemala","Guinea","Guinea-Bissau","Guyana","Haiti","Heard And Mc Donald Islands","Holy See (Vatican City State)","Honduras","Hong Kong","Hungary","Iceland","India","Indonesia","Iran (Islamic Republic Of)","Iraq","Ireland","Israel","Italy","Jamaica","Japan","Jordan","Kazakhstan","Kenya","Kiribati","Korea, Democratic People's Republic Of","Korea, Republic Of","Kuwait","Kyrgyzstan","Lao People's Democratic Republic","Latvia","Lebanon","Lesotho","Liberia","Libyan Arab Jamahiriya","Liechtenstein","Lithuania","Luxembourg","Macau","Macedonia, Former Yugoslav Republic Of","Madagascar","Malawi","Malaysia","Maldives","Mali","Malta","Marshall Islands","Martinique","Mauritania","Mauritius","Mayotte","Mexico","Micronesia, Federated States Of","Moldova, Republic Of","Monaco","Mongolia","Montserrat","Morocco","Mozambique","Myanmar","Namibia","Nauru","Nepal","Netherlands","Netherlands Antilles","New Caledonia","New Zealand","Nicaragua","Niger","Nigeria","Niue","Norfolk Island","Northern Mariana Islands","Norway","Oman","Pakistan","Palau","Panama","Papua New Guinea","Paraguay","Peru","Philippines","Pitcairn","Poland","Portugal","Puerto Rico","Qatar","Reunion","Romania","Russian Federation","Rwanda","Saint Kitts And Nevis","Saint Lucia","Saint Vincent And The Grenadines","Samoa","San Marino","Sao Tome And Principe","Saudi Arabia","Senegal","Seychelles","Sierra Leone","Singapore","Slovakia (Slovak Republic)","Slovenia","Solomon Islands","Somalia","South Africa","South Georgia, South Sandwich Islands","Spain","Sri Lanka","St. Helena","St. Pierre And Miquelon","Sudan","Suriname","Svalbard And Jan Mayen Islands","Swaziland","Sweden","Switzerland","Syrian Arab Republic","Taiwan","Tajikistan","Tanzania, United Republic Of","Thailand","Togo","Tokelau","Tonga","Trinidad And Tobago","Tunisia","Turkey","Turkmenistan","Turks And Caicos Islands","Tuvalu","Uganda","Ukraine","United Arab Emirates","United Kingdom","United States","United States Minor Outlying Islands","Uruguay","Uzbekistan","Vanuatu","Venezuela","Vietnam","Virgin Islands (British)","Virgin Islands (U.S.)","Wallis And Futuna Islands","Western Sahara","Yemen","Yugoslavia","Zambia","Zimbabwe")
		),
		'us-states' => array(
			'label' => 'U.S. States',
			'options' => array("Alabama","Alaska","Arizona","Arkansas","California","Colorado","Connecticut","Delaware","District Of Columbia","Florida","Georgia","Hawaii","Idaho","Illinois","Indiana","Iowa","Kansas","Kentucky","Louisiana","Maine","Maryland","Massachusetts","Michigan","Minnesota","Mississippi","Missouri","Montana","Nebraska","Nevada","New Hampshire","New Jersey","New Mexico","New York","North Carolina","North Dakota","Ohio","Oklahoma","Oregon","Pennsylvania","Rhode Island","South Carolina","South Dakota","Tennessee","Texas","Utah","Vermont","Virginia","Washington","West Virginia","Wisconsin","Wyoming")
		),
		'canadian-provinces' => array(
			'label' => 'Canadian Provinces',
			'options' => array("Alberta","British Columbia","Manitoba","New Brunswick","Newfoundland & Labrador","Northwest Territories","Nova Scotia","Nunavut","Ontario","Prince Edward Island","Quebec","Saskatchewan","Yukon")
		),
		'uk-counties' => array(
			'label' => 'UK Counties',
			'options' => array("Aberdeen City","Aberdeenshire","Angus","Antrim","Argyll and Bute","Armagh","Avon","Banffshire","Bedfordshire","Berkshire","Blaenau Gwent","Borders","Bridgend","Bristol","Buckinghamshire","Caerphilly","Cambridgeshire","Cardiff","Carmarthenshire","Ceredigion","Channel Islands","Cheshire","Clackmannan","Cleveland","Conwy","Cornwall","Cumbria","Denbighshire","Derbyshire","Devon","Dorset","Down","Dumfries and Galloway","Durham","East Ayrshire","East Dunbartonshire","East Lothian","East Renfrewshire","East Riding of Yorkshire","East Sussex","Edinburgh City","Essex","Falkirk","Fermanagh","Fife","Flintshire","Glasgow (City of)","Gloucestershire","Greater Manchester","Gwynedd","Hampshire","Herefordshire","Hertfordshire","Highland","Humberside","Inverclyde","Isle of Anglesey","Isle of Man","Isle of Wight","Isles of Scilly","Kent","Lancashire","Leicestershire","Lincolnshire","London","Londonderry","Merseyside","Merthyr Tydfil","Middlesex","Midlothian","Monmouthshire","Moray","Neath Port Talbot","Newport","Norfolk","North Ayrshire","North East Lincolnshire","North Lanarkshire","North Yorkshire","Northamptonshire","Northumberland","Nottinghamshire","Orkney","Oxfordshire","Pembrokeshire","Perthshire and Kinross","Powys","Renfrewshire","Rhondda Cynon Taff","Roxburghshire","Rutland","Shetland","Shropshire","Somerset","South Ayrshire","South Lanarkshire","South Yorkshire","Staffordshire","Stirling","Suffolk","Surrey","Swansea","The Vale of Glamorgan","Torfaen","Tyne and Wear","Tyrone","Warwickshire","West Dunbartonshire","West Lothian","West Midlands","West Sussex","West Yorkshire","Western Isles","Wiltshire","Worcestershire","Wrexham")
		),
		'german-states' => array(
			'label' => 'German States',
			'options' => array("Baden-Wurttemberg","Bavaria","Berlin","Brandenburg","Bremen","Hamburg","Hesse","Lower Saxony","Mecklenburg-West Pomerania","North Rhine-Westphalia","Rhineland-Palatinate","Saarland","Saxony","Saxony-Anhalt","Schleswig-Holstein","Thuringia")
		),
		'dutch-provinces' => array(
			'label' => 'Dutch Provinces',
			'options' => array("Drente","Flevoland","Friesland","Gelderland","Groningen","Limburg","Noord-Brabant","Noord-Holland","Overijssel","Utrecht","Zeeland","Zuid-Holland")
		),
		'australian-states' => array(
			'label' => 'Australian States',
			'options' => array("Australian Capital Territory","New South Wales","Northern Territory","Queensland","South Australia","Tasmania","Victoria","Western Australia")
		),
		'continents' => array(
			'label' => 'Continents',
			'options' => array("Africa","Antarctica","Asia","Australia","Europe","North America","South America")
		),
		'days' => array(
			'label' => 'Days',
			'options' => array("Monday","Tuesday","Wednesday","Thursday","Friday","Saturday","Sunday")
		),
		'months' => array(
			'label' => 'Months',
			'options' => array("January","February","March","April","May","June","July","August","September","October","November","December")
		)
	);
	var $advanced_options = array(
		'enable-custom-js' => 'off',
		'enable-htmlform' => 'off',
		'enable-activecampaign' => 'off',
		'enable-activetrail' => 'off',
		'enable-agilecrm' => 'off',
		'enable-avangemail' => 'off',
		'enable-aweber' => 'off',
		'enable-campaignmonitor' => 'off',
		'enable-conversio' => 'off',
		'enable-freshmail' => 'off',
		'enable-getresponse' => 'off',
		'enable-jetpack' => 'off',
		'enable-madmimi' => 'off',
		'enable-mailautic' => 'off',
		'enable-mailchimp' => 'on',
		'enable-mailerlite' => 'off',
		'enable-mailpoet' => 'off',
		'enable-mailster' => 'off',
		'enable-mailwizz' => 'off',
		'enable-mumara' => 'off',
		'enable-omnisend' => 'off',
		'enable-ontraport' => 'off',
		'enable-rapidmail' => 'off',
		'enable-zohocrm' => 'off',
		'enable-blockchain' => 'off',
		'enable-interkassa' => 'off',
		'enable-paypal' => 'off',
		'enable-perfectmoney' => 'off',
		'enable-skrill' => 'off',
		'enable-stripe' => 'off',
		'minified-sources' => 'on'
	);
	function __construct() {
		global $leform_admin;
		if (function_exists('load_plugin_textdomain')) {
			load_plugin_textdomain('leform', false, dirname(plugin_basename(__FILE__)).'/languages/');
		}
		$this->plugins_url = plugins_url('', __FILE__);
		
		$url = get_bloginfo('url');
		$domain = parse_url($url, PHP_URL_HOST);
		$this->options = array(
			"version" => LEFORM_VERSION,
			"update-time" => time(),
			"webfonts_version" => 0,
			"from-name" => get_bloginfo('name'),
			"from-email" => "noreply@".str_replace("www.", "", $domain),
			"fa-enable" => "off",
			"fa-solid-enable" => "on",
			"fa-regular-enable" => "off",
			"fa-brands-enable" => "off",
			"fa-css-disable" => "off",
			"ga-tracking" => "off",
			"mask-enable" => "off",
			"mask-js-disable" => "off",
			"airdatepicker-enable" => "on",
			"airdatepicker-js-disable" => "off",
			"jsep-enable" => "off",
			"jsep-js-disable" => "off",
			"purchase-code" => "",
			"sort-forms" => 'date-za',
			"sort-log" => 'date-za',
			"gettingstarted-enable" => 'on'
		);

		$this->get_options();
		$this->get_advanced_options();

		$autocomplete_options = array(
			'off' => esc_html__('None', 'leform'),
			'name' => esc_html__('Full Name', 'leform').' (name)',
			'given-name' => esc_html__('First Name', 'leform').' (given-name)',
			'additional-name' => esc_html__('Middle Name', 'leform').' (additional-name)',
			'family-name' => esc_html__('Last Name', 'leform').' (family-name)',
			'email' => esc_html__('Email', 'leform').' (email)',
			'tel' => esc_html__('Phone', 'leform').' (tel)',
			'street-address' => esc_html__('Single Address Line', 'leform').' (street-address)',
			'address-line1' => esc_html__('Address Line 1', 'leform').' (address-line1)',
			'address-line2' => esc_html__('Address Line 2', 'leform').' (address-line2)',
			'address-level1' => esc_html__('State or Province', 'leform').' (address-level1)',
			'address-level2' => esc_html__('City', 'leform').' (address-level2)',
			'postal-code' => esc_html__('ZIP Code', 'leform').' (postal-code)',
			'country' => esc_html__('Country', 'leform').' (country)',
			'cc-name' => esc_html__('Name on Card', 'leform').' (cc-name)',
			'cc-number' => esc_html__('Card Number', 'leform').' (cc-number)',
			'cc-csc' => esc_html__('CVC', 'leform').' (cc-csc)',
			'cc-exp-month' => esc_html__('Expiry (month)', 'leform').' (cc-exp-month)',
			'cc-exp-year' => esc_html__('Expiry (year)', 'leform').' (cc-exp-year)',
			'cc-exp' => esc_html__('Expiry', 'leform').' (cc-exp)',
			'cc-type' => esc_html__('Card Type', 'leform').' (cc-type)'
		);
		$this->element_properties_meta = array(
			'settings' => array(
				'general-tab' => array('type' => 'tab', 'value' => 'general', 'label' => esc_html__('General', 'leform')),
					'name' => array('value' => esc_html__('Untitled', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name helps to identify the form.', 'leform'), 'type' => 'text'),
					'active' => array('value' => 'on', 'label' => esc_html__('Active', 'leform'), 'tooltip' => esc_html__('Inactive forms will not appear on the site.', 'leform'), 'type' => 'checkbox'),
					'key-fields' => array('value' => array('primary' => '', 'secondary' => ''), 'caption' => array('primary' => esc_html__('Primary field', 'leform'), 'secondary' => esc_html__('Secondary field', 'leform')), 'placeholder' => array('primary' => esc_html__('Select primary field', 'leform'), 'secondary' => esc_html__('Select secondary field', 'leform')), 'label' => esc_html__('Key fields', 'leform'), 'tooltip' => esc_html__('The values of these fields are displayed on Log page in relevant columns.', 'leform'), 'type' => 'key-fields'),
					'datetime-args' => array('value' => array('date-format' => 'yyyy-mm-dd', 'time-format' => 'hh:ii', 'locale' => 'en'), 'label' => esc_html__('Date and time parameters', 'leform'), 'tooltip' => esc_html__('Choose the date and time formats and language for datetimepicker. It is used for "date" and "time" fields.', 'leform'), 'type' => 'datetime-args', 'date-format-options' => array('yyyy-mm-dd' => 'YYYY-MM-DD', 'mm/dd/yyyy' => 'MM/DD/YYYY', 'dd/mm/yyyy' => 'DD/MM/YYYY', 'dd.mm.yyyy' => 'DD.MM.YYYY'), 'date-format-label' => esc_html__('Date format', 'leform'), 'time-format-options' => array('hh:ii aa' => '12 hours', 'hh:ii' => '24 hours'), 'time-format-label' => esc_html__('Time format', 'leform'), 'locale-options' => array('en', 'cs', 'da', 'de', 'es', 'fi', 'fr', 'hu', 'nl', 'pl', 'pt', 'ro', 'ru', 'sk', 'zh'), 'locale-label' => esc_html__('Language', 'leform')),
				'style-tab' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'style-sections' => array('type' => 'sections', 'sections' => array(
						'global' => array('label' => esc_html__('Global', 'leform'), 'icon' => 'fas fa-globe'),
						'labels' => array('label' => esc_html__('Labels', 'leform'), 'icon' => 'fas fa-font'),
						'inputs' => array('label' => esc_html__('Inputs', 'leform'), 'icon' => 'fas fa-pencil-alt'),
						'buttons' => array('label' => esc_html__('Buttons', 'leform'), 'icon' => 'far fa-paper-plane'),
						'errors' => array('label' => esc_html__('Errors', 'leform'), 'icon' => 'far fa-hand-paper'),
						'progress' => array('label' => esc_html__('Progress Bar', 'leform'), 'icon' => 'fas fa-sliders-h')
					)),
					'start-global' => array('type' => 'section-start', 'section' => 'global'),
						'text-style' => array('value' => array('family' => 'arial', 'size' => '15', 'color' => '#444', 'bold' => 'off', 'italic' => 'off', 'underline' => 'off', 'align' => 'left'), 'caption' => array('family' => esc_html__('Font family', 'leform'), 'size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform'), 'style' => esc_html__('Style', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Text style', 'leform'), 'tooltip' => esc_html__('Adjust the text style.', 'leform'), 'type' => 'text-style'),
						'hr-1' => array('type' => 'hr'),
						'wrapper-style-sections' => array('type' => 'sections', 'sections' => array(
							'wrapper-inline' => array('label' => esc_html__('Inline Mode', 'leform'), 'icon' => 'fab fa-wpforms'),
							'wrapper-popup' => array('label' => esc_html__('Popup Mode', 'leform'), 'icon' => 'far fa-window-maximize'),
						)),
						'start-wrapper-inline' => array('type' => 'section-start', 'section' => 'wrapper-inline'),
							'inline-background-style' => array('value' => array('image' => '', 'size' => 'auto', 'position' => 'left', 'repeat' => 'repeat', 'color' => '', 'shades' => 'off'), 'caption' => array('image' => esc_html__('Image URL', 'leform'), 'size' => esc_html__('Size', 'leform'), 'position' => esc_html__('Position', 'leform'), 'repeat' => esc_html__('Repeat', 'leform'), 'color' => esc_html__('Color', 'leform'), 'shades' => esc_html__('2 shades', 'leform')), 'label' => esc_html__('Wrapper background', 'leform'), 'tooltip' => esc_html__('Adjust the background style for inline view of the form.', 'leform'), 'type' => 'background-style'),
							'inline-border-style' => array('value' => array('width' => '0', 'style' => 'solid', 'radius' => '0', 'color' => '', 'top' => 'off', 'right' => 'off', 'bottom' => 'off', 'left' => 'off'), 'caption' => array('width' => esc_html__('Width', 'leform'), 'style' => esc_html__('Style', 'leform'), 'radius' => esc_html__('Radius', 'leform'), 'color' => esc_html__('Color', 'leform'), 'border' => esc_html__('Border', 'leform')), 'label' => esc_html__('Wrapper border', 'leform'), 'tooltip' => esc_html__('Adjust the border style for inline view of the form.', 'leform'), 'type' => 'border-style'),
							'inline-shadow' => array('value' => array('size' => '', 'color' => '#444'), 'caption' => array('size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform')), 'label' => esc_html__('Wrapper shadow', 'leform'), 'tooltip' => esc_html__('Adjust the shadow for inline view of the form.', 'leform'), 'type' => 'shadow'),
							'inline-padding' => array('value' => array('top' => '20', 'right' => '20', 'bottom' => '20', 'left' => '20'), 'caption' => array('top' => esc_html__('Top', 'leform'), 'right' => esc_html__('Right', 'leform'), 'bottom' => esc_html__('Bottom', 'leform'), 'left' => esc_html__('Left', 'leform')), 'label' => esc_html__('Padding', 'leform'), 'tooltip' => esc_html__('Adjust the padding for inline view of the form.', 'leform'), 'type' => 'padding'),
						'end-wrapper-inline' => array('type' => 'section-end'),
						'start-wrapper-popup' => array('type' => 'section-start', 'section' => 'wrapper-popup'),
							'popup-background-style' => array('value' => array('image' => '', 'size' => 'auto', 'position' => 'left', 'repeat' => 'repeat', 'color' => '#ffffff', 'shades' => 'off'), 'caption' => array('image' => esc_html__('Image URL', 'leform'), 'size' => esc_html__('Size', 'leform'), 'position' => esc_html__('Position', 'leform'), 'repeat' => esc_html__('Repeat', 'leform'), 'color' => esc_html__('Color', 'leform'), 'shades' => esc_html__('2 shades', 'leform')), 'label' => esc_html__('Popup background', 'leform'), 'tooltip' => esc_html__('Adjust the background style for popup view of the form.', 'leform'), 'type' => 'background-style'),
							'popup-border-style' => array('value' => array('width' => '0', 'style' => 'solid', 'radius' => '5', 'color' => '', 'top' => 'off', 'right' => 'off', 'bottom' => 'off', 'left' => 'off'), 'caption' => array('width' => esc_html__('Width', 'leform'), 'style' => esc_html__('Style', 'leform'), 'radius' => esc_html__('Radius', 'leform'), 'color' => esc_html__('Color', 'leform'), 'border' => esc_html__('Border', 'leform')), 'label' => esc_html__('Popup border', 'leform'), 'tooltip' => esc_html__('Adjust the border style for popup view of the form.', 'leform'), 'type' => 'border-style'),
							'popup-shadow' => array('value' => array('size' => 'huge', 'color' => '#000'), 'caption' => array('size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform')), 'label' => esc_html__('Popup shadow', 'leform'), 'tooltip' => esc_html__('Adjust the shadow for popup view of the form.', 'leform'), 'type' => 'shadow'),
							'popup-padding' => array('value' => array('top' => '20', 'right' => '20', 'bottom' => '20', 'left' => '20'), 'caption' => array('top' => esc_html__('Top', 'leform'), 'right' => esc_html__('Right', 'leform'), 'bottom' => esc_html__('Bottom', 'leform'), 'left' => esc_html__('Left', 'leform')), 'label' => esc_html__('Padding', 'leform'), 'tooltip' => esc_html__('Adjust the padding for popup view of the form.', 'leform'), 'type' => 'padding'),
							'popup-overlay-color' => array('value' => 'rgba(255,255,255,0.7)', 'label' => esc_html__('Overlay color', 'leform'), 'tooltip' => esc_html__('Adjust the overlay color.', 'leform'), 'type' => 'color'),
							'popup-close-color' => array('value' => array('color1' => '#FF9800', 'color2' => '#FFC107'), 'label' => esc_html__('Close icon colors', 'leform'), 'tooltip' => esc_html__('Adjust the color of the close icon.', 'leform'), 'caption' => array('color1' => esc_html__('Color', 'leform'), 'color2' => esc_html__('Hover color', 'leform')), 'type' => 'two-colors'),
							'popup-spinner-color' => array('value' => array('color1' => '#FF5722', 'color2' => '#FF9800', 'color3' => '#FFC107'), 'label' => esc_html__('Spinner colors', 'leform'), 'tooltip' => esc_html__('Adjust the color of the spinner.', 'leform'), 'caption' => array('color1' => esc_html__('Small circle', 'leform'), 'color2' => esc_html__('Middle circle', 'leform'), 'color3' => esc_html__('Large circle', 'leform')), 'type' => 'three-colors'),
						'end-wrapper-popup' => array('type' => 'section-end'),
						'hr-2' => array('type' => 'hr'),
						'max-width' => array('value' => array('value' =>'720', 'unit' => 'px', 'position' => 'center'), 'label' => esc_html__('Form width', 'leform'), 'tooltip' => esc_html__('Specify the maximum form width and its alignment. Leave this field empty to set maximum form width as 100%.', 'leform'), 'caption' => array('value' => esc_html__('Width', 'leform'), 'unit' => esc_html__('Units', 'leform'), 'position' => esc_html__('Position', 'leform')), 'type' => 'block-width'),
						'element-spacing' => array('value' => '20', 'label' => esc_html__('Element spacing', 'leform'), 'tooltip' => esc_html__('Specify the spacing between form elements.', 'leform'), 'unit' => 'px', 'type' => 'units'),
						'responsiveness' => array('value' => array('size' =>'480', 'custom' => '480'), 'caption' => array('size' => esc_html__('Width', 'leform'), 'custom' => esc_html__('Custom', 'leform')), 'label' => esc_html__('Responsiveness', 'leform'), 'tooltip' => esc_html__('At what form width should column layouts be stacked.', 'leform'), 'type' => 'select-size', 'options' => array('480' => esc_html__('Phone portrait (480px)', 'leform'), '768' => esc_html__('Phone landscape (768px)', 'leform'), '1024' => esc_html__('Tablet (1024px)', 'leform'), 'custom' => esc_html__('Custom', 'leform'))),
					'end-global' => array('type' => 'section-end'),
					'start-labels' => array('type' => 'section-start', 'section' => 'labels'),
						'label-text-style' => array('value' => array('family' => '', 'size' => '16', 'color' => '#444', 'bold' => 'on', 'italic' => 'off', 'underline' => 'off', 'align' => 'left'), 'caption' => array('family' => esc_html__('Font family', 'leform'), 'size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform'), 'style' => esc_html__('Style', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label text style', 'leform'), 'tooltip' => esc_html__('Adjust the text style of labels.', 'leform'), 'type' => 'text-style'),
						'label-style' => array('value' => array('position' => 'top', 'width' => '3'), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform')), 'label' => esc_html__('Label position', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field.', 'leform'), 'type' => 'label-position'),
						'description-text-style' => array('value' => array('family' => '', 'size' => '14', 'color' => '#888', 'bold' => 'off', 'italic' => 'on', 'underline' => 'off', 'align' => 'left'), 'caption' => array('family' => esc_html__('Font family', 'leform'), 'size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform'), 'style' => esc_html__('Style', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Description text style', 'leform'), 'tooltip' => esc_html__('Adjust the text style of descriptions.', 'leform'), 'type' => 'text-style'),
						'description-style' => array('value' => array('position' => 'bottom'), 'caption' => array('position' => esc_html__('Position', 'leform')), 'label' => esc_html__('Description position', 'leform'), 'tooltip' => esc_html__('Choose where to display the description relative to the field.', 'leform'), 'type' => 'description-position'),
					'end-labels' => array('type' => 'section-end'),
					'start-inputs' => array('type' => 'section-start', 'section' => 'inputs'),
						'input-size' => array('value' => 'medium', 'label' => esc_html__('Input size', 'leform'), 'tooltip' => esc_html__('Choose the size of input fields.', 'leform'), 'type' => 'select', 'options' => array('tiny' => esc_html__('Tiny', 'leform'), 'small' => esc_html__('Small', 'leform'), 'medium' => esc_html__('Medium', 'leform'), 'large' => esc_html__('Large', 'leform'), 'huge' => esc_html__('Huge', 'leform'))),
						'input-icon' => array('value' => array('position' => 'inside', 'size' => '20', 'color' => '#444', 'background' => '', 'border' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform'), 'background' => esc_html__('Background', 'leform'), 'border' => esc_html__('Border', 'leform')), 'label' => esc_html__('Icon style', 'leform'), 'tooltip' => esc_html__('Adjust the style of input field icons.', 'leform'), 'type' => 'icon-style'),
						'textarea-height' => array('value' => '160', 'label' => esc_html__('Textarea height', 'leform'), 'tooltip' => esc_html__('Set the height of textarea fields.', 'leform'), 'unit' => 'px', 'type' => 'units'),
						'input-style-sections' => array('type' => 'sections', 'sections' => array(
							'inputs-default' => array('label' => esc_html__('Default', 'leform'), 'icon' => 'fas fa-globe'),
							'inputs-hover' => array('label' => esc_html__('Hover', 'leform'), 'icon' => 'far fa-hand-pointer'),
							'inputs-focus' => array('label' => esc_html__('Focus', 'leform'), 'icon' => 'fas fa-i-cursor')
						)),
						'start-inputs-default' => array('type' => 'section-start', 'section' => 'inputs-default'),
							'input-text-style' => array('value' => array('family' => '', 'size' => '15', 'color' => '#444', 'bold' => 'off', 'italic' => 'off', 'underline' => 'off', 'align' => 'left'), 'caption' => array('family' => esc_html__('Font family', 'leform'), 'size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform'), 'style' => esc_html__('Style', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Input text', 'leform'), 'tooltip' => esc_html__('Adjust the text style of input fields.', 'leform'), 'type' => 'text-style'),
							'input-background-style' => array('value' => array('image' => '', 'size' => 'auto', 'position' => 'left', 'repeat' => 'repeat', 'color' => '#fff', 'shades' => 'off'), 'caption' => array('image' => esc_html__('Image URL', 'leform'), 'size' => esc_html__('Size', 'leform'), 'position' => esc_html__('Position', 'leform'), 'repeat' => esc_html__('Repeat', 'leform'), 'color' => esc_html__('Color', 'leform'), 'shades' => esc_html__('2 shades', 'leform')), 'label' => esc_html__('Input background', 'leform'), 'tooltip' => esc_html__('Adjust the background of input fields.', 'leform'), 'type' => 'background-style'),
							'input-border-style' => array('value' => array('width' => '1', 'style' => 'solid', 'radius' => '0', 'color' => '#ccc', 'top' => 'on', 'right' => 'on', 'bottom' => 'on', 'left' => 'on'), 'caption' => array('width' => esc_html__('Width', 'leform'), 'style' => esc_html__('Style', 'leform'), 'radius' => esc_html__('Radius', 'leform'), 'color' => esc_html__('Color', 'leform'), 'border' => esc_html__('Border', 'leform')), 'label' => esc_html__('Input border', 'leform'), 'tooltip' => esc_html__('Adjust the border style of input fields.', 'leform'), 'type' => 'border-style'),
							'input-shadow' => array('value' => array('size' => '', 'color' => '#444'), 'caption' => array('size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform')), 'label' => esc_html__('Input shadow', 'leform'), 'tooltip' => esc_html__('Adjust the shadow of input fields.', 'leform'), 'type' => 'shadow'),
						'end-inputs-default' => array('type' => 'section-end'),
						'start-inputs-hover' => array('type' => 'section-start', 'section' => 'inputs-hover'),
							'input-hover-inherit' => array('value' => 'on', 'label' => esc_html__('Inherit default style', 'leform'), 'tooltip' => esc_html__('Use the same style as for default state.', 'leform'), 'type' => 'checkbox'),
							'input-hover-text-style' => array('value' => array('family' => '', 'size' => '15', 'color' => '#444', 'bold' => 'off', 'italic' => 'off', 'underline' => 'off', 'align' => 'left'), 'caption' => array('family' => esc_html__('Font family', 'leform'), 'size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform'), 'style' => esc_html__('Style', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Input text', 'leform'), 'tooltip' => esc_html__('Adjust the text style of hovered input fields.', 'leform'), 'type' => 'text-style', 'visible' => array('input-hover-inherit' => array('off'))),
							'input-hover-background-style' => array('value' => array('image' => '', 'size' => 'auto', 'position' => 'left', 'repeat' => 'repeat', 'color' => '#fff', 'shades' => 'off'), 'caption' => array('image' => esc_html__('Image URL', 'leform'), 'size' => esc_html__('Size', 'leform'), 'position' => esc_html__('Position', 'leform'), 'repeat' => esc_html__('Repeat', 'leform'), 'color' => esc_html__('Color', 'leform'), 'shades' => esc_html__('2 shades', 'leform')), 'label' => esc_html__('Input background', 'leform'), 'tooltip' => esc_html__('Adjust the background of hovered input fields.', 'leform'), 'type' => 'background-style', 'visible' => array('input-hover-inherit' => array('off'))),
							'input-hover-border-style' => array('value' => array('width' => '1', 'style' => 'solid', 'radius' => '0', 'color' => '#ccc', 'top' => 'on', 'right' => 'on', 'bottom' => 'on', 'left' => 'on'), 'caption' => array('width' => esc_html__('Width', 'leform'), 'style' => esc_html__('Style', 'leform'), 'radius' => esc_html__('Radius', 'leform'), 'color' => esc_html__('Color', 'leform'), 'border' => esc_html__('Border', 'leform')), 'label' => esc_html__('Input border', 'leform'), 'tooltip' => esc_html__('Adjust the border style of hovered input fields.', 'leform'), 'type' => 'border-style', 'visible' => array('input-hover-inherit' => array('off'))),
							'input-hover-shadow' => array('value' => array('size' => '', 'color' => '#444'), 'caption' => array('size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform')), 'label' => esc_html__('Input shadow', 'leform'), 'tooltip' => esc_html__('Adjust the shadow of hovered input fields.', 'leform'), 'type' => 'shadow', 'visible' => array('input-hover-inherit' => array('off'))),
						'end-inputs-hover' => array('type' => 'section-end'),
						'start-inputs-focus' => array('type' => 'section-start', 'section' => 'inputs-focus'),
							'input-focus-inherit' => array('value' => 'on', 'label' => esc_html__('Inherit default style', 'leform'), 'tooltip' => esc_html__('Use the same style as for default state.', 'leform'), 'type' => 'checkbox'),
							'input-focus-text-style' => array('value' => array('family' => '', 'size' => '15', 'color' => '#444', 'bold' => 'off', 'italic' => 'off', 'underline' => 'off', 'align' => 'left'), 'caption' => array('family' => esc_html__('Font family', 'leform'), 'size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform'), 'style' => esc_html__('Style', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Input text', 'leform'), 'tooltip' => esc_html__('Adjust the text style of focused input fields.', 'leform'), 'type' => 'text-style', 'visible' => array('input-focus-inherit' => array('off'))),
							'input-focus-background-style' => array('value' => array('image' => '', 'size' => 'auto', 'position' => 'left', 'repeat' => 'repeat', 'color' => '#fff', 'shades' => 'off'), 'caption' => array('image' => esc_html__('Image URL', 'leform'), 'size' => esc_html__('Size', 'leform'), 'position' => esc_html__('Position', 'leform'), 'repeat' => esc_html__('Repeat', 'leform'), 'color' => esc_html__('Color', 'leform'), 'shades' => esc_html__('2 shades', 'leform')), 'label' => esc_html__('Input background', 'leform'), 'tooltip' => esc_html__('Adjust the background of focused input fields.', 'leform'), 'type' => 'background-style', 'visible' => array('input-focus-inherit' => array('off'))),
							'input-focus-border-style' => array('value' => array('width' => '1', 'style' => 'solid', 'radius' => '0', 'color' => '#ccc', 'top' => 'on', 'right' => 'on', 'bottom' => 'on', 'left' => 'on'), 'caption' => array('width' => esc_html__('Width', 'leform'), 'style' => esc_html__('Style', 'leform'), 'radius' => esc_html__('Radius', 'leform'), 'color' => esc_html__('Color', 'leform'), 'border' => esc_html__('Border', 'leform')), 'label' => esc_html__('Input border', 'leform'), 'tooltip' => esc_html__('Adjust the border style of focused input fields.', 'leform'), 'type' => 'border-style', 'visible' => array('input-focus-inherit' => array('off'))),
							'input-focus-shadow' => array('value' => array('size' => '', 'color' => '#444'), 'caption' => array('size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform')), 'label' => esc_html__('Input shadow', 'leform'), 'tooltip' => esc_html__('Adjust the shadow of focused input fields.', 'leform'), 'type' => 'shadow', 'visible' => array('input-focus-inherit' => array('off'))),
						'end-inputs-focus' => array('type' => 'section-end'),
						'hr-5' => array('type' => 'hr'),
						'checkbox-radio-style' => array('value' => array('position' => 'left', 'size' => 'medium', 'align' => 'left', 'layout' => '1'), 'caption' => array('position' => esc_html__('Position', 'leform'), 'size' => esc_html__('Size', 'leform'), 'align' => esc_html__('Alignment', 'leform'), 'layout' => esc_html__('Layout', 'leform')), 'label' => esc_html__('Checkbox and radio style', 'leform'), 'tooltip' => esc_html__('Choose how to display checkbox and radio button fields and their captions.', 'leform'), 'type' => 'checkbox-radio-style'),
						'checkbox-view' => array('value' => 'classic', 'options' => array('classic', 'fa-check', 'square', 'tgl'), 'label' => esc_html__('Checkbox view', 'leform'), 'tooltip' => esc_html__('Choose the checkbox style.', 'leform'), 'type' => 'checkbox-view'),
						'radio-view' => array('value' => 'classic', 'options' => array('classic', 'fa-check', 'dot'), 'label' => esc_html__('Radio button view', 'leform'), 'tooltip' => esc_html__('Choose the radio button style.', 'leform'), 'type' => 'radio-view'),
						'checkbox-radio-sections' => array('type' => 'sections', 'sections' => array(
							'checkbox-radio-unchecked' => array('label' => esc_html__('Unchecked', 'leform'), 'icon' => 'far fa-square'),
							'checkbox-radio-checked' => array('label' => esc_html__('Checked', 'leform'), 'icon' => 'far fa-check-square')
						)),
						'start-checkbox-radio-unchecked' => array('type' => 'section-start', 'section' => 'checkbox-radio-unchecked'),
							'checkbox-radio-unchecked-color' => array('value' => array('color1' => '#ccc', 'color2' => '#fff', 'color3' => '#444'), 'label' => esc_html__('Checkbox and radio colors', 'leform'), 'tooltip' => esc_html__('Adjust colors of checkboxes and radio buttons.', 'leform'), 'caption' => array('color1' => 'Border', 'color2' => 'Background', 'color3' => 'Mark'), 'type' => 'three-colors'),
						'end-checkbox-radio-unchecked' => array('type' => 'section-end'),
						'start-checkbox-radio-checked' => array('type' => 'section-start', 'section' => 'checkbox-radio-checked'),
							'checkbox-radio-checked-inherit' => array('value' => 'on', 'label' => esc_html__('Inherit colors', 'leform'), 'tooltip' => esc_html__('Use the same colors as for unchecked state.', 'leform'), 'type' => 'checkbox'),
							'checkbox-radio-checked-color' => array('value' => array('color1' => '#ccc', 'color2' => '#fff', 'color3' => '#444'), 'label' => esc_html__('Checkbox and radio colors', 'leform'), 'tooltip' => esc_html__('Adjust colors of checkboxes and radio buttons.', 'leform'), 'caption' => array('color1' => 'Border', 'color2' => 'Background', 'color3' => 'Mark'), 'type' => 'three-colors', 'visible' => array('checkbox-radio-checked-inherit' => array('off'))),
						'end-checkbox-radio-checked' => array('type' => 'section-end'),
						'hr-6' => array('type' => 'hr'),
						'imageselect-style' => array('value' => array('align' =>'left', 'effect' => 'none'), 'caption' => array('align' => esc_html__('Alignment', 'leform'), 'effect' => esc_html__('Effect', 'leform')), 'label' => esc_html__('Image Select style', 'leform'), 'tooltip' => esc_html__('Adjust image alignment and effect.', 'leform'), 'type' => 'imageselect-style', 'options' => array('none' => esc_html__('None', 'leform'), 'grayscale' => esc_html__('Grayscale', 'leform'))),
						'imageselects-style-sections' => array('type' => 'sections', 'sections' => array(
							'imageselects-default' => array('label' => esc_html__('Default', 'leform'), 'icon' => 'fas fa-globe'),
							'imageselects-hover' => array('label' => esc_html__('Hover', 'leform'), 'icon' => 'far fa-hand-pointer'),
							'imageselects-selected' => array('label' => esc_html__('Selected', 'leform'), 'icon' => 'far fa-check-square')
						)),
						'start-imageselects-default' => array('type' => 'section-start', 'section' => 'imageselects-default'),
							'imageselect-border-style' => array('value' => array('width' => '1', 'style' => 'solid', 'radius' => '0', 'color' => '#ccc', 'top' => 'on', 'right' => 'on', 'bottom' => 'on', 'left' => 'on'), 'caption' => array('width' => esc_html__('Width', 'leform'), 'style' => esc_html__('Style', 'leform'), 'radius' => esc_html__('Radius', 'leform'), 'color' => esc_html__('Color', 'leform'), 'border' => esc_html__('Border', 'leform')), 'label' => esc_html__('Image border', 'leform'), 'tooltip' => esc_html__('Adjust the border style of images.', 'leform'), 'type' => 'border-style'),
							'imageselect-shadow' => array('value' => array('size' => '', 'color' => '#444'), 'caption' => array('size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform')), 'label' => esc_html__('Image shadow', 'leform'), 'tooltip' => esc_html__('Adjust the shadow of images.', 'leform'), 'type' => 'shadow'),
						'end-imageselects-default' => array('type' => 'section-end'),
						'start-imageselects-hover' => array('type' => 'section-start', 'section' => 'imageselects-hover'),
							'imageselect-hover-inherit' => array('value' => 'on', 'label' => esc_html__('Inherit default style', 'leform'), 'tooltip' => esc_html__('Use the same style as for default state.', 'leform'), 'type' => 'checkbox'),
							'imageselect-hover-border-style' => array('value' => array('width' => '1', 'style' => 'solid', 'radius' => '0', 'color' => '#ccc', 'top' => 'on', 'right' => 'on', 'bottom' => 'on', 'left' => 'on'), 'caption' => array('width' => esc_html__('Width', 'leform'), 'style' => esc_html__('Style', 'leform'), 'radius' => esc_html__('Radius', 'leform'), 'color' => esc_html__('Color', 'leform'), 'border' => esc_html__('Border', 'leform')), 'label' => esc_html__('Image border', 'leform'), 'tooltip' => esc_html__('Adjust the border style of hovered images.', 'leform'), 'type' => 'border-style', 'visible' => array('imageselect-hover-inherit' => array('off'))),
							'imageselect-hover-shadow' => array('value' => array('size' => '', 'color' => '#444'), 'caption' => array('size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform')), 'label' => esc_html__('Image shadow', 'leform'), 'tooltip' => esc_html__('Adjust the shadow of hovered images.', 'leform'), 'type' => 'shadow', 'visible' => array('imageselect-hover-inherit' => array('off'))),
						'end-imageselects-hover' => array('type' => 'section-end'),
						'start-imageselects-selected' => array('type' => 'section-start', 'section' => 'imageselects-selected'),
							'imageselect-selected-inherit' => array('value' => 'on', 'label' => esc_html__('Inherit default style', 'leform'), 'tooltip' => esc_html__('Use the same style as for default state.', 'leform'), 'type' => 'checkbox'),
							'imageselect-selected-border-style' => array('value' => array('width' => '1', 'style' => 'solid', 'radius' => '0', 'color' => '#ccc', 'top' => 'on', 'right' => 'on', 'bottom' => 'on', 'left' => 'on'), 'caption' => array('width' => esc_html__('Width', 'leform'), 'style' => esc_html__('Style', 'leform'), 'radius' => esc_html__('Radius', 'leform'), 'color' => esc_html__('Color', 'leform'), 'border' => esc_html__('Border', 'leform')), 'label' => esc_html__('Image border', 'leform'), 'tooltip' => esc_html__('Adjust the border style of selected images.', 'leform'), 'type' => 'border-style', 'visible' => array('imageselect-selected-inherit' => array('off'))),
							'imageselect-selected-shadow' => array('value' => array('size' => '', 'color' => '#444'), 'caption' => array('size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform')), 'label' => esc_html__('Image shadow', 'leform'), 'tooltip' => esc_html__('Adjust the shadow of selected images.', 'leform'), 'type' => 'shadow', 'visible' => array('imageselect-selected-inherit' => array('off'))),
						'end-imageselects-selected' => array('type' => 'section-end'),
					'end-inputs' => array('type' => 'section-end'),
					'start-buttons' => array('type' => 'section-start', 'section' => 'buttons'),
						'button-style' => array('value' => array('size' => 'medium', 'width' => 'default', 'position' => 'center'), 'caption' => array('size' => esc_html__('Size', 'leform'), 'width' => esc_html__('Width', 'leform'), 'position' => esc_html__('Position', 'leform')), 'label' => esc_html__('Button style', 'leform'), 'tooltip' => esc_html__('Adjust the button size and position.', 'leform'), 'type' => 'global-button-style'),
						'button-style-sections' => array('type' => 'sections', 'sections' => array(
							'buttons-default' => array('label' => esc_html__('Default', 'leform'), 'icon' => 'fas fa-globe'),
							'buttons-hover' => array('label' => esc_html__('Hover', 'leform'), 'icon' => 'far fa-hand-pointer'),
							'buttons-active' => array('label' => esc_html__('Active', 'leform'), 'icon' => 'far fa-paper-plane')
						)),
						'start-buttons-default' => array('type' => 'section-start', 'section' => 'buttons-default'),
							'button-text-style' => array('value' => array('family' => '', 'size' => '15', 'color' => '#fff', 'bold' => 'off', 'italic' => 'off', 'underline' => 'off', 'align' => 'center'), 'caption' => array('family' => esc_html__('Font family', 'leform'), 'size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform'), 'style' => esc_html__('Style', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Button text', 'leform'), 'tooltip' => esc_html__('Adjust the text style of buttons.', 'leform'), 'type' => 'text-style'),
							'button-background-style' => array('value' => array('image' => '', 'size' => 'auto', 'position' => 'left', 'repeat' => 'repeat', 'color' => '#26B99A', 'shades' => 'off'), 'caption' => array('image' => esc_html__('Image URL', 'leform'), 'size' => esc_html__('Size', 'leform'), 'position' => esc_html__('Position', 'leform'), 'repeat' => esc_html__('Repeat', 'leform'), 'color' => esc_html__('Color', 'leform'), 'shades' => esc_html__('2 shades', 'leform')), 'label' => esc_html__('Button background', 'leform'), 'tooltip' => esc_html__('Adjust the background of buttons.', 'leform'), 'type' => 'background-style'),
							'button-border-style' => array('value' => array('width' => '1', 'style' => 'solid', 'radius' => '0', 'color' => '#169F85', 'top' => 'on', 'right' => 'on', 'bottom' => 'on', 'left' => 'on'), 'caption' => array('width' => esc_html__('Width', 'leform'), 'style' => esc_html__('Style', 'leform'), 'radius' => esc_html__('Radius', 'leform'), 'color' => esc_html__('Color', 'leform'), 'border' => esc_html__('Border', 'leform')), 'label' => esc_html__('Button border', 'leform'), 'tooltip' => esc_html__('Adjust the border style of buttons.', 'leform'), 'type' => 'border-style'),
							'button-shadow' => array('value' => array('size' => '', 'color' => '#444'), 'caption' => array('size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform')), 'label' => esc_html__('Button shadow', 'leform'), 'tooltip' => esc_html__('Adjust the shadow of button.', 'leform'), 'type' => 'shadow'),
						'end-buttons-default' => array('type' => 'section-end'),
						'start-buttons-hover' => array('type' => 'section-start', 'section' => 'buttons-hover'),
							'button-hover-inherit' => array('value' => 'on', 'label' => esc_html__('Inherit default style', 'leform'), 'tooltip' => esc_html__('Use the same style as for default state.', 'leform'), 'type' => 'checkbox'),
							'button-hover-text-style' => array('value' => array('family' => '', 'size' => '15', 'color' => '#fff', 'bold' => 'off', 'italic' => 'off', 'underline' => 'off', 'align' => 'center'), 'caption' => array('family' => esc_html__('Font family', 'leform'), 'size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform'), 'style' => esc_html__('Style', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Button text', 'leform'), 'tooltip' => esc_html__('Adjust the text style of hovered buttons.', 'leform'), 'type' => 'text-style', 'visible' => array('button-hover-inherit' => array('off'))),
							'button-hover-background-style' => array('value' => array('image' => '', 'size' => 'auto', 'position' => 'left', 'repeat' => 'repeat', 'color' => '#169F85', 'shades' => 'off'), 'caption' => array('image' => esc_html__('Image URL', 'leform'), 'size' => esc_html__('Size', 'leform'), 'position' => esc_html__('Position', 'leform'), 'repeat' => esc_html__('Repeat', 'leform'), 'color' => esc_html__('Color', 'leform'), 'shades' => esc_html__('2 shades', 'leform')), 'label' => esc_html__('Button background', 'leform'), 'tooltip' => esc_html__('Adjust the background of hovered buttons.', 'leform'), 'type' => 'background-style', 'visible' => array('button-hover-inherit' => array('off'))),
							'button-hover-border-style' => array('value' => array('width' => '1', 'style' => 'solid', 'radius' => '0', 'color' => '#169F85', 'top' => 'on', 'right' => 'on', 'bottom' => 'on', 'left' => 'on'), 'caption' => array('width' => esc_html__('Width', 'leform'), 'style' => esc_html__('Style', 'leform'), 'radius' => esc_html__('Radius', 'leform'), 'color' => esc_html__('Color', 'leform'), 'border' => esc_html__('Border', 'leform')), 'label' => esc_html__('Button border', 'leform'), 'tooltip' => esc_html__('Adjust the border style of hovered buttons.', 'leform'), 'type' => 'border-style', 'visible' => array('button-hover-inherit' => array('off'))),
							'button-hover-shadow' => array('value' => array('size' => '', 'color' => '#444'), 'caption' => array('size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform')), 'label' => esc_html__('Button shadow', 'leform'), 'tooltip' => esc_html__('Adjust the shadow of hovered buttons.', 'leform'), 'type' => 'shadow', 'visible' => array('button-hover-inherit' => array('off'))),
						'end-buttons-hover' => array('type' => 'section-end'),
						'start-buttons-active' => array('type' => 'section-start', 'section' => 'buttons-active'),
							'button-active-inherit' => array('value' => 'on', 'label' => esc_html__('Inherit default style', 'leform'), 'tooltip' => esc_html__('Use the same style as for default state.', 'leform'), 'type' => 'checkbox'),
							'button-active-text-style' => array('value' => array('family' => '', 'size' => '15', 'color' => '#fff', 'bold' => 'off', 'italic' => 'off', 'underline' => 'off', 'align' => 'center'), 'caption' => array('family' => esc_html__('Font family', 'leform'), 'size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform'), 'style' => esc_html__('Style', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Button text', 'leform'), 'tooltip' => esc_html__('Adjust the text style of clicked buttons.', 'leform'), 'type' => 'text-style', 'visible' => array('button-active-inherit' => array('off'))),
							'button-active-background-style' => array('value' => array('image' => '', 'size' => 'auto', 'position' => 'left', 'repeat' => 'repeat', 'color' => '#169F85', 'shades' => 'off'), 'caption' => array('image' => esc_html__('Image URL', 'leform'), 'size' => esc_html__('Size', 'leform'), 'position' => esc_html__('Position', 'leform'), 'repeat' => esc_html__('Repeat', 'leform'), 'color' => esc_html__('Color', 'leform'), 'shades' => esc_html__('2 shades', 'leform')), 'label' => esc_html__('Button background', 'leform'), 'tooltip' => esc_html__('Adjust the background of clicked buttons.', 'leform'), 'type' => 'background-style', 'visible' => array('button-active-inherit' => array('off'))),
							'button-active-border-style' => array('value' => array('width' => '1', 'style' => 'solid', 'radius' => '0', 'color' => '#169F85', 'top' => 'on', 'right' => 'on', 'bottom' => 'on', 'left' => 'on'), 'caption' => array('width' => esc_html__('Width', 'leform'), 'style' => esc_html__('Style', 'leform'), 'radius' => esc_html__('Radius', 'leform'), 'color' => esc_html__('Color', 'leform'), 'border' => esc_html__('Border', 'leform')), 'label' => esc_html__('Button border', 'leform'), 'tooltip' => esc_html__('Adjust the border style of clicked buttons.', 'leform'), 'type' => 'border-style', 'visible' => array('button-active-inherit' => array('off'))),
							'button-active-shadow' => array('value' => array('size' => '', 'color' => '#444'), 'caption' => array('size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform')), 'label' => esc_html__('Button shadow', 'leform'), 'tooltip' => esc_html__('Adjust the shadow of clicked buttons.', 'leform'), 'type' => 'shadow', 'visible' => array('button-active-inherit' => array('off'))),
							'button-active-transform' => array('value' => 'zoom-out', 'label' => esc_html__('Transform', 'leform'), 'tooltip' => esc_html__('Adjust the transform of clicked buttons.', 'leform'), 'type' => 'radio-bar', 'options' => array('zoom-in' => esc_html__('Zoom In', 'leform'), 'zoom-out' => esc_html__('Zoom Out', 'leform'), 'shift-down' => esc_html__('Shift Down', 'leform'))),
						'end-buttons-active' => array('type' => 'section-end'),
					'end-buttons' => array('type' => 'section-end'),
					'start-errors' => array('type' => 'section-start', 'section' => 'errors'),
						'error-background-style' => array('value' => array('image' => '', 'size' => 'auto', 'position' => 'left', 'repeat' => 'repeat', 'color' => '#d9534f', 'shades' => 'off'), 'caption' => array('image' => esc_html__('Image URL', 'leform'), 'size' => esc_html__('Size', 'leform'), 'position' => esc_html__('Position', 'leform'), 'repeat' => esc_html__('Repeat', 'leform'), 'color' => esc_html__('Color', 'leform'), 'shades' => esc_html__('2 shades', 'leform')), 'label' => esc_html__('Bubble background', 'leform'), 'tooltip' => esc_html__('Adjust the background of error bubbles.', 'leform'), 'type' => 'background-style'),
						'error-text-style' => array('value' => array('family' => '', 'size' => '15', 'color' => '#fff', 'bold' => 'off', 'italic' => 'off', 'underline' => 'off', 'align' => 'left'), 'caption' => array('family' => esc_html__('Font family', 'leform'), 'size' => esc_html__('Size', 'leform'), 'color' => esc_html__('Color', 'leform'), 'style' => esc_html__('Style', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Error text style', 'leform'), 'tooltip' => esc_html__('Adjust the text style of errors.', 'leform'), 'type' => 'text-style'),
					'end-errors' => array('type' => 'section-end'),
					'start-progress' => array('type' => 'section-start', 'section' => 'progress'),
						'progress-enable' => array('value' => 'off', 'label' => esc_html__('Enable progress bar', 'leform'), 'tooltip' => esc_html__('If your form the form has several pages/steps, it is recommended to display progress bas for better user experience.', 'leform'), 'type' => 'checkbox'),
						'progress-type' => array('value' => 'progress-1', 'label' => esc_html__('Progress style', 'leform'), 'tooltip' => esc_html__('Select the general view of progress bar.', 'leform'), 'type' => 'select-image', 'options' => array('progress-1' => $this->plugins_url.'/images/progress-1.png', 'progress-2' => $this->plugins_url.'/images/progress-2.png'), 'width' => 350, 'height' => 90, 'visible' => array('progress-enable' => array('on'))),
						'progress-color' => array('value' => array('color1' => '#e0e0e0', 'color2' => '#26B99A', 'color3' => '#FFFFFF', 'color4' => '#444444'), 'label' => esc_html__('Colors', 'leform'), 'tooltip' => esc_html__('Adjust colors of progress bar.', 'leform'), 'caption' => array('color1' => 'Passive background', 'color2' => 'Active background', 'color3' => 'Page number (or %)', 'color4' => 'Page name'), 'type' => 'four-colors', 'visible' => array('progress-enable' => array('on'))),
						'progress-striped' => array('value' => 'off', 'label' => esc_html__('Double-tone stripes', 'leform'), 'tooltip' => esc_html__('Add double-tone diagonal stripes to progress bar.', 'leform'), 'type' => 'checkbox', 'visible' => array('progress-enable' => array('on'))),
						'progress-label-enable' => array('value' => 'off', 'label' => esc_html__('Show page name', 'leform'), 'tooltip' => esc_html__('Show page label.', 'leform'), 'type' => 'checkbox', 'visible' => array('progress-enable' => array('on'))),
						'progress-confirmation-enable' => array('value' => 'on', 'label' => esc_html__('Include confirmation page', 'leform'), 'tooltip' => esc_html__('Consider Confirmation page as part of total pages and include it into progress bar.', 'leform'), 'type' => 'checkbox', 'visible' => array('progress-enable' => array('on'))),
						'progress-position' => array('value' => 'inside', 'label' => esc_html__('Position', 'leform'), 'tooltip' => esc_html__('Select the position of progress bar. It can be inside or outside of main form wrapper.', 'leform'), 'type' => 'select', 'options' => array('inside' => esc_html__('Inside', 'leform'), 'outside' => esc_html__('Outside', 'leform')), 'visible' => array('progress-enable' => array('on'))),
					'end-progress' => array('type' => 'section-end'),
				'confirmation-tab' => array('type' => 'tab', 'value' => 'confirmation', 'label' => esc_html__('Confirmations', 'leform')),
					'confirmations' => array('type' => 'confirmations', 'values' => array(), 'label' => esc_html__('Confirmations', 'leform'), 'message' => esc_html__('By default after successfull form submission the Confirmation Page is displayed. You can customize confirmation and use conditional logic. If several confirmations match form conditions, the first one (higher priority) will be applied. Sort confirmations (drag and drop) to set priority.', 'leform')),
				'double-tab' => array('type' => 'tab', 'value' => 'double', 'label' => esc_html__('Double Opt-In', 'leform')),
					'double-enable' => array('value' => 'off', 'label' => esc_html__('Enable', 'leform'), 'tooltip' => esc_html__('Activate it if you want users to confirm submitted data. If enabled, the plugin sends email message with confirmation link to certain email address (submitted by user). When confirmation link clicked, relevant record is marked as "confirmed". Moreover, if enabled, all notifications and integrations are executed only when data confirmed by user. Important! Double opt-in is disabled if user is requested to pay via existing Payment Gateway.', 'leform'), 'type' => 'checkbox'),
					'double-email-recipient' => array('value' => '', 'label' => esc_html__('Recipient', 'leform'), 'tooltip' => esc_html__('Set email address to which confirmation link will be sent to.', 'leform'), 'type' => 'text-shortcodes'),
					'double-email-subject' => array('value' => esc_html__('Please confirm your email address', 'leform'), 'label' => esc_html__('Subject', 'leform'), 'tooltip' => esc_html__('The subject of the email message.', 'leform'), 'type' => 'text-shortcodes'),
					'double-email-message' => array('value' => esc_html__('Dear visitor!', 'leform').'<br /><br />'.esc_html__('Please confirm your email address by clicking the following link:', 'leform').'<br /><a href="{{confirmation-url}}">{{confirmation-url}}</a><br /><br />'.esc_html__('Thanks.', 'leform'), 'label' => esc_html__('Message', 'leform'), 'tooltip' => sprintf(esc_html__('The content of the email message. It is mandatory to include %s{{confirmation-url}}%s shortcode.', 'leform'), '<code>', '</code>'), 'type' => 'html'),
					'double-from' => array('value' => array('email' => '{{global-from-email}}', 'name' => '{{global-from-name}}'), 'label' => esc_html__('From', 'leform'), 'tooltip' => esc_html__('Sets the "From" address and name. The email address and name set here will be shown as the sender of the email.', 'leform'), 'type' => 'from'),
					'double-message' => array('value' => '<h4 style="text-align: center;">Thank you!</h4><p style="text-align: center;">Your email address successfully confirmed.</p>', 'label' => esc_html__('Thanksgiving message', 'leform'), 'tooltip' => esc_html__('This message is displayed when users successfully confirmed their e-mail addresses.', 'leform'), 'type' => 'html'),
					'double-url' => array('value' => '', 'label' => esc_html__('Thanksgiving URL', 'leform'), 'tooltip' => esc_html__('This is alternate way of thanksgiving message. After confirmation users are redirected to this URL.', 'leform'), 'type' => 'text'),
				'notification-tab' => array('type' => 'tab', 'value' => 'notification', 'label' => esc_html__('Notifications', 'leform')),
					'notifications' => array('type' => 'notifications', 'values' => array(), 'label' => esc_html__('Notifications', 'leform'), 'message' => esc_html__('After successful form submission the notification, welcome, thanksgiving or whatever email can be sent. You can customize these emails and use conditional logic.', 'leform')),
				'integration-tab' => array('type' => 'tab', 'value' => 'integration', 'label' => esc_html__('Integrations', 'leform')),
					'integrations' => array('type' => 'integrations', 'values' => array(), 'label' => esc_html__('Integrations', 'leform'), 'message' => esc_html__('After successful form submission its data can be sent to 3rd party services (such as MailChimp, AWeber, GetResponse, etc.). You can configure integrations and use conditional logic. If you do not see your marketing/CRM provider, make sure that you enabled appropriate integration module on Advanced Settings page.', 'leform')),
				'advanced-tab' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'advanced-sections' => array('type' => 'sections', 'sections' => array(
						'math' => array('label' => esc_html__('Math Expressions', 'leform'), 'icon' => 'fas fa-plus'),
						'payment-gateways' => array('label' => esc_html__('Payment Gateways', 'leform'), 'icon' => 'fas fa-dollar-sign')
					)),
					'start-math' => array('type' => 'section-start', 'section' => 'math'),
						'math-expressions' => array('type' => 'math-expressions', 'values' => array(), 'label' => esc_html__('Math expressions', 'leform'), 'tooltip' => esc_html__('Create math expressions and use them along the form.', 'leform')),
					'end-math' => array('type' => 'section-end'),
					'start-payment-gateways' => array('type' => 'section-start', 'section' => 'payment-gateways'),
						'payment-gateways' => array('type' => 'payment-gateways', 'values' => array(), 'label' => esc_html__('Payment gateways', 'leform'), 'message' => esc_html__('After successful form submission user can be requested to pay some amount via certain payment gateway. Customize payment gateways here. Then go to "Confirmations" tab and create confirmation of one of the following types: "Display Confirmation page and request payment", "Display Message and request payment" or "Request payment".', 'leform')),
					'end-payment-gateways' => array('type' => 'section-end'),
			),
			'page' => array(
				'general' => array('type' => 'tab', 'value' => 'general', 'label' => esc_html__('General', 'leform')),
					'name' => array('value' => esc_html__('Page', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name helps to identify the page.', 'leform'), 'type' => 'text'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this page', 'leform'), 'hide' => esc_html__('Hide this page', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
			),
			'page-confirmation' => array(
				'general' => array('type' => 'tab', 'value' => 'general', 'label' => esc_html__('General', 'leform')),
					'name' => array('value' => esc_html__('Confirmation', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name helps to identify the confirmation page.', 'leform'), 'type' => 'text')
			),
			'columns' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Untitled', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown throughout the plugin.', 'leform'), 'type' => 'text'),
					'widths' => array('value' => '', 'label' => esc_html__('Column width', 'leform'), 'tooltip' => esc_html__('Specify the width of each column. The row is divided into 12 equal pieces. You can decide how many pieces related to each columns. If you want all columns to be in one row, make sure that sum of widths is equal to 12.', 'leform'), 'type' => 'column-width'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this element', 'leform'), 'hide' => esc_html__('Hide this element', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
			),
			'email' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Email Address', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Email', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the field.', 'leform'), 'type' => 'text'),
					'placeholder' => array('value' => '', 'label' => esc_html__('Placeholder', 'leform'), 'tooltip' => esc_html__('The placeholder text will appear inside the field until the user starts to type.', 'leform'), 'type' => 'text'),
					'autocomplete' => array('value' => 'email', 'label' => esc_html__('Autocomplete attribute', 'leform'), 'tooltip' => esc_html__('Choose the value of the autocomplete attribute. It helps browser to fill the field value, if required.', 'leform'), 'type' => 'select', 'options' => $autocomplete_options),
					'description' => array('value' => 'Enter email address.', 'label' => esc_html__('Description', 'leform'), 'tooltip' => esc_html__('This description appears below the field.', 'leform'), 'type' => 'text'),
					'required' => array('value' => 'off', 'label' => esc_html__('Required', 'leform'), 'tooltip' => esc_html__('If enabled, the user must fill out the field.', 'leform'), 'type' => 'checkbox'),
					'required-error' => array('value' => esc_html__('This field is required.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('required' => array('on'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'label-style' => array('value' => array('position' => '', 'width' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label style', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field and its alignment.', 'leform'), 'type' => 'label-style'),
					'input-style' => array('value' => array('size' => '', 'align' => ''), 'caption' => array('size' => esc_html__('Size', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Input style', 'leform'), 'tooltip' => esc_html__('Adjust the input field style (size and text alignment).', 'leform'), 'type' => 'input-style'),
					'icon' => array('value' => array('left-icon' => ($this->options['fa-enable'] == 'on' ? ($this->options['fa-regular-enable'] == 'on' ? 'far fa-envelope' : 'fas fa-envelope') : 'leform-fa leform-fa-envelope-o'), 'left-size' => '', 'left-color' => '', 'right-icon' => '', 'right-size' => '', 'right-color' => ''), 'caption' => array('left' => esc_html__('Left side', 'leform'), 'right' => esc_html__('Right side', 'leform')), 'label' => esc_html__('Input icons', 'leform'), 'tooltip' => esc_html__('These icons appear inside/near of the input field.', 'leform'), 'type' => 'input-icons'),
					'description-style' => array('value' => array('position' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Align', 'leform')), 'label' => esc_html__('Description style', 'leform'), 'tooltip' => esc_html__('Choose where to display the description relative to the field and its alignment.', 'leform'), 'type' => 'description-style'),
					'css-class' => array('value' => '', 'label' => esc_html__('Custom CSS class', 'leform'), 'tooltip' => esc_html__('This class name will be added to the input field.', 'leform'), 'type' => 'text'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'label' => array(
								'label' => esc_html__('Label', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-label .leform-label',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-label .leform-label'
							),
							'input' => array(
								'label' => esc_html__('Input field', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input'
							),
							'input-hover' => array(
								'label' => esc_html__('Input field (hover)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input:hover',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input:hover'
							),
							'input-focus' => array(
								'label' => esc_html__('Input field (focus)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input:focus',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input:focus'
							),
							'input-icon-left' => array(
								'label' => esc_html__('Input field icon (left)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-left',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-left'
							),
							'input-icon-right' => array(
								'label' => esc_html__('Input field icon (right)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-right',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-right'
							),
							'description' => array(
								'label' => esc_html__('Description', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input .leform-description',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input .leform-description'
							)
						)
					),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'default' => array('value' => '', 'label' => esc_html__('Default value', 'leform'), 'tooltip' => esc_html__('The default value is the value that the field has before the user has entered anything.', 'leform'), 'type' => 'text'),
					'dynamic-default' => array('value' => 'off', 'label' => esc_html__('Dynamic default value', 'leform'), 'tooltip' => esc_html__('Allows the default value of the field to be set dynamically via a URL parameter.', 'leform'), 'type' => 'checkbox'),
					'dynamic-parameter' => array('value' => '', 'label' => esc_html__('Parameter name', 'leform'), 'tooltip' => esc_html__('This is the name of the parameter that you will use to set the default value.', 'leform'), 'type' => 'text', 'visible' => array('dynamic-default' => array('on'))),
					'readonly' => array('value' => 'off', 'label' => esc_html__('Read only', 'leform'), 'tooltip' => esc_html__('If enabled, the user can not edit the field value.', 'leform'), 'type' => 'checkbox'),
					'save' => array('value' => 'on', 'label' => esc_html__('Save to database', 'leform'), 'tooltip' => esc_html__('If enabled, the submitted element data will be saved to the database and shown when viewing an entry.', 'leform'), 'type' => 'checkbox'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this field', 'leform'), 'hide' => esc_html__('Hide this field', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id'),
					'filters' => array('values' => array(array("type" => "trim", "properties" => null)), 'allowed-values' => array('alpha', 'alphanumeric', 'digits', 'regex', 'strip-tags', 'trim'), 'label' => esc_html__('Filters', 'leform'), 'tooltip' => esc_html__('Filters allow you to strip various characters from the submitted value.', 'leform'), 'type' => 'filters'),
					'validators' => array('values' => array(array("type" => "email", "properties" => array('error' => ''))), 'allowed-values' => array('email', 'equal', 'in-array', 'prevent-duplicates'), 'label' => esc_html__('Validators', 'leform'), 'tooltip' => esc_html__('Validators checks whether the data entered by the user is valid.', 'leform'), 'type' => 'validators')
			),
			'text' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Text', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Text', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the field.', 'leform'), 'type' => 'text'),
					'placeholder' => array('value' => '', 'label' => esc_html__('Placeholder', 'leform'), 'tooltip' => esc_html__('The placeholder text will appear inside the field until the user starts to type.', 'leform'), 'type' => 'text'),
					'autocomplete' => array('value' => 'off', 'label' => esc_html__('Autocomplete attribute', 'leform'), 'tooltip' => esc_html__('Choose the value of the autocomplete attribute. It helps browser to fill the field value, if required.', 'leform'), 'type' => 'select', 'options' => $autocomplete_options),
					'description' => array('value' => 'Type something.', 'label' => esc_html__('Description', 'leform'), 'tooltip' => esc_html__('This description appears below the field.', 'leform'), 'type' => 'text'),
					'required' => array('value' => 'off', 'label' => esc_html__('Required', 'leform'), 'tooltip' => esc_html__('If enabled, the user must fill out the field.', 'leform'), 'type' => 'checkbox'),
					'required-error' => array('value' => esc_html__('This field is required.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('required' => array('on'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'label-style' => array('value' => array('position' => '', 'width' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label style', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field and its alignment.', 'leform'), 'type' => 'label-style'),
					'input-style' => array('value' => array('size' => '', 'align' => ''), 'caption' => array('size' => esc_html__('Size', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Input style', 'leform'), 'tooltip' => esc_html__('Adjust the input field style (size and text alignment).', 'leform'), 'type' => 'input-style'),
					'icon' => array('value' => array('left-icon' => '', 'left-size' => '', 'left-color' => '', 'right-icon' => '', 'right-size' => '', 'right-color' => ''), 'caption' => array('left' => esc_html__('Left side', 'leform'), 'right' => esc_html__('Right side', 'leform')), 'label' => esc_html__('Input icons', 'leform'), 'tooltip' => esc_html__('These icons appear inside/near of the input field.', 'leform'), 'type' => 'input-icons'),
					'description-style' => array('value' => array('position' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Align', 'leform')), 'label' => esc_html__('Description style', 'leform'), 'tooltip' => esc_html__('Choose where to display the description relative to the field and its alignment.', 'leform'), 'type' => 'description-style'),
					'css-class' => array('value' => '', 'label' => esc_html__('Custom CSS class', 'leform'), 'tooltip' => esc_html__('This class name will be added to the input field.', 'leform'), 'type' => 'text'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'label' => array(
								'label' => esc_html__('Label', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-label .leform-label',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-label .leform-label'
							),
							'input' => array(
								'label' => esc_html__('Input field', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input'
							),
							'input-hover' => array(
								'label' => esc_html__('Input field (hover)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input:hover',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input:hover'
							),
							'input-focus' => array(
								'label' => esc_html__('Input field (focus)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input:focus',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input:focus'
							),
							'input-icon-left' => array(
								'label' => esc_html__('Input field icon (left)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-left',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-left'
							),
							'input-icon-right' => array(
								'label' => esc_html__('Input field icon (right)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-right',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-right'
							),
							'description' => array(
								'label' => esc_html__('Description', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input .leform-description',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input .leform-description'
							)
						)
					),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'mask' => array('value' => array('preset' => '', 'mask' => ''), 'label' => esc_html__('Mask', 'leform'), 'tooltip' => esc_html__('Adjust the mask of the input field. Use the following special symbols:', 'leform').'<br /><br />'.esc_html__('0 - mandatory digit', 'leform').'<br />'.esc_html__('9 - optional digit', 'leform').'<br />'.esc_html__('A - alphanumeric character', 'leform').'<br />'.esc_html__('S - alpha character', 'leform'), 'preset-options' => array('(000)000-0000' => 'Phone number with area code: (000)000-0000', '(00)0000-0000' => 'Phone number with area code: (00)0000-0000', '+0(000)000-0000' => 'International phone number: +0(000)000-0000', '+00(000)000-0000' => 'International phone number: +00(000)000-0000', '099.099.099.099' => 'IP Address: 099.099.099.099', '000-00-0000' => 'SSN: 000-00-0000', '0000 0000 0000 0000' => 'Visa/Mastercard: 0000 0000 0000 0000', '0000 000000 00000' => 'AmEx: 0000 000000 00000', 'custom' => 'Custom Mask'), 'type' => 'mask'),
					'default' => array('value' => '', 'label' => esc_html__('Default value', 'leform'), 'tooltip' => esc_html__('The default value is the value that the field has before the user has entered anything.', 'leform'), 'type' => 'text'),
					'dynamic-default' => array('value' => 'off', 'label' => esc_html__('Dynamic default value', 'leform'), 'tooltip' => esc_html__('Allows the default value of the field to be set dynamically via a URL parameter.', 'leform'), 'type' => 'checkbox'),
					'dynamic-parameter' => array('value' => '', 'label' => esc_html__('Parameter name', 'leform'), 'tooltip' => esc_html__('This is the name of the parameter that you will use to set the default value.', 'leform'), 'type' => 'text', 'visible' => array('dynamic-default' => array('on'))),
					'readonly' => array('value' => 'off', 'label' => esc_html__('Read only', 'leform'), 'tooltip' => esc_html__('If enabled, the user can not edit the field value.', 'leform'), 'type' => 'checkbox'),
					'save' => array('value' => 'on', 'label' => esc_html__('Save to database', 'leform'), 'tooltip' => esc_html__('If enabled, the submitted element data will be saved to the database and shown when viewing an entry.', 'leform'), 'type' => 'checkbox'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this field', 'leform'), 'hide' => esc_html__('Hide this field', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id'),
					'filters' => array('values' => array(array("type" => "trim", "properties" => null)), 'allowed-values' => array('alpha', 'alphanumeric', 'digits', 'regex', 'strip-tags', 'trim'), 'label' => esc_html__('Filters', 'leform'), 'tooltip' => esc_html__('Filters allow you to strip various characters from the submitted value.', 'leform'), 'type' => 'filters'),
					'validators' => array('values' => array(), 'allowed-values' => array('alpha', 'alphanumeric', 'digits', 'email', 'equal', 'greater', 'in-array', 'length', 'less', 'prevent-duplicates', 'regex', 'url'), 'label' => esc_html__('Validators', 'leform'), 'tooltip' => esc_html__('Validators checks whether the data entered by the user is valid.', 'leform'), 'type' => 'validators')
			),
			'textarea' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Textarea', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Text', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the field.', 'leform'), 'type' => 'text'),
					'placeholder' => array('value' => '', 'label' => esc_html__('Placeholder', 'leform'), 'tooltip' => esc_html__('The placeholder text will appear inside the field until the user starts to type.', 'leform'), 'type' => 'text'),
					'description' => array('value' => 'Type message.', 'label' => esc_html__('Description', 'leform'), 'tooltip' => esc_html__('This description appears below the field.', 'leform'), 'type' => 'text'),
					'required' => array('value' => 'off', 'label' => esc_html__('Required', 'leform'), 'tooltip' => esc_html__('If enabled, the user must fill out the field.', 'leform'), 'caption' => esc_html__('The field is required', 'leform'), 'type' => 'checkbox'),
					'required-error' => array('value' => esc_html__('This field is required.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('required' => array('on'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'label-style' => array('value' => array('position' => '', 'width' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label style', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field and its alignment.', 'leform'), 'type' => 'label-style'),
					'textarea-style' => array('value' => array('height' => '', 'align' => ''), 'caption' => array('height' => esc_html__('Height', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Textarea style', 'leform'), 'tooltip' => esc_html__('Adjust the textarea field style (size and text alignment).', 'leform'), 'type' => 'textarea-style'),
					'icon' => array('value' => array('left-icon' => '', 'left-size' => '', 'left-color' => '', 'right-icon' => '', 'right-size' => '', 'right-color' => ''), 'caption' => array('left' => esc_html__('Left side', 'leform'), 'right' => esc_html__('Right side', 'leform')), 'label' => esc_html__('Textarea icons', 'leform'), 'tooltip' => esc_html__('These icons appear inside/near of the textarea field.', 'leform'), 'type' => 'input-icons'),
					'description-style' => array('value' => array('position' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Align', 'leform')), 'label' => esc_html__('Description style', 'leform'), 'tooltip' => esc_html__('Select the horizontal alignment of the description.', 'leform'), 'type' => 'description-style'),
					'css-class' => array('value' => '', 'label' => esc_html__('Custom CSS class', 'leform'), 'tooltip' => esc_html__('This class name will be added to the textarea field.', 'leform'), 'type' => 'text'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'label' => array(
								'label' => esc_html__('Label', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-label .leform-label',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-label .leform-label'
							),
							'textarea' => array(
								'label' => esc_html__('Textarea', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input textarea',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input textarea'
							),
							'textarea-hover' => array(
								'label' => esc_html__('Textarea (hover)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input textarea:hover',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input textarea:hover'
							),
							'textarea-focus' => array(
								'label' => esc_html__('Textarea (focus)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input textarea:focus',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input textarea:focus'
							),
							'textarea-icon-left' => array(
								'label' => esc_html__('Textarea icon (left)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-left',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-left'
							),
							'textarea-icon-right' => array(
								'label' => esc_html__('Textarea icon (right)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-right',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-right'
							),
							'description' => array(
								'label' => esc_html__('Description', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input .leform-description',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input .leform-description'
							)
						)
					),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'default' => array('value' => '', 'label' => esc_html__('Default value', 'leform'), 'tooltip' => esc_html__('The default value is the value that the field has before the user has entered anything.', 'leform'), 'type' => 'textarea'),
					'dynamic-default' => array('value' => 'off', 'label' => esc_html__('Dynamic default value', 'leform'), 'tooltip' => esc_html__('Allows the default value of the field to be set dynamically via a URL parameter.', 'leform'), 'type' => 'checkbox'),
					'dynamic-parameter' => array('value' => '', 'label' => esc_html__('Parameter name', 'leform'), 'tooltip' => esc_html__('This is the name of the parameter that you will use to set the default value.', 'leform'), 'type' => 'text', 'visible' => array('dynamic-default' => array('on'))),
					'readonly' => array('value' => 'off', 'label' => esc_html__('Read only', 'leform'), 'tooltip' => esc_html__('If enabled, the user can not edit the field value.', 'leform'), 'type' => 'checkbox'),
					'save' => array('value' => 'on', 'label' => esc_html__('Save to database', 'leform'), 'tooltip' => esc_html__('If enabled, the submitted element data will be saved to the database and shown when viewing an entry.', 'leform'), 'type' => 'checkbox'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this field', 'leform'), 'hide' => esc_html__('Hide this field', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id'),
					'filters' => array('values' => array(array("type" => "trim", "properties" => null)), 'allowed-values' => array('alpha', 'alphanumeric', 'digits', 'regex', 'strip-tags', 'trim'), 'label' => esc_html__('Filters', 'leform'), 'tooltip' => esc_html__('Filters allow you to strip various characters from the submitted value.', 'leform'), 'type' => 'filters'),
					'validators' => array('values' => array(), 'allowed-values' => array('alpha', 'alphanumeric', 'digits', 'email', 'equal', 'greater', 'in-array', 'length', 'less', 'prevent-duplicates', 'regex', 'url'), 'label' => esc_html__('Validators', 'leform'), 'tooltip' => esc_html__('Validators checks whether the data entered by the user is valid.', 'leform'), 'type' => 'validators')
			),
			'select' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Select', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Select', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the field.', 'leform'), 'type' => 'text'),
					'options' => array('multi-select' => 'off', 'values' => array(array('value' => 'Option 1', 'label' => 'Option 1'), array('value' => 'Option 2', 'label' => 'Option 2'), array('value' => 'Option 3', 'label' => 'Option 3')), 'label' => esc_html__('Options', 'leform'), 'tooltip' => esc_html__('These are the choices that the user will be able to choose from.', 'leform'), 'type' => 'options'),
					'please-select-option' => array('value' => 'off', 'label' => esc_html__('"Please select" option', 'leform'), 'tooltip' => esc_html__('Adds an option to the top of the list to let the user choose no value.', 'leform'), 'type' => 'checkbox'),
					'please-select-text' => array('value' => esc_html__('Please select', 'leform'), 'label' => esc_html__('"Please select" text', 'leform'), 'type' => 'text', 'visible' => array('please-select-option' => array('on'))),
					'autocomplete' => array('value' => 'off', 'label' => esc_html__('Autocomplete attribute', 'leform'), 'tooltip' => esc_html__('Choose the value of the autocomplete attribute. It helps browser to fill the field value, if required.', 'leform'), 'type' => 'select', 'options' => $autocomplete_options),
					'description' => array('value' => 'Select value', 'label' => esc_html__('Description', 'leform'), 'tooltip' => esc_html__('This description appears below the field.', 'leform'), 'type' => 'text'),
					'required' => array('value' => 'off', 'label' => esc_html__('Required', 'leform'), 'tooltip' => esc_html__('If enabled, the user must fill out the field.', 'leform'), 'caption' => esc_html__('The field is required', 'leform'), 'type' => 'checkbox'),
					'required-error' => array('value' => esc_html__('This field is required.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('required' => array('on'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'label-style' => array('value' => array('position' => '', 'width' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label style', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field and its alignment.', 'leform'), 'type' => 'label-style'),
					'input-style' => array('value' => array('size' => '', 'align' => ''), 'caption' => array('size' => esc_html__('Size', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Input style', 'leform'), 'tooltip' => esc_html__('Adjust the input field style (size and text alignment).', 'leform'), 'type' => 'input-style'),
					'description-style' => array('value' => array('position' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Align', 'leform')), 'label' => esc_html__('Description style', 'leform'), 'tooltip' => esc_html__('Choose where to display the description relative to the field and its alignment.', 'leform'), 'type' => 'description-style'),
					'css-class' => array('value' => '', 'label' => esc_html__('Custom CSS class', 'leform'), 'tooltip' => esc_html__('This class name will be added to the input field.', 'leform'), 'type' => 'text'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'label' => array(
								'label' => esc_html__('Label', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-label .leform-label',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-label .leform-label'
							),
							'select' => array(
								'label' => esc_html__('Select box', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input select',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input select'
							),
							'select-hover' => array(
								'label' => esc_html__('Select box (hover)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input select:hover',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input select:hover'
							),
							'select-focus' => array(
								'label' => esc_html__('Select box (focus)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input select:focus',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input select:focus'
							),
							'description' => array(
								'label' => esc_html__('Description', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input .leform-description',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input .leform-description'
							)
						)
					),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'dynamic-default' => array('value' => 'off', 'label' => esc_html__('Dynamic default value', 'leform'), 'tooltip' => esc_html__('Allows the default value of the field to be set dynamically via a URL parameter.', 'leform'), 'type' => 'checkbox'),
					'dynamic-parameter' => array('value' => '', 'label' => esc_html__('Parameter name', 'leform'), 'tooltip' => esc_html__('This is the name of the parameter that you will use to set the default value.', 'leform'), 'type' => 'text', 'visible' => array('dynamic-default' => array('on'))),
					'save' => array('value' => 'on', 'label' => esc_html__('Save to database', 'leform'), 'tooltip' => esc_html__('If enabled, the submitted element data will be saved to the database and shown when viewing an entry.', 'leform'), 'type' => 'checkbox'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this field', 'leform'), 'hide' => esc_html__('Hide this field', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id'),
					'validators' => array('values' => array(), 'allowed-values' => array('equal', 'greater', 'in-array', 'less', 'prevent-duplicates', 'regex'), 'label' => esc_html__('Validators', 'leform'), 'tooltip' => esc_html__('Validators checks whether the data entered by the user is valid.', 'leform'), 'type' => 'validators')
			),
			'checkbox' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Checkbox', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Options', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the field.', 'leform'), 'type' => 'text'),
					'options' => array('multi-select' => 'on', 'values' => array(array('value' => 'Option 1', 'label' => 'Option 1'), array('value' => 'Option 2', 'label' => 'Option 2'), array('value' => 'Option 3', 'label' => 'Option 3')), 'label' => esc_html__('Options', 'leform'), 'tooltip' => esc_html__('These are the choices that the user will be able to choose from.', 'leform'), 'type' => 'options'),
					'description' => array('value' => 'Select options.', 'label' => esc_html__('Description', 'leform'), 'tooltip' => esc_html__('This description appears below the field.', 'leform'), 'type' => 'text'),
					'required' => array('value' => 'off', 'label' => esc_html__('Required', 'leform'), 'tooltip' => esc_html__('If enabled, the user must fill out the field.', 'leform'), 'caption' => esc_html__('The field is required', 'leform'), 'type' => 'checkbox'),
					'required-error' => array('value' => esc_html__('This field is required.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('required' => array('on'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'label-style' => array('value' => array('position' => '', 'width' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label style', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field and its alignment.', 'leform'), 'type' => 'label-style'),
					'checkbox-style' => array('value' => array('position' => '', 'align' => '', 'layout' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Alignment', 'leform'), 'layout' => esc_html__('Layout', 'leform')), 'label' => esc_html__('Checkbox style', 'leform'), 'tooltip' => esc_html__('Choose how to display checkbox fields and their captions.', 'leform'), 'type' => 'local-checkbox-style'),
					'description-style' => array('value' => array('position' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Align', 'leform')), 'label' => esc_html__('Description style', 'leform'), 'tooltip' => esc_html__('Choose where to display the description relative to the field and its alignment.', 'leform'), 'type' => 'description-style'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'label' => array(
								'label' => esc_html__('Label', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-label .leform-label',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-label .leform-label'
							),
							'description' => array(
								'label' => esc_html__('Description', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input .leform-description',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input .leform-description'
							)
						)
					),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'dynamic-default' => array('value' => 'off', 'label' => esc_html__('Dynamic default value', 'leform'), 'tooltip' => esc_html__('Allows the default value of the field to be set dynamically via a URL parameter.', 'leform'), 'type' => 'checkbox'),
					'dynamic-parameter' => array('value' => '', 'label' => esc_html__('Parameter name', 'leform'), 'tooltip' => esc_html__('This is the name of the parameter that you will use to set the default value.', 'leform'), 'type' => 'text', 'visible' => array('dynamic-default' => array('on'))),
					'save' => array('value' => 'on', 'label' => esc_html__('Save to database', 'leform'), 'tooltip' => esc_html__('If enabled, the submitted element data will be saved to the database and shown when viewing an entry.', 'leform'), 'type' => 'checkbox'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this field', 'leform'), 'hide' => esc_html__('Hide this field', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id'),
					'validators' => array('values' => array(), 'allowed-values' => array('in-array', 'prevent-duplicates'), 'label' => esc_html__('Validators', 'leform'), 'tooltip' => esc_html__('Validators checks whether the data entered by the user is valid.', 'leform'), 'type' => 'validators')
			),
			'imageselect' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Image select', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Options', 'leform'), 'label' => esc_html__('Images', 'leform'), 'tooltip' => esc_html__('This is the label of the field.', 'leform'), 'type' => 'text'),
					'mode' => array('value' => 'radio', 'label' => esc_html__('Mode', 'leform'), 'tooltip' => esc_html__('Select the mode of  the Image Select.', 'leform'), 'type' => 'imageselect-mode'),
					'options' => array('multi-select' => 'off', 'values' => array(array('value' => 'Option 1', 'label' => 'Option 1', 'image' => $this->plugins_url.'/images/placeholder-image.png'), array('value' => 'Option 2', 'label' => 'Option 2', 'image' => $this->plugins_url.'/images/placeholder-image.png'), array('value' => 'Option 3', 'label' => 'Option 3', 'image' => $this->plugins_url.'/images/placeholder-image.png')), 'label' => esc_html__('Options', 'leform'), 'tooltip' => esc_html__('These are the choices that the user will be able to choose from.', 'leform'), 'type' => 'image-options'),
					'description' => array('value' => 'Select options.', 'label' => esc_html__('Description', 'leform'), 'tooltip' => esc_html__('This description appears below the field.', 'leform'), 'type' => 'text'),
					'required' => array('value' => 'off', 'label' => esc_html__('Required', 'leform'), 'tooltip' => esc_html__('If enabled, the user must fill out the field.', 'leform'), 'caption' => esc_html__('The field is required', 'leform'), 'type' => 'checkbox'),
					'required-error' => array('value' => esc_html__('This field is required.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('required' => array('on'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'label-style' => array('value' => array('position' => '', 'width' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label style', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field and its alignment.', 'leform'), 'type' => 'label-style'),
					'image-style' => array('value' => array('width' => "120", 'height' => "160", 'size' => 'contain'), 'caption' => array('width' => esc_html__('Width', 'leform'), 'height' => esc_html__('Height', 'leform'), 'size' => esc_html__('Size', 'leform')), 'label' => esc_html__('Image style', 'leform'), 'tooltip' => esc_html__('Choose how to display images.', 'leform'), 'type' => 'local-imageselect-style'),
					'description-style' => array('value' => array('position' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Align', 'leform')), 'label' => esc_html__('Description style', 'leform'), 'tooltip' => esc_html__('Choose where to display the description relative to the field and its alignment.', 'leform'), 'type' => 'description-style'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'label' => array(
								'label' => esc_html__('Label', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-label .leform-label',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-label .leform-label'
							),
							'description' => array(
								'label' => esc_html__('Description', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input .leform-description',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input .leform-description'
							)
						)
					),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'dynamic-default' => array('value' => 'off', 'label' => esc_html__('Dynamic default value', 'leform'), 'tooltip' => esc_html__('Allows the default value of the field to be set dynamically via a URL parameter.', 'leform'), 'type' => 'checkbox'),
					'dynamic-parameter' => array('value' => '', 'label' => esc_html__('Parameter name', 'leform'), 'tooltip' => esc_html__('This is the name of the parameter that you will use to set the default value.', 'leform'), 'type' => 'text', 'visible' => array('dynamic-default' => array('on'))),
					'save' => array('value' => 'on', 'label' => esc_html__('Save to database', 'leform'), 'tooltip' => esc_html__('If enabled, the submitted element data will be saved to the database and shown when viewing an entry.', 'leform'), 'type' => 'checkbox'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this field', 'leform'), 'hide' => esc_html__('Hide this field', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id'),
					'validators' => array('values' => array(), 'allowed-values' => array('in-array', 'prevent-duplicates'), 'label' => esc_html__('Validators', 'leform'), 'tooltip' => esc_html__('Validators checks whether the data entered by the user is valid.', 'leform'), 'type' => 'validators')
			),
			'multiselect' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Multiselect', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Options', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the field.', 'leform'), 'type' => 'text'),
					'options' => array('multi-select' => 'on', 'values' => array(array('value' => 'Option 1', 'label' => 'Option 1'), array('value' => 'Option 2', 'label' => 'Option 2'), array('value' => 'Option 3', 'label' => 'Option 3')), 'label' => esc_html__('Options', 'leform'), 'tooltip' => esc_html__('These are the choices that the user will be able to choose from.', 'leform'), 'type' => 'options'),
					'description' => array('value' => 'Select options.', 'label' => esc_html__('Description', 'leform'), 'tooltip' => esc_html__('This description appears below the field.', 'leform'), 'type' => 'text'),
					'required' => array('value' => 'off', 'label' => esc_html__('Required', 'leform'), 'tooltip' => esc_html__('If enabled, the user must fill out the field.', 'leform'), 'caption' => esc_html__('The field is required', 'leform'), 'type' => 'checkbox'),
					'required-error' => array('value' => esc_html__('This field is required.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('required' => array('on'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'label-style' => array('value' => array('position' => '', 'width' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label style', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field and its alignment.', 'leform'), 'type' => 'label-style'),
					'multiselect-style' => array('value' => array('align' => 'left', 'height' => '120', 'hover-background' => '#26B99A', 'hover-color' => '#ffffff', 'selected-background' => '#169F85', 'selected-color' => '#ffffff'), 'caption' => array('align' => esc_html__('Alignment', 'leform'), 'height' => esc_html__('Height', 'leform'), 'hover-color' => esc_html__('Hover colors', 'leform'), 'selected-color' => esc_html__('Selected colors', 'leform')), 'label' => esc_html__('Multiselect style', 'leform'), 'tooltip' => esc_html__('Choose how to display multiselect options.', 'leform'), 'type' => 'multiselect-style'),
					'description-style' => array('value' => array('position' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Align', 'leform')), 'label' => esc_html__('Description style', 'leform'), 'tooltip' => esc_html__('Choose where to display the description relative to the field and its alignment.', 'leform'), 'type' => 'description-style'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'label' => array(
								'label' => esc_html__('Label', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-label .leform-label',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-label .leform-label'
							),
							'description' => array(
								'label' => esc_html__('Description', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input .leform-description',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input .leform-description'
							)
						)
					),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'max-allowed' => array('value' => '0', 'label' => esc_html__('Maximum selected options', 'leform'), 'tooltip' => esc_html__('Enter how many options can be selected. Set 0 for unlimited number.', 'leform'), 'type' => 'integer'),
					'dynamic-default' => array('value' => 'off', 'label' => esc_html__('Dynamic default value', 'leform'), 'tooltip' => esc_html__('Allows the default value of the field to be set dynamically via a URL parameter.', 'leform'), 'type' => 'checkbox'),
					'dynamic-parameter' => array('value' => '', 'label' => esc_html__('Parameter name', 'leform'), 'tooltip' => esc_html__('This is the name of the parameter that you will use to set the default value.', 'leform'), 'type' => 'text', 'visible' => array('dynamic-default' => array('on'))),
					'save' => array('value' => 'on', 'label' => esc_html__('Save to database', 'leform'), 'tooltip' => esc_html__('If enabled, the submitted element data will be saved to the database and shown when viewing an entry.', 'leform'), 'type' => 'checkbox'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this field', 'leform'), 'hide' => esc_html__('Hide this field', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id'),
					'validators' => array('values' => array(), 'allowed-values' => array('in-array', 'prevent-duplicates'), 'label' => esc_html__('Validators', 'leform'), 'tooltip' => esc_html__('Validators checks whether the data entered by the user is valid.', 'leform'), 'type' => 'validators')
			),
			'radio' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Radio button', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Options', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the field.', 'leform'), 'type' => 'text'),
					'options' => array('multi-select' => 'off', 'values' => array(array('value' => 'Option 1', 'label' => 'Option 1'), array('value' => 'Option 2', 'label' => 'Option 2'), array('value' => 'Option 3', 'label' => 'Option 3')), 'label' => esc_html__('Options', 'leform'), 'tooltip' => esc_html__('These are the choices that the user will be able to choose from.', 'leform'), 'type' => 'options'),
					'description' => array('value' => 'Select option.', 'label' => esc_html__('Description', 'leform'), 'tooltip' => esc_html__('This description appears below the field.', 'leform'), 'type' => 'text'),
					'required' => array('value' => 'off', 'label' => esc_html__('Required', 'leform'), 'tooltip' => esc_html__('If enabled, the user must fill out the field.', 'leform'), 'caption' => esc_html__('The field is required', 'leform'), 'type' => 'checkbox'),
					'required-error' => array('value' => esc_html__('This field is required.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('required' => array('on'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'label-style' => array('value' => array('position' => '', 'width' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label style', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field and its alignment.', 'leform'), 'type' => 'label-style'),
					'radio-style' => array('value' => array('position' => '', 'align' => '', 'layout' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Alignment', 'leform'), 'layout' => esc_html__('Layout', 'leform')), 'label' => esc_html__('Radio button style', 'leform'), 'tooltip' => esc_html__('Choose how to display checkbox fields and their captions.', 'leform'), 'type' => 'local-checkbox-style'),
					'description-style' => array('value' => array('position' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Align', 'leform')), 'label' => esc_html__('Description style', 'leform'), 'tooltip' => esc_html__('Choose where to display the description relative to the field and its alignment.', 'leform'), 'type' => 'description-style'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'label' => array(
								'label' => esc_html__('Label', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-label .leform-label',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-label .leform-label'
							),
							'description' => array(
								'label' => esc_html__('Description', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input .leform-description',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input .leform-description'
							)
						)
					),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'dynamic-default' => array('value' => 'off', 'label' => esc_html__('Dynamic default value', 'leform'), 'tooltip' => esc_html__('Allows the default value of the field to be set dynamically via a URL parameter.', 'leform'), 'type' => 'checkbox'),
					'dynamic-parameter' => array('value' => '', 'label' => esc_html__('Parameter name', 'leform'), 'tooltip' => esc_html__('This is the name of the parameter that you will use to set the default value.', 'leform'), 'type' => 'text', 'visible' => array('dynamic-default' => array('on'))),
					'save' => array('value' => 'on', 'label' => esc_html__('Save to database', 'leform'), 'tooltip' => esc_html__('If enabled, the submitted element data will be saved to the database and shown when viewing an entry.', 'leform'), 'type' => 'checkbox'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this field', 'leform'), 'hide' => esc_html__('Hide this field', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id'),
					'validators' => array('values' => array(), 'allowed-values' => array('in-array', 'prevent-duplicates'), 'label' => esc_html__('Validators', 'leform'), 'tooltip' => esc_html__('Validators checks whether the data entered by the user is valid.', 'leform'), 'type' => 'validators')
			),
			'date' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Date', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Date', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the field.', 'leform'), 'type' => 'text'),
					'placeholder' => array('value' => '', 'label' => esc_html__('Placeholder', 'leform'), 'tooltip' => esc_html__('The placeholder text will appear inside the field until the user starts to type.', 'leform'), 'type' => 'text'),
					'autocomplete' => array('value' => 'off', 'label' => esc_html__('Autocomplete attribute', 'leform'), 'tooltip' => esc_html__('Choose the value of the autocomplete attribute. It helps browser to fill the field value, if required.', 'leform'), 'type' => 'select', 'options' => $autocomplete_options),
					'description' => array('value' => 'Select date.', 'label' => esc_html__('Description', 'leform'), 'tooltip' => esc_html__('This description appears below the field.', 'leform'), 'type' => 'text'),
					'required' => array('value' => 'off', 'label' => esc_html__('Required', 'leform'), 'tooltip' => esc_html__('If enabled, the user must fill out the field.', 'leform'), 'type' => 'checkbox'),
					'required-error' => array('value' => esc_html__('This field is required.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('required' => array('on'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'label-style' => array('value' => array('position' => '', 'width' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label style', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field and its alignment.', 'leform'), 'type' => 'label-style'),
					'input-style' => array('value' => array('size' => '', 'align' => ''), 'caption' => array('size' => esc_html__('Size', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Input style', 'leform'), 'tooltip' => esc_html__('Adjust the input field style (size and text alignment).', 'leform'), 'type' => 'input-style'),
					'icon' => array('value' => array('left-icon' => '', 'left-size' => '', 'left-color' => '', 'right-icon' => ($this->options['fa-enable'] == 'on' ? ($this->options['fa-regular-enable'] == 'on' ? 'far fa-calendar-alt' : 'fas fa-calendar-alt') : 'leform-fa leform-fa-calendar'), 'right-size' => '', 'right-color' => ''), 'caption' => array('left' => esc_html__('Left side', 'leform'), 'right' => esc_html__('Right side', 'leform')), 'label' => esc_html__('Input icons', 'leform'), 'tooltip' => esc_html__('These icons appear inside/near of the input field.', 'leform'), 'type' => 'input-icons'),
					'description-style' => array('value' => array('position' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Align', 'leform')), 'label' => esc_html__('Description style', 'leform'), 'tooltip' => esc_html__('Choose where to display the description relative to the field and its alignment.', 'leform'), 'type' => 'description-style'),
					'css-class' => array('value' => '', 'label' => esc_html__('Custom CSS class', 'leform'), 'tooltip' => esc_html__('This class name will be added to the input field.', 'leform'), 'type' => 'text'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'label' => array(
								'label' => esc_html__('Label', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-label .leform-label',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-label .leform-label'
							),
							'input' => array(
								'label' => esc_html__('Input field', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input'
							),
							'input-hover' => array(
								'label' => esc_html__('Input field (hover)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input:hover',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input:hover'
							),
							'input-focus' => array(
								'label' => esc_html__('Input field (focus)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input:focus',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input:focus'
							),
							'input-icon-left' => array(
								'label' => esc_html__('Input field icon (left)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-left',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-left'
							),
							'input-icon-right' => array(
								'label' => esc_html__('Input field icon (right)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-right',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-right'
							),
							'description' => array(
								'label' => esc_html__('Description', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input .leform-description',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input .leform-description'
							)
						)
					),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'default' => array('value' => '', 'label' => esc_html__('Default value', 'leform'), 'tooltip' => esc_html__('The default value is the value that the field has before the user has entered anything.', 'leform'), 'type' => 'date'),
					'dynamic-default' => array('value' => 'off', 'label' => esc_html__('Dynamic default value', 'leform'), 'tooltip' => esc_html__('Allows the default value of the field to be set dynamically via a URL parameter.', 'leform'), 'type' => 'checkbox'),
					'dynamic-parameter' => array('value' => '', 'label' => esc_html__('Parameter name', 'leform'), 'tooltip' => esc_html__('This is the name of the parameter that you will use to set the default value.', 'leform'), 'type' => 'text', 'visible' => array('dynamic-default' => array('on'))),
					'min-date' => array('value' => array('type' => '', 'date' => '', 'field' => ''), 'caption' => array('type' => esc_html__('Type', 'leform'), 'date' => esc_html__('Date', 'leform'), 'field' => esc_html__('Field', 'leform')), 'type-values' => array('none' => esc_html__('None', 'leform'), 'yesterday' => esc_html__('Yesterday', 'leform'), 'today' => esc_html__('Today', 'leform'), 'tomorrow' => esc_html__('Tomorrow', 'leform'), 'date' => esc_html__('Fixed date', 'leform'), 'field' => esc_html__('Other field', 'leform')), 'label' => esc_html__('Minimum date', 'leform'), 'tooltip' => esc_html__('Adjust the minimum date that can be selected.', 'leform'), 'type' => 'date-limit'),
					'min-date-error' => array('value' => esc_html__('The value is out of range.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('This error message appears if submitted date is less than minimum date.', 'leform'), 'type' => 'error', 'visible' => array('min-date-type' => array('yesterday', 'today', 'tomorrow', 'date', 'field'))),
					'max-date' => array('value' => array('type' => '', 'date' => '', 'field' => ''), 'caption' => array('type' => esc_html__('Type', 'leform'), 'date' => esc_html__('Date', 'leform'), 'field' => esc_html__('Field', 'leform')), 'type-values' => array('none' => esc_html__('None', 'leform'), 'yesterday' => esc_html__('Yesterday', 'leform'), 'today' => esc_html__('Today', 'leform'), 'tomorrow' => esc_html__('Tomorrow', 'leform'), 'date' => esc_html__('Fixed date', 'leform'), 'field' => esc_html__('Other field', 'leform')), 'label' => esc_html__('Maximum date', 'leform'), 'tooltip' => esc_html__('Adjust the maximum date that can be selected.', 'leform'), 'type' => 'date-limit'),
					'max-date-error' => array('value' => esc_html__('The value is out of range.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('This error message appears if submitted date is more than minimum date.', 'leform'), 'type' => 'error', 'visible' => array('max-date-type' => array('yesterday', 'today', 'tomorrow', 'date', 'field'))),
					'readonly' => array('value' => 'off', 'label' => esc_html__('Read only', 'leform'), 'tooltip' => esc_html__('If enabled, the user can not edit the field value.', 'leform'), 'type' => 'checkbox'),
					'save' => array('value' => 'on', 'label' => esc_html__('Save to database', 'leform'), 'tooltip' => esc_html__('If enabled, the submitted element data will be saved to the database and shown when viewing an entry.', 'leform'), 'type' => 'checkbox'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this field', 'leform'), 'hide' => esc_html__('Hide this field', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id'),
					'filters' => array('values' => array(array("type" => "trim", "properties" => null)), 'allowed-values' => array('alpha', 'alphanumeric', 'digits', 'regex', 'strip-tags', 'trim'), 'label' => esc_html__('Filters', 'leform'), 'tooltip' => esc_html__('Filters allow you to strip various characters from the submitted value.', 'leform'), 'type' => 'filters'),
					'validators' => array('values' => array(array("type" => "date", "properties" => array('error' => ''))), 'allowed-values' => array('date'), 'label' => esc_html__('Validators', 'leform'), 'tooltip' => esc_html__('Validators checks whether the data entered by the user is valid.', 'leform'), 'type' => 'validators')
			),
			'time' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Time', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Time', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the field.', 'leform'), 'type' => 'text'),
					'placeholder' => array('value' => '', 'label' => esc_html__('Placeholder', 'leform'), 'tooltip' => esc_html__('The placeholder text will appear inside the field until the user starts to type.', 'leform'), 'type' => 'text'),
					'description' => array('value' => 'Select time.', 'label' => esc_html__('Description', 'leform'), 'tooltip' => esc_html__('This description appears below the field.', 'leform'), 'type' => 'text'),
					'required' => array('value' => 'off', 'label' => esc_html__('Required', 'leform'), 'tooltip' => esc_html__('If enabled, the user must fill out the field.', 'leform'), 'type' => 'checkbox'),
					'required-error' => array('value' => esc_html__('This field is required.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('required' => array('on'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'label-style' => array('value' => array('position' => '', 'width' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label style', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field and its alignment.', 'leform'), 'type' => 'label-style'),
					'input-style' => array('value' => array('size' => '', 'align' => ''), 'caption' => array('size' => esc_html__('Size', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Input style', 'leform'), 'tooltip' => esc_html__('Adjust the input field style (size and text alignment).', 'leform'), 'type' => 'input-style'),
					'icon' => array('value' => array('left-icon' => '', 'left-size' => '', 'left-color' => '', 'right-icon' => ($this->options['fa-enable'] == 'on' ? ($this->options['fa-regular-enable'] == 'on' ? 'far fa-clock' : 'fas fa-clock') : 'leform-fa leform-fa-clock-o'), 'right-size' => '', 'right-color' => ''), 'caption' => array('left' => esc_html__('Left side', 'leform'), 'right' => esc_html__('Right side', 'leform')), 'label' => esc_html__('Input icons', 'leform'), 'tooltip' => esc_html__('These icons appear inside/near of the input field.', 'leform'), 'type' => 'input-icons'),
					'description-style' => array('value' => array('position' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Align', 'leform')), 'label' => esc_html__('Description style', 'leform'), 'tooltip' => esc_html__('Choose where to display the description relative to the field and its alignment.', 'leform'), 'type' => 'description-style'),
					'css-class' => array('value' => '', 'label' => esc_html__('Custom CSS class', 'leform'), 'tooltip' => esc_html__('This class name will be added to the input field.', 'leform'), 'type' => 'text'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'label' => array(
								'label' => esc_html__('Label', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-label .leform-label',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-label .leform-label'
							),
							'input' => array(
								'label' => esc_html__('Input field', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input'
							),
							'input-hover' => array(
								'label' => esc_html__('Input field (hover)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input:hover',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input:hover'
							),
							'input-focus' => array(
								'label' => esc_html__('Input field (focus)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input:focus',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input:focus'
							),
							'input-icon-left' => array(
								'label' => esc_html__('Input field icon (left)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-left',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-left'
							),
							'input-icon-right' => array(
								'label' => esc_html__('Input field icon (right)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-right',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-right'
							),
							'description' => array(
								'label' => esc_html__('Description', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input .leform-description',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input .leform-description'
							)
						)
					),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'default' => array('value' => '', 'label' => esc_html__('Default value', 'leform'), 'tooltip' => esc_html__('The default value is the value that the field has before the user has entered anything.', 'leform'), 'type' => 'time'),
					'dynamic-default' => array('value' => 'off', 'label' => esc_html__('Dynamic default value', 'leform'), 'tooltip' => esc_html__('Allows the default value of the field to be set dynamically via a URL parameter.', 'leform'), 'type' => 'checkbox'),
					'dynamic-parameter' => array('value' => '', 'label' => esc_html__('Parameter name', 'leform'), 'tooltip' => esc_html__('This is the name of the parameter that you will use to set the default value.', 'leform'), 'type' => 'text', 'visible' => array('dynamic-default' => array('on'))),
					'min-time' => array('value' => array('type' => '', 'time' => '', 'field' => ''), 'caption' => array('type' => esc_html__('Type', 'leform'), 'time' => esc_html__('Time', 'leform'), 'field' => esc_html__('Field', 'leform')), 'type-values' => array('none' => esc_html__('None', 'leform'), 'time' => esc_html__('Fixed time', 'leform'), 'field' => esc_html__('Other field', 'leform')), 'label' => esc_html__('Minimum time', 'leform'), 'tooltip' => esc_html__('Adjust the minimum time that can be selected.', 'leform'), 'type' => 'time-limit'),
					'min-time-error' => array('value' => esc_html__('The value is out of range.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('This error message appears if submitted time is less than minimum time.', 'leform'), 'type' => 'error', 'visible' => array('min-time-type' => array('time', 'field'))),
					'max-time' => array('value' => array('type' => '', 'time' => '', 'field' => ''), 'caption' => array('type' => esc_html__('Type', 'leform'), 'time' => esc_html__('Time', 'leform'), 'field' => esc_html__('Field', 'leform')), 'type-values' => array('none' => esc_html__('None', 'leform'), 'time' => esc_html__('Fixed time', 'leform'), 'field' => esc_html__('Other field', 'leform')), 'label' => esc_html__('Maximum time', 'leform'), 'tooltip' => esc_html__('Adjust the maximum time that can be selected.', 'leform'), 'type' => 'time-limit'),
					'max-time-error' => array('value' => esc_html__('The value is out of range.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('This error message appears if submitted time is more than minimum time.', 'leform'), 'type' => 'error', 'visible' => array('max-time-type' => array('time', 'field'))),
					'interval' => array('value' => '10', 'label' => esc_html__('Minute interval', 'leform'), 'tooltip' => esc_html__('Enter the minute interval.', 'leform'), 'type' => 'integer'),
					'readonly' => array('value' => 'off', 'label' => esc_html__('Read only', 'leform'), 'tooltip' => esc_html__('If enabled, the user can not edit the field value manually, only via timepicker.', 'leform'), 'type' => 'checkbox'),
					'save' => array('value' => 'on', 'label' => esc_html__('Save to database', 'leform'), 'tooltip' => esc_html__('If enabled, the submitted element data will be saved to the database and shown when viewing an entry.', 'leform'), 'type' => 'checkbox'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this field', 'leform'), 'hide' => esc_html__('Hide this field', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id'),
					'filters' => array('values' => array(array("type" => "trim", "properties" => null)), 'allowed-values' => array('alpha', 'alphanumeric', 'digits', 'regex', 'strip-tags', 'trim'), 'label' => esc_html__('Filters', 'leform'), 'tooltip' => esc_html__('Filters allow you to strip various characters from the submitted value.', 'leform'), 'type' => 'filters'),
					'validators' => array('values' => array(array("type" => "time", "properties" => array('error' => ''))), 'allowed-values' => array('time'), 'label' => esc_html__('Validators', 'leform'), 'tooltip' => esc_html__('Validators checks whether the data entered by the user is valid.', 'leform'), 'type' => 'validators')
			),
			'file' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Upload', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Upload', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the field.', 'leform'), 'type' => 'text'),
					'button-label' => array('value' => esc_html__('Browse...', 'leform'), 'label' => esc_html__('Caption', 'leform'), 'tooltip' => esc_html__('This is the caption of upload button.', 'leform'), 'type' => 'text'),
					'description' => array('value' => 'Upload file.', 'label' => esc_html__('Description', 'leform'), 'tooltip' => esc_html__('This description appears below the field.', 'leform'), 'type' => 'text'),
					'required' => array('value' => 'off', 'label' => esc_html__('Required', 'leform'), 'tooltip' => esc_html__('If enabled, the user must fill out the field.', 'leform'), 'type' => 'checkbox'),
					'required-error' => array('value' => esc_html__('This field is required.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('required' => array('on'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'label-style' => array('value' => array('position' => '', 'width' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label style', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field and its alignment.', 'leform'), 'type' => 'label-style'),
					'button-style' => array('value' => array('size' => '', 'width' => '', 'position' => 'left'), 'caption' => array('size' => esc_html__('Size', 'leform'), 'width' => esc_html__('Width', 'leform'), 'position' => esc_html__('Position', 'leform')), 'label' => esc_html__('Button style', 'leform'), 'tooltip' => esc_html__('Adjust the button size and position.', 'leform'), 'type' => 'local-button-style'),
					'icon' => array('value' => array('left' => '', 'right' => ($this->options['fa-enable'] == 'on' ? 'fas fa-upload' : 'leform-fa leform-fa-upload')), 'caption' => array('left' => esc_html__('Left side', 'leform'), 'right' => esc_html__('Right side', 'leform')), 'label' => esc_html__('Icons', 'leform'), 'tooltip' => esc_html__('These icons appear near the button caption.', 'leform'), 'type' => 'button-icons'),
					'colors-sections' => array('type' => 'sections', 'sections' => array(
						'button-default' => array('label' => esc_html__('Default', 'leform'), 'icon' => 'fas fa-globe'),
						'button-hover' => array('label' => esc_html__('Hover', 'leform'), 'icon' => 'far fa-hand-pointer'),
						'button-active' => array('label' => esc_html__('Active', 'leform'), 'icon' => 'far fa-paper-plane')
					)),
					'start-button-default' => array('type' => 'section-start', 'section' => 'button-default'),
						'colors' => array('value' => array('background' => '', 'border' => '', 'text' => ''), 'caption' => array('background' => esc_html__('Background', 'leform'), 'border' => esc_html__('Border', 'leform'), 'text' => esc_html__('Text', 'leform')), 'label' => esc_html__('Colors', 'leform'), 'tooltip' => esc_html__('Adjust the colors of the button.', 'leform'), 'type' => 'colors'),
					'end-button-default' => array('type' => 'section-end'),
					'start-button-hover' => array('type' => 'section-start', 'section' => 'button-hover'),
						'colors-hover' => array('value' => array('background' => '', 'border' => '', 'text' => ''), 'caption' => array('background' => esc_html__('Background', 'leform'), 'border' => esc_html__('Border', 'leform'), 'text' => esc_html__('Text', 'leform')), 'label' => esc_html__('Colors', 'leform'), 'tooltip' => esc_html__('Adjust the colors of the hovered button.', 'leform'), 'type' => 'colors'),
					'end-button-hover' => array('type' => 'section-end'),
					'start-button-active' => array('type' => 'section-start', 'section' => 'button-active'),
						'colors-active' => array('value' => array('background' => '', 'border' => '', 'text' => ''), 'caption' => array('background' => esc_html__('Background', 'leform'), 'border' => esc_html__('Border', 'leform'), 'text' => esc_html__('Text', 'leform')), 'label' => esc_html__('Colors', 'leform'), 'tooltip' => esc_html__('Adjust the colors of the active button.', 'leform'), 'type' => 'colors'),
					'end-button-active' => array('type' => 'section-end'),
					'description-style' => array('value' => array('position' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Align', 'leform')), 'label' => esc_html__('Description style', 'leform'), 'tooltip' => esc_html__('Choose where to display the description relative to the field and its alignment.', 'leform'), 'type' => 'description-style'),
					'css-class' => array('value' => '', 'label' => esc_html__('Custom CSS class', 'leform'), 'tooltip' => esc_html__('This class name will be added to the button.', 'leform'), 'type' => 'text'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'button' => array(
								'label' => esc_html__('Button', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button'
							),
							'button-hover' => array(
								'label' => esc_html__('Button (hover)', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button:hover',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button:hover'
							),
							'button-active' => array(
								'label' => esc_html__('Button (active)', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button:active',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button:active'
							),
							'button-icon-left' => array(
								'label' => esc_html__('Button icon (left)', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button i.leform-icon-left',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button i.leform-icon-left'
							),
							'button-icon-right' => array(
								'label' => esc_html__('Button icon (right)', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button i.leform-icon-right',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button i.leform-icon-right'
							),
						)
					),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'allowed-extensions' => array('value' => esc_html__('gif, jpg, jpeg, png', 'leform'), 'label' => esc_html__('Allowed extensions', 'leform'), 'tooltip' => esc_html__('Enter the comma-separated list of allowed file extensions.', 'leform'), 'type' => 'text'),
					'allowed-extensions-error' => array('value' => esc_html__('Selected file extension is not allowed.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('This message appears if user tries to upload any file with extension not from the list.', 'leform'), 'type' => 'error'),
					'max-size' => array('value' => '10', 'label' => esc_html__('Maximum allowed size', 'leform'), 'tooltip' => sprintf(esc_html__('Enter the maximum size of a file in MB. According to your PHP settings, the maximum file size allowed is %s. Do not exceed this value.', 'leform'), ini_get('upload_max_filesize')), 'unit' => 'mb', 'type' => 'units'),
					'max-size-error' => array('value' => esc_html__('Selected file is too big.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('This message appears if user tries to upload any file bigger then maximum allowed file size.', 'leform'), 'type' => 'error'),
					'max-files' => array('value' => '3', 'label' => esc_html__('Maximum number of files', 'leform'), 'tooltip' => esc_html__('Enter the maximum number of files that can be uploaded by user.', 'leform'), 'type' => 'integer'),
					'max-files-error' => array('value' => esc_html__('Too many files.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('This message appears if user tries to upload more files then maximum number of files.', 'leform'), 'type' => 'error'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this field', 'leform'), 'hide' => esc_html__('Hide this field', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id')
			),
			'star-rating' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Rating', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Rating', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the field.', 'leform'), 'type' => 'text'),
					'description' => array('value' => 'Rate us.', 'label' => esc_html__('Description', 'leform'), 'tooltip' => esc_html__('This description appears below the field.', 'leform'), 'type' => 'text'),
					'required' => array('value' => 'off', 'label' => esc_html__('Required', 'leform'), 'tooltip' => esc_html__('If enabled, the user must fill out the field.', 'leform'), 'type' => 'checkbox'),
					'required-error' => array('value' => esc_html__('This field is required.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('required' => array('on'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'label-style' => array('value' => array('position' => '', 'width' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label style', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field and its alignment.', 'leform'), 'type' => 'label-style'),
					'star-style' => array('value' => array('position' => 'left', 'size' => 'medium', 'color-unrated' => '#aaa', 'color-rated' => '#FFD700'), 'caption' => array('position' => esc_html__('Position', 'leform'), 'size' => esc_html__('Size', 'leform'), 'color-unrated' => esc_html__('Unrated', 'leform'), 'color-rated' => esc_html__('Rated', 'leform')), 'label' => esc_html__('Star style', 'leform'), 'tooltip' => esc_html__('Adjust the style of stars.', 'leform'), 'type' => 'star-style'),
					'description-style' => array('value' => array('position' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Align', 'leform')), 'label' => esc_html__('Description style', 'leform'), 'tooltip' => esc_html__('Choose where to display the description relative to the field and its alignment.', 'leform'), 'type' => 'description-style'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'label' => array(
								'label' => esc_html__('Label', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-label .leform-label',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-label .leform-label'
							),
							'description' => array(
								'label' => esc_html__('Description', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input .leform-description',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input .leform-description'
							)
						)
					),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'total-stars' => array('value' => '5', 'label' => esc_html__('Number of stars', 'leform'), 'tooltip' => esc_html__('Choose the total number of stars.', 'leform'), 'type' => 'select', 'options' => array('3' => esc_html__('3 Stars', 'leform'), '4' => esc_html__('4 Stars', 'leform'), '5' => esc_html__('5 Stars', 'leform'), '6' => esc_html__('6 Stars', 'leform'), '7' => esc_html__('7 Stars', 'leform'), '8' => esc_html__('8 Stars', 'leform'), '9' => esc_html__('9 Stars', 'leform'), '10' => esc_html__('10 Stars', 'leform'))),
					'default' => array('value' => '0', 'label' => esc_html__('Default rating', 'leform'), 'tooltip' => esc_html__('The default value is the value that the field has before the user has entered anything.', 'leform'), 'type' => 'select', 'options' => array('0' => esc_html__('No rating', 'leform'), '1' => esc_html__('1 Star', 'leform'), '2' => esc_html__('2 Stars', 'leform'), '3' => esc_html__('3 Stars', 'leform'), '4' => esc_html__('4 Stars', 'leform'), '5' => esc_html__('5 Stars', 'leform'), '6' => esc_html__('6 Stars', 'leform'), '7' => esc_html__('7 Stars', 'leform'), '8' => esc_html__('8 Stars', 'leform'), '9' => esc_html__('9 Stars', 'leform'), '10' => esc_html__('10 Stars', 'leform'))),
					'dynamic-default' => array('value' => 'off', 'label' => esc_html__('Dynamic default value', 'leform'), 'tooltip' => esc_html__('Allows the default value of the field to be set dynamically via a URL parameter.', 'leform'), 'type' => 'checkbox'),
					'dynamic-parameter' => array('value' => '', 'label' => esc_html__('Parameter name', 'leform'), 'tooltip' => esc_html__('This is the name of the parameter that you will use to set the default value.', 'leform'), 'type' => 'text', 'visible' => array('dynamic-default' => array('on'))),
					'save' => array('value' => 'on', 'label' => esc_html__('Save to database', 'leform'), 'tooltip' => esc_html__('If enabled, the submitted element data will be saved to the database and shown when viewing an entry.', 'leform'), 'type' => 'checkbox'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this field', 'leform'), 'hide' => esc_html__('Hide this field', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id')
			),
			'password' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Password', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Password', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the field.', 'leform'), 'type' => 'text'),
					'placeholder' => array('value' => '', 'label' => esc_html__('Placeholder', 'leform'), 'tooltip' => esc_html__('The placeholder text will appear inside the field until the user starts to type.', 'leform'), 'type' => 'text'),
					'description' => array('value' => 'Enter your password.', 'label' => esc_html__('Description', 'leform'), 'tooltip' => esc_html__('This description appears below the field.', 'leform'), 'type' => 'text'),
					'required' => array('value' => 'off', 'label' => esc_html__('Required', 'leform'), 'tooltip' => esc_html__('If enabled, the user must fill out the field.', 'leform'), 'type' => 'checkbox'),
					'required-error' => array('value' => esc_html__('This field is required.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('required' => array('on'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'label-style' => array('value' => array('position' => '', 'width' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'width' => esc_html__('Width', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Label style', 'leform'), 'tooltip' => esc_html__('Choose where to display the label relative to the field and its alignment.', 'leform'), 'type' => 'label-style'),
					'input-style' => array('value' => array('size' => '', 'align' => ''), 'caption' => array('size' => esc_html__('Size', 'leform'), 'align' => esc_html__('Alignment', 'leform')), 'label' => esc_html__('Input style', 'leform'), 'tooltip' => esc_html__('Adjust the input field style (size and text alignment).', 'leform'), 'type' => 'input-style'),
					'icon' => array('value' => array('left-icon' => ($this->options['fa-enable'] == 'on' ? 'fas fa-lock' : 'leform-fa leform-fa-lock'), 'left-size' => '', 'left-color' => '', 'right-icon' => '', 'right-size' => '', 'right-color' => ''), 'caption' => array('left' => esc_html__('Left side', 'leform'), 'right' => esc_html__('Right side', 'leform')), 'label' => esc_html__('Input icons', 'leform'), 'tooltip' => esc_html__('These icons appear inside/near of the input field.', 'leform'), 'type' => 'input-icons'),
					'description-style' => array('value' => array('position' => '', 'align' => ''), 'caption' => array('position' => esc_html__('Position', 'leform'), 'align' => esc_html__('Align', 'leform')), 'label' => esc_html__('Description style', 'leform'), 'tooltip' => esc_html__('Choose where to display the description relative to the field and its alignment.', 'leform'), 'type' => 'description-style'),
					'css-class' => array('value' => '', 'label' => esc_html__('Custom CSS class', 'leform'), 'tooltip' => esc_html__('This class name will be added to the input field.', 'leform'), 'type' => 'text'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'label' => array(
								'label' => esc_html__('Label', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-label .leform-label',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-label .leform-label'
							),
							'input' => array(
								'label' => esc_html__('Input field', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input'
							),
							'input-hover' => array(
								'label' => esc_html__('Input field (hover)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input:hover',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input:hover'
							),
							'input-focus' => array(
								'label' => esc_html__('Input field (focus)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input input:focus',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input input:focus'
							),
							'input-icon-left' => array(
								'label' => esc_html__('Input field icon (left)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-left',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-left'
							),
							'input-icon-right' => array(
								'label' => esc_html__('Input field icon (right)', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-right',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input div.leform-input i.leform-icon-right'
							),
							'description' => array(
								'label' => esc_html__('Description', 'leform'),
								'admin-class' => '.leform-element-{element-id} .leform-column-input .leform-description',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} .leform-column-input .leform-description'
							)
						)
					),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'min-length' => array('value' => '7', 'label' => esc_html__('Minimum length', 'leform'), 'tooltip' => esc_html__('Enter the minimum password length.', 'leform'), 'type' => 'integer'),
					'min-length-error' => array('value' => esc_html__('The password is too short.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('This message appears if submitted password is too short.', 'leform'), 'type' => 'error'),
					'capital-mandatory' => array('value' => 'off', 'label' => esc_html__('Capital letters is mandatory', 'leform'), 'tooltip' => esc_html__('If enabled, the password must contains at least one capital letter.', 'leform'), 'type' => 'checkbox'),
					'capital-mandatory-error' => array('value' => esc_html__('The password must contain capital letter.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('capital-mandatory' => array('on'))),
					'digit-mandatory' => array('value' => 'off', 'label' => esc_html__('Digit is mandatory', 'leform'), 'tooltip' => esc_html__('If enabled, the password must contains at least one digit.', 'leform'), 'type' => 'checkbox'),
					'digit-mandatory-error' => array('value' => esc_html__('The password must contain digit.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('digit-mandatory' => array('on'))),
					'special-mandatory' => array('value' => 'off', 'label' => esc_html__('Special character is mandatory', 'leform'), 'tooltip' => esc_html__('If enabled, the password must contains at least one special character: !$#%^&*~_-(){}[]\|/?.', 'leform'), 'type' => 'checkbox'),
					'special-mandatory-error' => array('value' => esc_html__('The password must contain special character.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'type' => 'error', 'visible' => array('special-mandatory' => array('on'))),
					'save' => array('value' => 'off', 'label' => esc_html__('Save to database', 'leform'), 'tooltip' => esc_html__('If enabled, the submitted element data will be saved to the database and shown when viewing an entry.', 'leform'), 'type' => 'checkbox'),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this field', 'leform'), 'hide' => esc_html__('Hide this field', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id'),
			),
			'hidden' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Hidden field', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
				'data' => array('type' => 'tab', 'value' => 'data', 'label' => esc_html__('Data', 'leform')),
					'default' => array('value' => '', 'label' => esc_html__('Default value', 'leform'), 'tooltip' => esc_html__('The default value is the value that the field has before the user has entered anything.', 'leform'), 'type' => 'text'),
					'dynamic-default' => array('value' => 'off', 'label' => esc_html__('Dynamic default value', 'leform'), 'tooltip' => esc_html__('Allows the default value of the field to be set dynamically via a URL parameter.', 'leform'), 'type' => 'checkbox'),
					'dynamic-parameter' => array('value' => '', 'label' => esc_html__('Parameter name', 'leform'), 'tooltip' => esc_html__('This is the name of the parameter that you will use to set the default value.', 'leform'), 'type' => 'text', 'visible' => array('dynamic-default' => array('on'))),
					'save' => array('value' => 'on', 'label' => esc_html__('Save to database', 'leform'), 'tooltip' => esc_html__('If enabled, the submitted element data will be saved to the database and shown when viewing an entry.', 'leform'), 'type' => 'checkbox'),
				'advanced' => array('type' => 'tab', 'value' => 'advanced', 'label' => esc_html__('Advanced', 'leform')),
					'element-id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the input field.', 'leform'), 'type' => 'id'),
			),
			'button' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Button', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name is used for your reference.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Submit', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the button.', 'leform'), 'type' => 'text'),
					'button-type' => array('value' => 'submit', 'label' => esc_html__('Type', 'leform'), 'tooltip' => esc_html__('Choose the type of the button.', 'leform'), 'type' => 'radio-bar', 'options' => array('submit' => esc_html__('Submit', 'leform'), 'prev' => esc_html__('Back', 'leform'), 'next' => esc_html__('Next', 'leform'))),
					'label-loading' => array('value' => esc_html__('Sending...', 'leform'), 'label' => esc_html__('Sending label', 'leform'), 'type' => 'text', 'tooltip' => esc_html__('This is the label of the button when data are sending to server.', 'leform'), 'visible' => array('button-type' => array('submit', 'next'))),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'button-style' => array('value' => array('size' => '', 'width' => '', 'position' => ''), 'caption' => array('size' => esc_html__('Size', 'leform'), 'width' => esc_html__('Width', 'leform'), 'position' => esc_html__('Position', 'leform')), 'label' => esc_html__('Style', 'leform'), 'tooltip' => esc_html__('Adjust the button size and position.', 'leform'), 'type' => 'local-button-style'),
					'icon' => array('value' => array('left' => '', 'right' => ''), 'caption' => array('left' => esc_html__('Left side', 'leform'), 'right' => esc_html__('Right side', 'leform')), 'label' => esc_html__('Icons', 'leform'), 'tooltip' => esc_html__('These icons appear near the button label.', 'leform'), 'type' => 'button-icons'),
					'colors-sections' => array('type' => 'sections', 'sections' => array(
						'button-default' => array('label' => esc_html__('Default', 'leform'), 'icon' => 'fas fa-globe'),
						'button-hover' => array('label' => esc_html__('Hover', 'leform'), 'icon' => 'far fa-hand-pointer'),
						'button-active' => array('label' => esc_html__('Active', 'leform'), 'icon' => 'far fa-paper-plane')
					)),
					'start-button-default' => array('type' => 'section-start', 'section' => 'button-default'),
						'colors' => array('value' => array('background' => '', 'border' => '', 'text' => ''), 'caption' => array('background' => esc_html__('Background', 'leform'), 'border' => esc_html__('Border', 'leform'), 'text' => esc_html__('Text', 'leform')), 'label' => esc_html__('Colors', 'leform'), 'tooltip' => esc_html__('Adjust the colors of the button.', 'leform'), 'type' => 'colors'),
					'end-button-default' => array('type' => 'section-end'),
					'start-button-hover' => array('type' => 'section-start', 'section' => 'button-hover'),
						'colors-hover' => array('value' => array('background' => '', 'border' => '', 'text' => ''), 'caption' => array('background' => esc_html__('Background', 'leform'), 'border' => esc_html__('Border', 'leform'), 'text' => esc_html__('Text', 'leform')), 'label' => esc_html__('Colors', 'leform'), 'tooltip' => esc_html__('Adjust the colors of the hovered button.', 'leform'), 'type' => 'colors'),
					'end-button-hover' => array('type' => 'section-end'),
					'start-button-active' => array('type' => 'section-start', 'section' => 'button-active'),
						'colors-active' => array('value' => array('background' => '', 'border' => '', 'text' => ''), 'caption' => array('background' => esc_html__('Background', 'leform'), 'border' => esc_html__('Border', 'leform'), 'text' => esc_html__('Text', 'leform')), 'label' => esc_html__('Colors', 'leform'), 'tooltip' => esc_html__('Adjust the colors of the active button.', 'leform'), 'type' => 'colors'),
					'end-button-active' => array('type' => 'section-end'),
					'css-class' => array('value' => '', 'label' => esc_html__('Custom CSS class', 'leform'), 'tooltip' => esc_html__('This class name will be added to the button.', 'leform'), 'type' => 'text'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'button' => array(
								'label' => esc_html__('Button', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button'
							),
							'button-hover' => array(
								'label' => esc_html__('Button (hover)', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button:hover',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button:hover'
							),
							'button-active' => array(
								'label' => esc_html__('Button (active)', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button:active',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button:active'
							),
							'button-icon-left' => array(
								'label' => esc_html__('Button icon (left)', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button i.leform-icon-left',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button i.leform-icon-left'
							),
							'button-icon-right' => array(
								'label' => esc_html__('Button icon (right)', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button i.leform-icon-right',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button i.leform-icon-right'
							),
						)
					),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this button', 'leform'), 'hide' => esc_html__('Hide this button', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
			),
			'link-button' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('Button', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name will be shown in place of the label throughout the plugin, in the notification email and when viewing submitted form entries.', 'leform'), 'type' => 'text'),
					'label' => array('value' => esc_html__('Link', 'leform'), 'label' => esc_html__('Label', 'leform'), 'tooltip' => esc_html__('This is the label of the button.', 'leform'), 'type' => 'text'),
					'link' => array('value' => '', 'label' => esc_html__('URL', 'leform'), 'type' => 'text', 'tooltip' => esc_html__('Specify the URL where users redirected to.', 'leform')),
					'new-tab' => array('value' => 'off', 'label' => esc_html__('Open link in new tab', 'leform'), 'tooltip' => esc_html__('If enabled, the link will be opened in new tab.', 'leform'), 'type' => 'checkbox'),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'button-style' => array('value' => array('size' => '', 'width' => '', 'position' => ''), 'caption' => array('size' => esc_html__('Size', 'leform'), 'width' => esc_html__('Width', 'leform'), 'position' => esc_html__('Position', 'leform')), 'label' => esc_html__('Style', 'leform'), 'tooltip' => esc_html__('Adjust the button size and position).', 'leform'), 'type' => 'local-button-style'),
					'icon' => array('value' => array('left' => '', 'right' => ''), 'caption' => array('left' => esc_html__('Left side', 'leform'), 'right' => esc_html__('Right side', 'leform')), 'label' => esc_html__('Icons', 'leform'), 'tooltip' => esc_html__('These icons appear near the button label.', 'leform'), 'type' => 'button-icons'),
					'colors-sections' => array('type' => 'sections', 'sections' => array(
						'button-default' => array('label' => esc_html__('Default', 'leform'), 'icon' => 'fas fa-globe'),
						'button-hover' => array('label' => esc_html__('Hover', 'leform'), 'icon' => 'far fa-hand-pointer'),
						'button-active' => array('label' => esc_html__('Active', 'leform'), 'icon' => 'far fa-paper-plane')
					)),
					'start-button-default' => array('type' => 'section-start', 'section' => 'button-default'),
						'colors' => array('value' => array('background' => '', 'border' => '', 'text' => ''), 'caption' => array('background' => esc_html__('Background', 'leform'), 'border' => esc_html__('Border', 'leform'), 'text' => esc_html__('Text', 'leform')), 'label' => esc_html__('Colors', 'leform'), 'tooltip' => esc_html__('Adjust the colors of the button.', 'leform'), 'type' => 'colors'),
					'end-button-default' => array('type' => 'section-end'),
					'start-button-hover' => array('type' => 'section-start', 'section' => 'button-hover'),
						'colors-hover' => array('value' => array('background' => '', 'border' => '', 'text' => ''), 'caption' => array('background' => esc_html__('Background', 'leform'), 'border' => esc_html__('Border', 'leform'), 'text' => esc_html__('Text', 'leform')), 'label' => esc_html__('Colors', 'leform'), 'tooltip' => esc_html__('Adjust the colors of the hovered button.', 'leform'), 'type' => 'colors'),
					'end-button-hover' => array('type' => 'section-end'),
					'start-button-active' => array('type' => 'section-start', 'section' => 'button-active'),
						'colors-active' => array('value' => array('background' => '', 'border' => '', 'text' => ''), 'caption' => array('background' => esc_html__('Background', 'leform'), 'border' => esc_html__('Border', 'leform'), 'text' => esc_html__('Text', 'leform')), 'label' => esc_html__('Colors', 'leform'), 'tooltip' => esc_html__('Adjust the colors of the active button.', 'leform'), 'type' => 'colors'),
					'end-button-active' => array('type' => 'section-end'),
					'css-class' => array('value' => '', 'label' => esc_html__('Custom CSS class', 'leform'), 'tooltip' => esc_html__('This class name will be added to the button.', 'leform'), 'type' => 'text'),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							),
							'button' => array(
								'label' => esc_html__('Button', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button'
							),
							'button-hover' => array(
								'label' => esc_html__('Button (hover)', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button:hover',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button:hover'
							),
							'button-active' => array(
								'label' => esc_html__('Button (active)', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button:active',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button:active'
							),
							'button-icon-left' => array(
								'label' => esc_html__('Button icon (left)', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button i.leform-icon-left',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button i.leform-icon-left'
							),
							'button-icon-right' => array(
								'label' => esc_html__('Button icon (right)', 'leform'),
								'admin-class' => '.leform-element-{element-id} a.leform-button i.leform-icon-right',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id} a.leform-button i.leform-icon-right'
							),
						)
					),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this button', 'leform'), 'hide' => esc_html__('Hide this button', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
			),
			'html' => array(
				'basic' => array('type' => 'tab', 'value' => 'basic', 'label' => esc_html__('Basic', 'leform')),
					'name' => array('value' => esc_html__('HTML Content', 'leform'), 'label' => esc_html__('Name', 'leform'), 'type' => 'text'),
					'content' => array('value' => '<p>'.esc_html__('Default HTML Content.', 'leform').'</p>', 'label' => esc_html__('HTML', 'leform'), 'tooltip' => esc_html__('This is the content of HTML.', 'leform'), 'type' => 'html'),
				'style' => array('type' => 'tab', 'value' => 'style', 'label' => esc_html__('Style', 'leform')),
					'css' => array('type' => 'css', 'values' => array(), 'label' => esc_html__('CSS styles', 'leform'), 'tooltip' => esc_html__('Once you have added a style, enter the CSS styles.', 'leform'), 'selectors' => array(
							'wrapper' => array(
								'label' => esc_html__('Wrapper', 'leform'),
								'admin-class' => '.leform-element-{element-id}',
								'front-class' => '.leform-form-{form-id} .leform-element-{element-id}'
							)
						)
					),
				'logic-tab' => array('type' => 'tab', 'value' => 'logic', 'label' => esc_html__('Logic', 'leform')),
					'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'checkbox'),
					'logic' => array('values' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Show this element', 'leform'), 'hide' => esc_html__('Hide this element', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show or hide this element depending on the values of other fields.', 'leform'), 'type' => 'logic-rules', 'visible' => array('logic-enable' => array('on'))),
			)
		);
		if ($this->options['mask-enable'] != 'on') {
			unset($this->element_properties_meta['text']['mask']);
		}
		$this->toolbar_tools = array(
			'text' => array(
				'title' => esc_html__('Text', 'leform'),
				'icon' => 'fas fa-pencil-alt',
				'type' => 'input'
			),
			'email' => array(
				'title' => esc_html__('Email', 'leform'),
				'icon' => 'far fa-envelope',
				'type' => 'input'
			),
			'textarea' => array(
				'title' => esc_html__('Textarea', 'leform'),
				'icon' => 'fas fa-align-left',
				'type' => 'input'
			),
			'select' => array(
				'title' => esc_html__('Select box', 'leform'),
				'icon' => 'far fa-caret-square-down',
				'type' => 'input'
			),
			'checkbox' => array(
				'title' => esc_html__('Checkbox', 'leform'),
				'icon' => 'far fa-check-square',
				'type' => 'input'
			),
			'radio' => array(
				'title' => esc_html__('Radio Button', 'leform'),
				'icon' => 'far fa-dot-circle',
				'type' => 'input'
			),
			'multiselect' => array(
				'title' => esc_html__('Multiselect', 'leform'),
				'icon' => 'fas fa-list-ul',
				'type' => 'input'
			),
			'imageselect' => array(
				'title' => esc_html__('Image Select', 'leform'),
				'icon' => 'far fa-images',
				'type' => 'input'
			),
			'date' => array(
				'title' => esc_html__('Date', 'leform'),
				'icon' => 'far fa-calendar-alt',
				'type' => 'input'
			),
			'time' => array(
				'title' => esc_html__('Time', 'leform'),
				'icon' => 'far fa-clock',
				'type' => 'input'
			),
			'file' => array(
				'title' => esc_html__('File upload', 'leform'),
				'icon' => 'fas fa-upload',
				'type' => 'input'
			),
			'password' => array(
				'title' => esc_html__('Password', 'leform'),
				'icon' => 'fas fa-lock',
				'type' => 'input'
			),
			'star-rating' => array(
				'title' => esc_html__('Star rating', 'leform'),
				'icon' => 'far fa-star',
				'type' => 'input'
			),
			'hidden' => array(
				'title' => esc_html__('Hidden field', 'leform'),
				'icon' => 'far fa-eye-slash',
				'type' => 'input'
			),
			'button' => array(
				'title' => esc_html__('Button', 'leform'),
				'icon' => 'far fa-paper-plane',
				'type' => 'submit'
			),
			'columns' => array(
				'title' => esc_html__('Column layout', 'leform'),
				'icon' => 'fas fa-columns',
				'options' => array(
					'2' => esc_html__('2 columns', 'leform'),
					'3' => esc_html__('3 columns', 'leform'),
					'4' => esc_html__('4 columns', 'leform'),
					'6' => esc_html__('6 columns', 'leform')
				),
				'type' => 'other'
			),
			'html' => array(
				'title' => esc_html__('HTML', 'leform'),
				'icon' => 'fas fa-code',
				'type' => 'other'
			),
			'link-button' => array(
				'title' => esc_html__('Link Button', 'leform'),
				'icon' => 'fas fa-link',
				'type' => 'other'
			),
		);
		$this->filters_meta = array(
			'alpha' => array(
				'label' => esc_html__('Alpha', 'leform'),
				'tooltip' => esc_html__('Removes any non-alphabet characters.', 'leform'),
				'properties' => array(
					'whitespace-allowed' => array('value' => 'off', 'label' => esc_html__('Allow whitespace', 'leform'), 'tooltip' => esc_html__('If checked, any spaces or tabs will not be stripped.', 'leform'), 'type' => 'checkbox')
				)
			),
			'alphanumeric' => array(
				'label' => esc_html__('Alphanumeric', 'leform'),
				'tooltip' => esc_html__('Removes any non-alphabet characters and non-digits.', 'leform'),
				'properties' => array(
					'whitespace-allowed' => array('value' => 'off', 'label' => esc_html__('Allow whitespace', 'leform'), 'tooltip' => esc_html__('If checked, any spaces or tabs will not be stripped.', 'leform'), 'type' => 'checkbox')
				)
			),
			'digits' => array(
				'label' => esc_html__('Digits', 'leform'),
				'tooltip' => esc_html__('Removes any non-digits.', 'leform'),
				'properties' => array(
					'whitespace-allowed' => array('value' => 'off', 'label' => esc_html__('Allow whitespace', 'leform'), 'tooltip' => esc_html__('If checked, any spaces or tabs will not be stripped.', 'leform'), 'type' => 'checkbox')
				)
			),
			'regex' => array(
				'label' => esc_html__('Regex', 'leform'),
				'tooltip' => esc_html__('Removes characters matching the given regular expression.', 'leform'),
				'properties' => array(
					'pattern' => array('value' => '', 'label' => esc_html__('Pattern', 'leform'), 'tooltip' => esc_html__('Any text matching this regular expression pattern will be stripped. The pattern should include start and end delimiters, see below for an example.', 'leform').'<br /><br /><code>/[^a-zA-Z0-9]/</code>', 'type' => 'text')
				)
			),
			'strip-tags' => array(
				'label' => esc_html__('Strip Tags', 'leform'),
				'tooltip' => esc_html__('Removes any HTML tags.', 'leform'),
				'properties' => array(
					'tags-allowed' => array('value' => '', 'label' => esc_html__('Allowable tags', 'leform'), 'tooltip' => esc_html__('Enter allowable tags, one after the other, see below for an example.', 'leform').'<br /><br /><code>&amp;lt;p&amp;gt;&amp;lt;a&amp;gt;&amp;lt;span&amp;gt;</code>', 'type' => 'text')
				)
			),
			'trim' => array(
				'label' => esc_html__('Trim', 'leform'),
				'tooltip' => esc_html__('Removes white space from the start and end.', 'leform')
			)
		);
		$this->validators_meta = array(
			'alpha' => array(
				'label' => esc_html__('Alpha', 'leform'),
				'tooltip' => esc_html__('Checks that the value contains only alphabet characters.', 'leform'),
				'properties' => array(
					'whitespace-allowed' => array('value' => 'off', 'label' => esc_html__('Allow whitespace', 'leform'), 'tooltip' => esc_html__('If checked, any spaces or tabs are allowed.', 'leform'), 'type' => 'checkbox'),
					'error' => array('value' => esc_html__('Only alphabet characters are allowed.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code>', 'type' => 'error')
				)
			),
			'alphanumeric' => array(
				'label' => esc_html__('Alphanumeric', 'leform'),
				'tooltip' => esc_html__('Checks that the value contains only alphabet characters or digits.', 'leform'),
				'properties' => array(
					'whitespace-allowed' => array('value' => 'off', 'label' => esc_html__('Allow whitespace', 'leform'), 'tooltip' => esc_html__('If checked, any spaces or tabs are allowed.', 'leform'), 'type' => 'checkbox'),
					'error' => array('value' => esc_html__('Only alphabet characters and digits are allowed.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code>', 'type' => 'error')
				)
			),
			'date' => array(
				'label' => esc_html__('Date', 'leform'),
				'tooltip' => esc_html__('Checks that the value is a valid date (according to pre-defined date format set on Form Settings).', 'leform'),
				'properties' => array(
					'error' => array('value' => esc_html__('Invalid date.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code>', 'type' => 'error')
				)
			),
			'digits' => array(
				'label' => esc_html__('Digits', 'leform'),
				'tooltip' => esc_html__('Checks that the value contains only digits.', 'leform'),
				'properties' => array(
					'whitespace-allowed' => array('value' => 'off', 'label' => esc_html__('Allow whitespace', 'leform'), 'tooltip' => esc_html__('If checked, any spaces or tabs are allowed.', 'leform'), 'type' => 'checkbox'),
					'error' => array('value' => esc_html__('Only digits are allowed.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code>', 'type' => 'error')
				)
			),
			'email' => array(
				'label' => esc_html__('Email', 'leform'),
				'tooltip' => esc_html__('Checks that the value is a valid email address.', 'leform'),
				'properties' => array(
					'error' => array('value' => esc_html__('Invalid email address.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code>', 'type' => 'error')
				)
			),
			'equal' => array(
				'label' => esc_html__('Equal', 'leform'),
				'tooltip' => esc_html__('Checks that the value is identical to the given token.', 'leform'),
				'properties' => array(
					'token' => array('value' => '', 'label' => esc_html__('Token', 'leform'), 'tooltip' => esc_html__('The token that the submitted value must be equal to.', 'leform'), 'type' => 'text'),
					'error' => array('value' => esc_html__('The value does not match {token}.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code><br /><code>{token} = '.esc_html__('the token', 'leform').'</code>', 'type' => 'error')
				)
			),
			'greater' => array(
				'label' => esc_html__('Greater Than', 'leform'),
				'tooltip' => esc_html__('Checks that the value is numerically greater than the given minimum.', 'leform'),
				'properties' => array(
					'min' => array('value' => '0', 'label' => esc_html__('Minimum', 'leform'), 'tooltip' => esc_html__('The submitted value must be numerically greater than the minimum.', 'leform'), 'type' => 'integer'),
					'error' => array('value' => esc_html__('The value is not greater than {min}.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code><br /><code>{min} = '.esc_html__('the minimum allowed value', 'leform').'</code>', 'type' => 'error')
				)
			),
			'in-array' => array(
				'label' => esc_html__('In Array', 'leform'),
				'tooltip' => esc_html__('Checks that the value is in a list of allowed values.', 'leform'),
				'properties' => array(
					'values' => array('value' => '', 'label' => esc_html__('Allowed values', 'leform'), 'tooltip' => esc_html__('Enter one allowed value per line.', 'leform'), 'type' => 'textarea'),
					'invert' => array('value' => 'off', 'label' => esc_html__('Invert', 'leform'), 'tooltip' => esc_html__('Invert the check i.e. the submitted value must not be in the allowed values list.', 'leform'), 'type' => 'checkbox'),
					'error' => array('value' => esc_html__('This value is not valid.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code>', 'type' => 'error')
				)
			),
			'length' => array(
				'label' => esc_html__('Length', 'leform'),
				'tooltip' => esc_html__('Checks that the length of the value is between the given maximum and minimum.', 'leform'),
				'properties' => array(
					'min' => array('value' => '0', 'label' => esc_html__('Minimum length', 'leform'), 'tooltip' => esc_html__('The length of the submitted value must be greater than or equal to the minimum.', 'leform'), 'type' => 'integer'),
					'max' => array('value' => '0', 'label' => esc_html__('Maximum length', 'leform'), 'tooltip' => esc_html__('The length of the submitted value must be less than or equal to the maximum.', 'leform'), 'type' => 'integer'),
					'error' => array('value' => esc_html__('The number of characters must be in a range [{min}..{max}].', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code><br /><code>{length} = '.esc_html__('the length of the submitted value', 'leform').'</code><br /><code>{min} = '.esc_html__('the minimum allowed length', 'leform').'</code><br /><code>{max} = '.esc_html__('the maximum allowed length', 'leform').'</code>', 'type' => 'error')
				)
			),
			'less' => array(
				'label' => esc_html__('Less Than', 'leform'),
				'tooltip' => esc_html__('Checks that the value is numerically less than the given maximum.', 'leform'),
				'properties' => array(
					'max' => array('value' => '0', 'label' => esc_html__('Maximum', 'leform'), 'tooltip' => esc_html__('The submitted value must be numerically less than the maximum.', 'leform'), 'type' => 'integer'),
					'error' => array('value' => esc_html__('The value is not less than {max}.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code><br /><code>{max} = '.esc_html__('the maximum allowed value', 'leform').'</code>', 'type' => 'error')
				)
			),
			'prevent-duplicates' => array(
				'label' => esc_html__('Prevent Duplicates', 'leform'),
				'tooltip' => esc_html__('Checks that the same value has not already been submitted.', 'leform'),
				'properties' => array(
					'error' => array('value' => esc_html__('This value is a duplicate of a previously submitted form.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code>', 'type' => 'error')
				)
			),
			'regex' => array(
				'label' => esc_html__('Regex', 'leform'),
				'tooltip' => esc_html__('Checks that the value matches the given regular expression.', 'leform'),
				'properties' => array(
					'pattern' => array('value' => '', 'label' => esc_html__('Pattern', 'leform'), 'tooltip' => esc_html__('The submitted value must match this regular expression. The pattern should include start and end delimiters, see below for an example.', 'leform').'<br /><br /><code>/[^a-zA-Z0-9]/</code>', 'type' => 'text'),
					'invert' => array('value' => 'off', 'label' => esc_html__('Invert', 'leform'), 'tooltip' => esc_html__('Invert the check i.e. the submitted value must not match the regular expression.', 'leform'), 'type' => 'checkbox'),
					'error' => array('value' => esc_html__('Invalid value.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code>', 'type' => 'error')
				)
			),
			'time' => array(
				'label' => esc_html__('Time', 'leform'),
				'tooltip' => esc_html__('Checks that the value is a valid time (according to pre-defined time format set on Form Settings).', 'leform'),
				'properties' => array(
					'error' => array('value' => esc_html__('Invalid time.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code>', 'type' => 'error')
				)
			),
			'url' => array(
				'label' => esc_html__('URL', 'leform'),
				'tooltip' => esc_html__('Checks that the value is a valid URL.', 'leform'),
				'properties' => array(
					'error' => array('value' => esc_html__('Invalid URL.', 'leform'), 'label' => esc_html__('Error message', 'leform'), 'tooltip' => esc_html__('Variables:', 'leform').'<br /><br /><code>{value} = '.esc_html__('the submitted value', 'leform').'</code>', 'type' => 'error')
				)
			),
		);
		$this->logic_rules = array(
			'is' => esc_html__('is', 'leform'),
			'is-not' => esc_html__('is not', 'leform'),
			'is-empty' => esc_html__('is empty', 'leform'),
			'is-not-empty' => esc_html__('is not empty', 'leform'),
			'is-greater' => esc_html__('is greater than', 'leform'),
			'is-less' => esc_html__('is less than', 'leform'),
			'contains' => esc_html__('contains', 'leform'),
			'starts-with' => esc_html__('starts with', 'leform'),
			'ends-with' => esc_html__('ends with', 'leform')
		);
		$this->confirmations_meta = array(
			'name' => array('value' => esc_html__('Confirmation', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name of the confirmation. It is used for your convenience.', 'leform'), 'type' => 'name'),
			'type' => array('value' => 'page', 'label' => esc_html__('Type', 'leform'), 'tooltip' => esc_html__('Choose the type of the confirmation.', 'leform'), 'type' => 'select', 'options' => array('page' => esc_html__('Display Confirmation page', 'leform'), 'page-redirect' => esc_html__('Display Confirmation page and redrect to certain URL', 'leform'), 'page-payment' => esc_html__('Display Confirmation page and request payment', 'leform'), 'message' => esc_html__('Display Message', 'leform'), 'message-redirect' => esc_html__('Display Message and redrect to certain URL', 'leform'), 'message-payment' => esc_html__('Display Message and request payment', 'leform'), 'redirect' => esc_html__('Redirect to certain URL', 'leform'), 'payment' => esc_html__('Request payment', 'leform'))),
			'payment-gateway' => array('value' => '', 'label' => esc_html__('Payment gateway', 'leform'), 'tooltip' => esc_html__('Select payment gateway. You can configure it on "Advanced" tab, "Payment Gateways" section.', 'leform'), 'type' => 'text'),
			'message' => array('value' => esc_html__('Thank you. We will contact you as soon as possible.', 'leform'), 'label' => esc_html__('Message', 'leform'), 'tooltip' => esc_html__('The message appears below the form after successful submission.', 'leform'), 'type' => 'text'),
			'url' => array('value' => get_bloginfo('url'), 'label' => esc_html__('URL', 'leform'), 'tooltip' => esc_html__('User will be redirected to this URL after successful form submission.', 'leform'), 'type' => 'text'),
			'delay' => array('value' => "3", 'label' => esc_html__('Delay', 'leform'), 'tooltip' => esc_html__('The message stay visible during this number of seconds.', 'leform'), 'type' => 'integer', 'unit' => esc_html__('seconds', 'leform')),
			'reset-form' => array('value' => 'on', 'label' => esc_html__('Reset form to default state', 'leform'), 'tooltip' => esc_html__('If enabled, the form will be reset to default state.', 'leform'), 'type' => 'checkbox'),
			'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to enable this confirmation depending on the values of input fields.', 'leform'), 'type' => 'checkbox'),
			'logic' => array('value' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Enable this confirmation', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show this confirmation depending on the values of input fields.', 'leform'), 'type' => 'logic-rules')
		);
		$this->notifications_meta = array(
			'name' => array('value' => esc_html__('Notification', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name of the notification. It is used for your convenience.', 'leform'), 'type' => 'name'),
			'enabled' => array('value' => 'on', 'label' => esc_html__('Enabled', 'leform'), 'tooltip' => esc_html__('You can stop this notification being sent by turning this off.', 'leform'), 'type' => 'checkbox'),
			'action' => array('value' => 'submit', 'label' => esc_html__('Send', 'leform'), 'tooltip' => esc_html__('You can specify when notification will be sent.', 'leform'), 'type' => 'select', 'options' => array('submit' => esc_html__('After successful form submission', 'leform'), 'confirm' => esc_html__('When user confirmed submitted data using native double opt-in feature', 'leform'), 'payment-success' => esc_html__('After successfully completed payment', 'leform'), 'payment-fail' => esc_html__('After non-completed payment', 'leform'))),
			'recipient-email' => array('value' => '', 'label' => esc_html__('Recipient', 'leform'), 'tooltip' => esc_html__('Add email addresses (comma-separated) to which this email will be sent to.', 'leform'), 'type' => 'text'),
			'subject' => array('value' => esc_html__('New submission from {{form-name}}', 'leform'), 'label' => esc_html__('Subject', 'leform'), 'tooltip' => esc_html__('The subject of the email message.', 'leform'), 'type' => 'text'),
			'message' => array('value' => '{{form-data}}', 'label' => esc_html__('Message', 'leform'), 'tooltip' => esc_html__('The content of the email message.', 'leform'), 'type' => 'html'),
			'attachments' => array('value' => array(), 'label' => esc_html__('Attachments', 'leform'), 'tooltip' => esc_html__('Select files that you want to attach to the email message.', 'leform'), 'type' => 'attachments'),
			'from' => array('value' => array('email' => '{{global-from-email}}', 'name' => '{{global-from-name}}'), 'label' => esc_html__('From', 'leform'), 'tooltip' => esc_html__('Sets the "From" address and name. The email address and name set here will be shown as the sender of the email.', 'leform'), 'type' => 'from'),
			'reply-email' => array('value' => '', 'label' => esc_html__('Reply-To', 'leform'), 'tooltip' => esc_html__('Add a "Reply-To" email address. If not set, replying to the email will reply to the "From" address.', 'leform'), 'type' => 'text'),
			'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to enable this notification depending on the values of input fields.', 'leform'), 'type' => 'checkbox'),
			'logic' => array('value' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Enable this notification', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to show this notification depending on the values of input fields.', 'leform'), 'type' => 'logic-rules')
		);
		$this->math_meta = array(
			'id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the expression.', 'leform'), 'type' => 'id'),
			'name' => array('value' => esc_html__('Expression', 'leform'), 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name of the expression. It is used for your convenience.', 'leform'), 'type' => 'name'),
			'expression' => array('value' => '', 'label' => esc_html__('Expression', 'leform'), 'tooltip' => esc_html__('Type math expression here. Use basic arithmetic operators:', 'leform').' <code>-, +, *, /</code>.', 'type' => 'text'),
			'default' => array('value' => '0', 'label' => esc_html__('Default', 'leform'), 'tooltip' => esc_html__('This value is used if expression can not be calculated (for example, in case of division by zero, typos, missed variables, non-numeric values, etc.).', 'leform'), 'type' => 'text'),
			'decimal-digits' => array('value' => "2", 'label' => esc_html__('Decimal digits', 'leform'), 'tooltip' => esc_html__('Specify how many decimal digits the result must have.', 'leform'), 'type' => 'integer')
		);
		$this->integrations_meta = array(
			'name' => array('value' => '', 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name of the integration. It is used for your convenience.', 'leform'), 'type' => 'name'),
			'enabled' => array('value' => 'on', 'label' => esc_html__('Enabled', 'leform'), 'tooltip' => esc_html__('You can disable this integration by turning this off.', 'leform'), 'type' => 'checkbox'),
			'action' => array('value' => 'submit', 'label' => esc_html__('Execute', 'leform'), 'tooltip' => esc_html__('You can specify when integration will be executed.', 'leform'), 'type' => 'select', 'options' => array('submit' => esc_html__('After successful form submission', 'leform'), 'confirm' => esc_html__('When user confirmed submitted data using native double opt-in feature', 'leform'), 'payment-success' => esc_html__('After successfully completed payment', 'leform'), 'payment-fail' => esc_html__('After non-completed payment', 'leform'))),
			'logic-enable' => array('value' => 'off', 'label' => esc_html__('Enable conditional logic', 'leform'), 'tooltip' => esc_html__('If enabled, you can create rules to enable this integration depending on the values of input fields.', 'leform'), 'type' => 'checkbox'),
			'logic' => array('value' => array('action' => 'show', 'operator' => 'and', 'rules' => array()), 'actions' => array('show' => esc_html__('Enable this integration', 'leform')), 'operators' => array('and' => esc_html__('if all of these rules match', 'leform'), 'or' => esc_html__('if any of these rules match', 'leform')), 'label' => esc_html__('Logic rules', 'leform'), 'tooltip' => esc_html__('Create rules to enable this integration depending on the values of input fields.', 'leform'), 'type' => 'logic-rules')
		);
		$this->payment_gateways_meta = array(
			'id' => array('value' => '', 'label' => esc_html__('ID', 'leform'), 'tooltip' => esc_html__('The unique ID of the payment gateway.', 'leform'), 'type' => 'id'),
			'name' => array('value' => '', 'label' => esc_html__('Name', 'leform'), 'tooltip' => esc_html__('The name of the payment gateway. It is used for your convenience.', 'leform'), 'type' => 'name')
		);
		if (!in_array('curl', get_loaded_extensions())) {
			$this->advanced_options = array_merge($this->advanced_options, array(
				'enable-htmlform' => 'off',
				'enable-activecampaign' => 'off',
				'enable-activetrail' => 'off',
				'enable-agilecrm' => 'off',
				'enable-avangemail' => 'off',
				'enable-aweber' => 'off',
				'enable-campaignmonitor' => 'off',
				'enable-conversio' => 'off',
				'enable-freshmail' => 'off',
				'enable-getresponse' => 'off',
				'enable-madmimi' => 'off',
				'enable-mailautic' => 'off',
				'enable-mailchimp' => 'off',
				'enable-mailerlite' => 'off',
				'enable-mailwizz' => 'off',
				'enable-mumara' => 'off',
				'enable-omnisend' => 'off',
				'enable-ontraport' => 'off',
				'enable-rapidmail' => 'off',
				'enable-zohocrm' => 'off',
				'enable-blockchain' => 'off',
				'enable-interkassa' => 'off',
				'enable-skrill' => 'off',
				'enable-paypal' => 'off',
				'enable-perfectmoney' => 'off',
				'enable-stripe' => 'off'
			));
		}
		if (file_exists(dirname(__FILE__).'/modules/customjs.php') && $this->advanced_options['enable-custom-js'] == 'on') include_once(dirname(__FILE__).'/modules/customjs.php');
		
		if (file_exists(dirname(__FILE__).'/modules/activecampaign.php') && $this->advanced_options['enable-activecampaign'] == 'on') include_once(dirname(__FILE__).'/modules/activecampaign.php');
		if (file_exists(dirname(__FILE__).'/modules/activetrail.php') && $this->advanced_options['enable-activetrail'] == 'on') include_once(dirname(__FILE__).'/modules/activetrail.php');
		if (file_exists(dirname(__FILE__).'/modules/agilecrm.php') && $this->advanced_options['enable-agilecrm'] == 'on') include_once(dirname(__FILE__).'/modules/agilecrm.php');
		if (file_exists(dirname(__FILE__).'/modules/avangemail.php') && $this->advanced_options['enable-avangemail'] == 'on') include_once(dirname(__FILE__).'/modules/avangemail.php');
		if (file_exists(dirname(__FILE__).'/modules/aweber.php') && $this->advanced_options['enable-aweber'] == 'on') include_once(dirname(__FILE__).'/modules/aweber.php');
		if (file_exists(dirname(__FILE__).'/modules/campaignmonitor.php') && $this->advanced_options['enable-campaignmonitor'] == 'on') include_once(dirname(__FILE__).'/modules/campaignmonitor.php');
		if (file_exists(dirname(__FILE__).'/modules/conversio.php') && $this->advanced_options['enable-conversio'] == 'on') include_once(dirname(__FILE__).'/modules/conversio.php');
		if (file_exists(dirname(__FILE__).'/modules/freshmail.php') && $this->advanced_options['enable-freshmail'] == 'on') include_once(dirname(__FILE__).'/modules/freshmail.php');
		if (file_exists(dirname(__FILE__).'/modules/getresponse.php') && $this->advanced_options['enable-getresponse'] == 'on') include_once(dirname(__FILE__).'/modules/getresponse.php');
		if (!defined('UAP_CORE')) {
			if (file_exists(dirname(__FILE__).'/modules/jetpack.php') && $this->advanced_options['enable-jetpack'] == 'on') include_once(dirname(__FILE__).'/modules/jetpack.php');
		}
		if (file_exists(dirname(__FILE__).'/modules/madmimi.php') && $this->advanced_options['enable-madmimi'] == 'on') include_once(dirname(__FILE__).'/modules/madmimi.php');
		if (file_exists(dirname(__FILE__).'/modules/mailautic.php') && $this->advanced_options['enable-mailautic'] == 'on') include_once(dirname(__FILE__).'/modules/mailautic.php');
		if (file_exists(dirname(__FILE__).'/modules/mailchimp.php') && $this->advanced_options['enable-mailchimp'] == 'on') include_once(dirname(__FILE__).'/modules/mailchimp.php');
		if (file_exists(dirname(__FILE__).'/modules/mailerlite.php') && $this->advanced_options['enable-mailerlite'] == 'on') include_once(dirname(__FILE__).'/modules/mailerlite.php');
		if (!defined('UAP_CORE')) {
			if (file_exists(dirname(__FILE__).'/modules/mailpoet.php') && $this->advanced_options['enable-mailpoet'] == 'on') include_once(dirname(__FILE__).'/modules/mailpoet.php');
			if (file_exists(dirname(__FILE__).'/modules/mailster.php') && $this->advanced_options['enable-mailster'] == 'on') include_once(dirname(__FILE__).'/modules/mailster.php');
		}
		if (file_exists(dirname(__FILE__).'/modules/mailwizz.php') && $this->advanced_options['enable-mailwizz'] == 'on') include_once(dirname(__FILE__).'/modules/mailwizz.php');
		if (file_exists(dirname(__FILE__).'/modules/mumara.php') && $this->advanced_options['enable-mumara'] == 'on') include_once(dirname(__FILE__).'/modules/mumara.php');
		if (file_exists(dirname(__FILE__).'/modules/omnisend.php') && $this->advanced_options['enable-omnisend'] == 'on') include_once(dirname(__FILE__).'/modules/omnisend.php');
		if (file_exists(dirname(__FILE__).'/modules/ontraport.php') && $this->advanced_options['enable-ontraport'] == 'on') include_once(dirname(__FILE__).'/modules/ontraport.php');
		if (file_exists(dirname(__FILE__).'/modules/rapidmail.php') && $this->advanced_options['enable-rapidmail'] == 'on') include_once(dirname(__FILE__).'/modules/rapidmail.php');
		if (file_exists(dirname(__FILE__).'/modules/zohocrm.php') && $this->advanced_options['enable-zohocrm'] == 'on') include_once(dirname(__FILE__).'/modules/zohocrm.php');
		if (file_exists(dirname(__FILE__).'/modules/htmlform.php') && $this->advanced_options['enable-htmlform'] == 'on') include_once(dirname(__FILE__).'/modules/htmlform.php');

		if (file_exists(dirname(__FILE__).'/modules/blockchain.php') && $this->advanced_options['enable-blockchain'] == 'on') include_once(dirname(__FILE__).'/modules/blockchain.php');
		if (file_exists(dirname(__FILE__).'/modules/interkassa.php') && $this->advanced_options['enable-interkassa'] == 'on') include_once(dirname(__FILE__).'/modules/interkassa.php');
		if (file_exists(dirname(__FILE__).'/modules/paypal.php') && $this->advanced_options['enable-paypal'] == 'on') include_once(dirname(__FILE__).'/modules/paypal.php');
		if (file_exists(dirname(__FILE__).'/modules/perfectmoney.php') && $this->advanced_options['enable-perfectmoney'] == 'on') include_once(dirname(__FILE__).'/modules/perfectmoney.php');
		if (file_exists(dirname(__FILE__).'/modules/skrill.php') && $this->advanced_options['enable-skrill'] == 'on') include_once(dirname(__FILE__).'/modules/skrill.php');
		if (file_exists(dirname(__FILE__).'/modules/stripe.php') && $this->advanced_options['enable-stripe'] == 'on') include_once(dirname(__FILE__).'/modules/stripe.php');
		
		$this->element_properties_meta = apply_filters("leform_element_properties_meta", $this->element_properties_meta);
		
		add_action('init', array(&$this, 'handle_demo_mode'));
		add_action('init', array(&$this, 'register_session'));
		if (function_exists('register_block_type')) {
			add_action('init', array(&$this, 'register_block'));
		}
		add_action('widgets_init', array(&$this, 'widgets_init'));
		if (defined('DOING_AJAX') && DOING_AJAX) {
			include_once(dirname(__FILE__).'/modules/core-ajax.php');
			$leform_ajax = new leform_ajax_class();
		} else if (is_admin()) {
			add_action('wpmu_new_blog', array(&$this, 'install_new_blog'), 10, 6);
			add_action('delete_blog', array(&$this, 'uninstall_blog'), 10, 2);
			include_once(dirname(__FILE__).'/modules/core-admin.php');
			$leform_admin = new leform_admin_class();
		} else {
			include_once(dirname(__FILE__).'/modules/core-front.php');
			$leform_front = new leform_front_class();
		}
	}

	static function install($_networkwide = null) {
		global $wpdb;
		if (function_exists('is_multisite') && is_multisite()) {
			if ($_networkwide) {
				$old_blog = $wpdb->blogid;
				$blog_ids = $wpdb->get_col('SELECT blog_id FROM '.esc_sql($wpdb->blogs));
				foreach ($blog_ids as $blog_id) {
					switch_to_blog($blog_id);
					self::activate();
				}
				switch_to_blog($old_blog);
				return;
			}
		}
		self::activate();
	}

	function install_new_blog($_blog_id, $_user_id, $_domain, $_path, $_site_id, $_meta) {
		if (is_plugin_active_for_network(basename(dirname(__FILE__)).'/' ).basename(__FILE__)) {
			switch_to_blog($_blog_id);
			self::activate();
			restore_current_blog();
		}
	}
	
	static function activate() {
		global $wpdb;
		$add_default = false;
		$webfont_version = get_option('leform-webfonts-version', 0);
		$table_name = $wpdb->prefix."leform_forms";
		if($wpdb->get_var("SHOW TABLES LIKE '".esc_sql($table_name)."'") != $table_name) {
			$sql = "CREATE TABLE ".esc_sql($table_name)." (
				id int(11) NOT NULL auto_increment,
				name varchar(255) collate utf8_unicode_ci NULL,
				options longtext collate utf8_unicode_ci NULL,
				pages longtext collate utf8_unicode_ci NULL,
				elements longtext collate utf8_unicode_ci NULL,
				cache_style longtext collate utf8_unicode_ci NULL,
				cache_html longtext collate utf8_unicode_ci NULL,
				cache_uids longtext collate utf8_unicode_ci NULL,
				cache_time int(11) NULL default '0',
				active int(11) NULL default '1',
				created int(11) NULL,
				modified int(11) NULL,
				deleted int(11) NULL default '0',
				UNIQUE KEY  id (id)
			);";
			$wpdb->query($sql);
			$add_default = true;
		}
		$table_name = $wpdb->prefix."leform_previews";
		if($wpdb->get_var("SHOW TABLES LIKE '".esc_sql($table_name)."'") != $table_name) {
			$sql = "CREATE TABLE ".esc_sql($table_name)." (
				id int(11) NOT NULL auto_increment,
				form_id int(11) NULL default '0',
				name varchar(255) collate utf8_unicode_ci NULL,
				options longtext collate utf8_unicode_ci NULL,
				pages longtext collate utf8_unicode_ci NULL,
				elements longtext collate utf8_unicode_ci NULL,
				created int(11) NULL,
				deleted int(11) NULL default '0',
				UNIQUE KEY  id (id)
			);";
			$wpdb->query($sql);
		}
		$table_name = $wpdb->prefix."leform_records";
		if($wpdb->get_var("SHOW TABLES LIKE '".esc_sql($table_name)."'") != $table_name) {
			$sql = "CREATE TABLE ".esc_sql($table_name)." (
				id int(11) NOT NULL auto_increment,
				form_id int(11) NULL,
				personal_data_keys longtext collate utf8_unicode_ci NULL,
				unique_keys longtext collate utf8_unicode_ci NULL,
				fields longtext collate utf8_unicode_ci NULL,
				info longtext collate utf8_unicode_ci NULL,
				status int(11) NULL default '0',
				str_id varchar(31) collate latin1_general_cs NULL,
				gateway_id int(11) NULL,
				amount float NULL,
				currency varchar(7) COLLATE utf8_unicode_ci NULL,
				created int(11) NULL,
				deleted int(11) NULL default '0',
				UNIQUE KEY  id (id)
			);";
			$wpdb->query($sql);
		}
		$table_name = $wpdb->prefix."leform_fieldvalues";
		if($wpdb->get_var("SHOW TABLES LIKE '".esc_sql($table_name)."'") != $table_name) {
			$sql = "CREATE TABLE ".esc_sql($table_name)." (
				id int(11) NOT NULL auto_increment,
				form_id int(11) NULL,
				record_id int(11) NULL,
				field_id int(11) NULL,
				value longtext collate utf8_unicode_ci NULL,
				datestamp int(11) NULL,
				deleted int(11) NULL default '0',
				UNIQUE KEY  id (id)
			);";
			$wpdb->query($sql);
		}
		$table_name = $wpdb->prefix."leform_transactions";
		if($wpdb->get_var("SHOW TABLES LIKE '".esc_sql($table_name)."'") != $table_name) {
			$sql = "CREATE TABLE ".esc_sql($table_name)." (
				id int(11) NULL AUTO_INCREMENT,
				record_id int(11) NULL,
				provider varchar(63) COLLATE utf8_unicode_ci NULL,
				payer_name varchar(255) COLLATE utf8_unicode_ci NULL,
				payer_email varchar(255) COLLATE utf8_unicode_ci NULL,
				gross float NULL,
				currency varchar(15) COLLATE utf8_unicode_ci NULL,
				payment_status varchar(63) COLLATE utf8_unicode_ci NULL,
				transaction_type varchar(63) COLLATE utf8_unicode_ci NULL,
				txn_id varchar(255) COLLATE utf8_unicode_ci NULL,
				details text COLLATE utf8_unicode_ci NULL,
				created int(11) NULL,
				deleted int(11) NULL DEFAULT '0',
				UNIQUE KEY id (id)
			);";
			$wpdb->query($sql);
		}
		$table_name = $wpdb->prefix."leform_uploads";
		if($wpdb->get_var("SHOW TABLES LIKE '".esc_sql($table_name)."'") != $table_name) {
			$sql = "CREATE TABLE ".esc_sql($table_name)." (
				id int(11) NOT NULL auto_increment,
				record_id int(11) NULL,
				form_id int(11) NULL,
				element_id int(11) NULL,
				upload_id varchar(63) collate latin1_general_cs NULL,
				str_id varchar(63) collate latin1_general_cs NULL,
				status int(11) NULL,
				message longtext collate utf8_unicode_ci NULL,
				filename varchar(255) collate utf8_unicode_ci NULL,
				filename_original varchar(255) collate utf8_unicode_ci NULL,
				created int(11) NULL,
				deleted int(11) NULL default '0',
				UNIQUE KEY  id (id)
			);";
			$wpdb->query($sql);
		}
		$table_name = $wpdb->prefix."leform_stats";
		if($wpdb->get_var("SHOW TABLES LIKE '".esc_sql($table_name)."'") != $table_name) {
			$sql = "CREATE TABLE ".esc_sql($table_name)." (
				id int(11) NOT NULL auto_increment,
				form_id int(11) NULL,
				impressions int(11) NULL default '0',
				submits int(11) NULL default '0',
				confirmed int(11) NULL default '0',
				payments int(11) NULL default '0',
				datestamp int(11) NULL,
				timestamp int(11) NULL,
				deleted int(11) NULL default '0',
				UNIQUE KEY  id (id)
			);";
			$wpdb->query($sql);
		}
		$table_name = $wpdb->prefix."leform_webfonts";
		if($wpdb->get_var("SHOW TABLES LIKE '".esc_sql($table_name)."'") != $table_name) {
			$sql = "CREATE TABLE ".esc_sql($table_name)." (
				id int(11) NOT NULL auto_increment,
				family varchar(255) collate utf8_unicode_ci NULL,
				variants varchar(255) collate utf8_unicode_ci NULL,
				subsets varchar(255) collate utf8_unicode_ci NULL,
				source varchar(31) collate latin1_general_cs NULL,
				deleted int(11) NULL default '0',
				UNIQUE KEY  id (id)
			);";
			$wpdb->query($sql);
			$webfont_version = 0;
		}
		if ($webfont_version < LEFORM_WEBFONTS_VERSION) {
			include(dirname(__FILE__).'/webfonts.php');
			$webfonts_array = json_decode($fonts, true);
			if (is_array($webfonts_array['items'])) {
				$sql = "DELETE FROM ".$wpdb->prefix."leform_webfonts";
				$wpdb->query($sql);
				$values = array();
				foreach($webfonts_array['items'] as $fontvars) {
					if (!empty($fontvars['family'])) {
						$variants = '';
						if (!empty($fontvars['variants']) && is_array($fontvars['variants'])) {
							foreach ($fontvars['variants'] as $key => $var) {
									if ($var == 'regular') $fontvars['variants'][$key] = '400';
									if ($var == 'italic') $fontvars['variants'][$key] = '400italic';
							}
							$variants = implode(",", $fontvars['variants']);
						}
						$subsets = '';
						if (!empty($fontvars['subsets']) && is_array($fontvars['subsets'])) {
							$subsets = implode(",", $fontvars['subsets']);
						}
						$values[] = "('".esc_sql($fontvars['family'])."', '".esc_sql($variants)."', '".esc_sql($subsets)."', 'google', '0')";
						if (sizeof($values) > 9) {
							$sql = "INSERT INTO ".$wpdb->prefix."leform_webfonts (family, variants, subsets, source, deleted) 
									VALUES ".implode(', ', $values);
							$wpdb->query($sql);
							$values = array();
						}
					}
				}
				if (sizeof($values) > 0) {
					$sql = "INSERT INTO ".$wpdb->prefix."leform_webfonts (family, variants, subsets, source, deleted) 
							VALUES ".implode(', ', $values);
					$wpdb->query($sql);
				}
			}
			update_option('leform-webfonts-version', LEFORM_WEBFONTS_VERSION);
		}
		update_option('leform-version', LEFORM_VERSION);
		update_option('leform-update-time', time());
		$upload_dir = wp_upload_dir();
		wp_mkdir_p($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR);
		wp_mkdir_p($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads');
		wp_mkdir_p($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/temp');
		if (file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR) && !file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/index.html')) {
			file_put_contents($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/index.html', 'Silence is the gold!');
		}
		if (file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads') && !file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/index.html')) {
			file_put_contents($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/index.html', 'Silence is the gold!');
		}
		if (file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads') && !file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/.htaccess')) {
			file_put_contents($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/.htaccess', 'deny from all');
		}
		if ($add_default) {
			
		}
	}

	static function uninstall() {
		global $wpdb;
		if (function_exists('is_multisite') && is_multisite()) {
			$old_blog = $wpdb->blogid;
			$blog_ids = $wpdb->get_col('SELECT blog_id FROM '.esc_sql($wpdb->blogs));
			foreach ($blog_ids as $blog_id) {
				switch_to_blog($blog_id);
				self::deactivate(false);
			}
			switch_to_blog($old_blog);
		} else {
			self::deactivate(false);
		}
	}

	function uninstall_blog($_blog_id, $_drop) {
		if (is_plugin_active_for_network(basename(dirname(__FILE__)).'/'.basename(__FILE__)) && $_drop) {
			switch_to_blog($_blog_id);
			self::deactivate(true);
			restore_current_blog();
		}
	}
	
	static function deactivate($_force_delete = false) {
		global $wpdb;
		$clean_database = get_option('leform_ext_clean_database', 'off');
		if ($clean_database == 'on' || $_force_delete) {
			$sql = "DELETE FROM ".$wpdb->prefix."options WHERE option_name LIKE 'leform_%' AND option_name != 'leform_ext_clean_database'";
			$wpdb->query($sql);
			$sql = "DROP TABLE IF EXISTS ".$wpdb->prefix."leform_forms";
			$wpdb->query($sql);
			$sql = "DROP TABLE IF EXISTS ".$wpdb->prefix."leform_webfonts";
			$wpdb->query($sql);
		}
	}

	function get_advanced_options() {
		foreach ($this->advanced_options as $key => $value) {
			$this->advanced_options[$key] = get_option('leform-advanced-'.$key, $this->advanced_options[$key]);
		}
	}

	function update_advanced_options() {
		if (current_user_can('manage_options')) {
			foreach ($this->advanced_options as $key => $value) {
				update_option('leform-advanced-'.$key, $value);
			}
			update_option('leform-update-time', time());
		}
	}

	function populate_advanced_options() {
		foreach ($this->advanced_options as $key => $value) {
			if (isset($_POST['leform-advanced-'.$key])) {
				$this->advanced_options[$key] = trim(stripslashes($_POST['leform-advanced-'.$key]));
			}
		}
	}
	
	function get_options() {
		$exists = get_option('leform-version');
		if ($exists) {
			foreach ($this->options as $key => $value) {
				$this->options[$key] = get_option('leform-'.$key, $this->options[$key]);
			}
		}
	}

	function update_options() {
		if (current_user_can('manage_options')) {
			$this->options['update-time'] = time();
			foreach ($this->options as $key => $value) {
				update_option('leform-'.$key, $value);
			}
		}
	}

	function populate_options() {
		foreach ($this->options as $key => $value) {
			if (isset($_POST['leform-'.$key])) {
				$this->options[$key] = trim(stripslashes($_POST['leform-'.$key]));
			}
		}
	}

	function register_block() {
		wp_register_script('leform-form', plugins_url('js/block.js', __FILE__), array('wp-blocks', 'wp-element', 'wp-i18n'));
		register_block_type('leform/form', array('editor_script' => 'leform-form'));
	}
	
	function shortcode_handler($_atts) {
		include_once(dirname(__FILE__).'/modules/core-front.php');
		$leform_front = new leform_front_class();
		$html = $leform_front->shortcode_handler($_atts);
		return $html;
	}
	
	function default_form_options($_type = 'settings') {
		$form_options = array();
		if (!array_key_exists($_type, $this->element_properties_meta)) return array();
		foreach ($this->element_properties_meta[$_type] as $key => $value) {
			if (array_key_exists('value', $value)) {
				if (is_array($value['value'])) {
					foreach ($value['value'] as $option_key => $option_value) {
						$form_options[$key.'-'.$option_key] = $option_value;
					}
				} else $form_options[$key] = $value['value'];
			} else if (array_key_exists('values', $value)) $form_options[$key] = $value['values'];
		}
		return $form_options;
	}
	
	function get_info_label($_key) {
		$label = '-';
		if ($_key == 'ip') $label = esc_html__('IP Address', 'leform');
		else if ($_key == 'url') $label = esc_html__('Form URL', 'leform');
		else if ($_key == 'user-agent') $label = esc_html__('User Agent', 'leform');
		else if ($_key == 'wp-user-login') $label = esc_html__('WP User Login', 'leform');
		else if ($_key == 'wp-user-email') $label = esc_html__('WP User Email', 'leform');
		return $label;
	}
	
	function stats_array($_form_id, $_start_date, $_end_date) {
		global $wpdb;
		$current_date = $_start_date;
		$sql_start_date = $_start_date->format("Ymd");
		$output = array();
		do {
			$key_date = $current_date->format("Ymd");
			$output[$key_date] = array(
				'impressions' => 0,
				'submits' => 0,
				'confirmed' => 0,
				'payments' => 0,
				'label' => $current_date->format("Y-m-d")
			);
			$current_date->modify('+1 day');
		} while ($current_date <= $_end_date);
		$stats = $wpdb->get_results("SELECT SUM(impressions) AS impressions, SUM(submits) AS submits, SUM(confirmed) AS confirmed, SUM(payments) AS payments, datestamp FROM ".$wpdb->prefix."leform_stats WHERE deleted = '0' AND datestamp >= '".esc_sql($sql_start_date)."' AND datestamp <= '".esc_sql($_end_date->format("Ymd"))."'".(!empty($_form_id) ? " AND form_id = '".esc_sql(intval($_form_id))."'" : "")." GROUP BY datestamp", ARRAY_A);
		foreach($stats as $stat_record) {
			if (array_key_exists($stat_record['datestamp'], $output)) {
				$output[$stat_record['datestamp']]['impressions'] = $stat_record['impressions'];
				$output[$stat_record['datestamp']]['submits'] = $stat_record['submits'];
				$output[$stat_record['datestamp']]['confirmed'] = $stat_record['confirmed'];
				$output[$stat_record['datestamp']]['payments'] = $stat_record['payments'];
			}
		}
		return $output;
	}

	function export($_form_id) {
		global $wpdb;
		if (!class_exists("leform_form")) include_once(dirname(__FILE__).'/modules/core-form.php');
		$form_object = new leform_form($_form_id);
		$form_full = array();
		if (!empty($form_object->id)) {
			$upload_dir = wp_upload_dir();
			if (!class_exists('ZipArchive') || !class_exists('DOMDocument') || !file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/temp')) {
				$form_full['name'] = $form_object->name;
				$form_full['options'] = $form_object->form_options;
				$form_full['pages'] = $form_object->form_pages;
				$form_full['elements'] = $form_object->form_elements;
				$form_data = json_encode($form_full);
				$output = LEFORM_EXPORT_VERSION.PHP_EOL.md5($form_data).PHP_EOL.base64_encode($form_data);
				if (strstr($_SERVER["HTTP_USER_AGENT"],"MSIE")) {
					header("Pragma: public");
					header("Expires: 0");
					header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
					header("Content-type: application-download");
					header("Content-Length: ".strlen($output));
					header('Content-Disposition: attachment; filename="form-'.$form_object->id.'.txt"');
					header("Content-Transfer-Encoding: binary");
				} else {
					header("Content-type: application-download");
					header("Content-Length: ".strlen($output));
					header('Content-Disposition: attachment; filename="form-'.$form_object->id.'.txt"');
				}
				echo $output;
				flush();
				ob_flush();
				exit;
			} else {
				if (!defined('UAP_CORE')) {
					require_once(ABSPATH.'wp-admin/includes/file.php');
				}
				$zip = new ZipArchive();
				$zip_filename = $upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/temp/'.$this->random_string(16).'.zip';
				if ($zip->open($zip_filename, ZipArchive::CREATE) !== true) {
					$this->error_message = esc_html__('No records selected.', 'leform');
					return;
				}
				$images_processed = array();
				
				foreach ($this->element_properties_meta['settings'] as $key => $element) {
					if (array_key_exists('type', $element) && $element['type'] == 'background-style') {
						if (array_key_exists($key.'-image', $form_object->form_options)) {
							if (!empty($form_object->form_options[$key.'-image']) && preg_match('~^((http(s)?://)|(//))[a-z0-9-]+(.[a-z0-9-]+)*(:[0-9]+)?(/.*)?$~i', $form_object->form_options[$key.'-image'])) {
								$filename = $this->_add_to_archive($zip, $form_object->form_options[$key.'-image'], $images_processed);
								if ($filename !== false) {
									$form_object->form_options[$key.'-image'] = 'LEFORM-FORM-DIR/'.$filename;
								}
							}
						}
					}
				}
				if (array_key_exists('confirmations', $form_object->form_options) && !empty($form_object->form_options['confirmations'])) {
					foreach ($form_object->form_options['confirmations'] as $key => $confirmation) {
						$form_object->form_options['confirmations'][$key]['message'] = $this->_process_images_in_html($confirmation['message'], $zip, $images_processed);
					}
				}
				if (array_key_exists('double-email-message', $form_object->form_options) && !empty($form_object->form_options['double-email-message'])) {
					$form_object->form_options['double-email-message'] = $this->_process_images_in_html($form_object->form_options['double-email-message'], $zip, $images_processed);
				}
				if (array_key_exists('double-message', $form_object->form_options) && !empty($form_object->form_options['double-message'])) {
					$form_object->form_options['double-message'] = $this->_process_images_in_html($form_object->form_options['double-message'], $zip, $images_processed);
				}
				if (array_key_exists('notifications', $form_object->form_options) && !empty($form_object->form_options['notifications'])) {
					foreach ($form_object->form_options['notifications'] as $key => $notification) {
						$form_object->form_options['notifications'][$key]['message'] = $this->_process_images_in_html($notification['message'], $zip, $images_processed);
					}
				}
				foreach ($form_object->form_elements as $key => $element) {
					if ($element['type'] == 'html') {
						$form_object->form_elements[$key]['content'] = $this->_process_images_in_html($form_object->form_elements[$key]['content'], $zip, $images_processed);
					} else if ($element['type'] == 'imageselect') {
						foreach($element['options'] as $option_key => $option) {
							if (!empty($option['image'])) {
								$filename = $this->_add_to_archive($zip, $option['image'], $images_processed);
								if ($filename !== false) {
									$form_object->form_elements[$key]['options'][$option_key]['image'] = 'LEFORM-FORM-DIR/'.$filename;
								}
							}
						}
					}
				}

				$form_full['name'] = $form_object->name;
				$form_full['options'] = $form_object->form_options;
				$form_full['pages'] = $form_object->form_pages;
				$form_full['elements'] = $form_object->form_elements;
				
				$form_data = json_encode($form_full);
				$zip->addFromString('form.txt', LEFORM_EXPORT_VERSION.PHP_EOL.md5($form_data).PHP_EOL.base64_encode($form_data));
				$zip->addFromString('index.html', 'Get your copy of <a href="https://greenforms.pro/">Green Forms</a>.');
				$zip->close();
				error_reporting(0);
				$length = filesize($zip_filename);
				if (strstr($_SERVER["HTTP_USER_AGENT"], "MSIE")) {
					header("Pragma: public");
					header("Expires: 0");
					header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
					header("Content-Type: application-download");
					header("Content-Length: ".$length);
					header('Content-Disposition: attachment; filename="form-'.$form_object->id.'.zip"');
					header("Content-Transfer-Encoding: binary");
				} else {
					header("Content-Type: application-download");
					header("Content-Length: ".$length);
					header('Content-Disposition: attachment; filename="form-'.$form_object->id.'.zip"');
				}
				$handle_read = fopen($zip_filename, "rb");
				while (!feof($handle_read) && $length > 0) {
					$content = fread($handle_read, 1024);
					echo substr($content, 0, min($length, 1024));
					flush();
					$length = $length - strlen($content);
					if ($length < 0) $length = 0;
				}
				fclose($handle_read);
				unlink($zip_filename);
				foreach ($images_processed as $value) {
					if (!empty($value['temp']) && file_exists($value['temp']) && is_file($value['temp'])) unlink($value['temp']);
				}
				exit;
			}
		}
		return false;
	}

	function _process_images_in_html($_html, &$_zip, &$_images_processed) {
		global $wpdb;
		if (function_exists('libxml_use_internal_errors')) libxml_use_internal_errors(true);
		if (!empty($_html)) {
			$dom = new DOMDocument();
			$dom->loadHTML($_html);
			if (!$dom) return $_html;
			
			$imgs = $dom->getElementsByTagName('img');
			foreach ($imgs as $img) {
				$img_string = $img->getAttribute('src');
				if (!empty($img_string) && preg_match('~^((http(s)?://)|(//))[a-z0-9-]+(.[a-z0-9-]+)*(:[0-9]+)?(/.*)?$~i', $img_string)) {
					$filename = $this->_add_to_archive($_zip, $img_string, $_images_processed);
					if ($filename !== false) {
						$_html = str_replace($img_string, 'LEFORM-FORM-DIR/'.$filename, $_html);
					}
				}
			}								
		}
		return $_html;
	}
	
	function _add_to_archive(&$_zip, $_image_url, &$_images_processed) {
		global $wpdb;
		if (substr($_image_url, 0, 2) == '//') $_image_url = 'http:'.$_image_url;
		if (strtolower(substr($_image_url, 0, 8)) == 'https://') $processed_key = substr($_image_url, 8);
		else $processed_key = substr($_image_url, 7);
		if (strtolower(substr($processed_key, 0, 4)) == 'www.') $processed_key = substr($processed_key, 4);
		if (array_key_exists($processed_key, $_images_processed)) {
			return $_images_processed[$processed_key]['image'];
		}
		$filename = 'img-'.sizeof($_images_processed);
		$mime_types = array(
			'image/png' => 'png',
			'image/jpeg' => 'jpg',
			'image/gif' => 'gif',
			'image/bmp' => 'bmp',
			'image/vnd.microsoft.icon' => 'ico',
			'image/tiff' => 'tiff',
			'image/svg+xml' => 'svg',
			'image/svg+xml' => 'svgz'
		);
		$download_file = download_url($_image_url);
		if (is_wp_error($download_file)) {
			return false;
		}
		$path = parse_url($_image_url, PHP_URL_PATH);
		$check_image = true;
		if ($path !== false && strlen($path) > 4) {
			$ext = strtolower(substr($path, strlen($path)-4));
			if ($ext == '.svg') {
				$filename .= '.svg';
				$check_image = false;
			}
		}
		if ($check_image) {
			$img_data = getimagesize($download_file);
			if (is_array($img_data) && array_key_exists('mime', $img_data)) {
				if (array_key_exists($img_data['mime'], $mime_types)) {
					$filename .= '.'.$mime_types[$img_data['mime']];
				}
			}
		}
		if ($_zip->addFile($download_file, $filename)) {
			$_images_processed[$processed_key] = array(
				'image' => $filename,
				'temp' => $download_file
			);
			return $filename;
		}
		unlink($download_file);
		return false;
	}
	
	function page_switcher ($_urlbase, $_currentpage, $_totalpages) {
		$pageswitcher = "";
		if ($_totalpages > 1) {
			$pageswitcher = '<div class="leform-table-list-pages"><span>';
			if (strpos($_urlbase, "?") !== false) $_urlbase .= "&";
			else $_urlbase .= "?";
			if ($_currentpage == 1) $pageswitcher .= "<a href='#' class='leform-table-list-page-active' onclick='return false'>1</a> ";
			else $pageswitcher .= " <a href='".$_urlbase."p=1'>1</a> ";

			$start = max($_currentpage-3, 2);
			$end = min(max($_currentpage+3,$start+6), $_totalpages-1);
			$start = max(min($start,$end-6), 2);
			if ($start > 2) $pageswitcher .= " <strong>...</strong> ";
			for ($i=$start; $i<=$end; $i++) {
				if ($_currentpage == $i) $pageswitcher .= " <a href='#' class='leform-table-list-page-active' onclick='return false'>".$i."</a> ";
				else $pageswitcher .= " <a href='".$_urlbase."p=".$i."'>".$i."</a> ";
			}
			if ($end < $_totalpages-1) $pageswitcher .= " <strong>...</strong> ";

			if ($_currentpage == $_totalpages) $pageswitcher .= " <a href='#' class='leform-table-list-page-active' onclick='return false'>".$_totalpages."</a> ";
			else $pageswitcher .= " <a href='".$_urlbase."p=".$_totalpages."'>".$_totalpages."</a> ";
			$pageswitcher .= "</span></div>";
		}
		return $pageswitcher;
	}

	function datetime_string($_datetime) {
		$dt = (string)$_datetime;
		if (strlen($dt) != 12) return '';
		return substr($dt, 0, 4).'-'.substr($dt, 4, 2).'-'.substr($dt, 6, 2).' '.substr($dt, 8, 2).':'.substr($dt, 10, 2);
	}

	function validate_date($_date, $_format = 'Y-m-d') {
		$replacements = array(
			'yyyy-mm-dd' => 'Y-m-d',
			'dd/mm/yyyy' => 'd/m/Y',
			'mm/dd/yyyy' => 'm/d/Y',
			'dd.mm.yyyy' => 'd.m.Y'
		);
		if (array_key_exists($_format, $replacements)) $_format = $replacements[$_format];
		$date = DateTime::createFromFormat($_format, $_date);
		if ($date && $date->format($_format) === $_date) return $date;
		return false;
	}

	function validate_time($_time, $_format = 'H:i') {
		$replacements = array(
			'hh:ii' => 'H:i',
			'hh:ii aa' => 'h:i a'
		);
		if (array_key_exists($_format, $replacements)) $_format = $replacements[$_format];
		$time = DateTime::createFromFormat('Y-m-d '.$_format, '2020-01-01 '.$_time);
		if ($time && $time->format($_format) === $_time) return $time;
		return false;
	}

	function get_rgb($_color) {
		if (strlen($_color) != 7 && strlen($_color) != 4) return false;
		$color = preg_replace('/[^#a-fA-F0-9]/', '', $_color);
		if (strlen($color) != strlen($_color)) return false;
		if (strlen($color) == 7) list($r, $g, $b) = array($color[1].$color[2], $color[3].$color[4], $color[5].$color[6]);
		else list($r, $g, $b) = array($color[1].$color[1], $color[2].$color[2], $color[3].$color[3]);
		return array("r" => hexdec($r), "g" => hexdec($g), "b" => hexdec($b));
	}

	function random_string($_length = 16) {
		$symbols = '123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$string = "";
		for ($i=0; $i<$_length; $i++) {
			$string .= $symbols[rand(0, strlen($symbols)-1)];
		}
		return $string;
	}

	function wpml_parse_form_id($_form_id, $_default_all_value = '', $_current_language = '') {
		$form_id = $_form_id;
		$forms = array('all' => $_default_all_value);
		$pairs = explode(',', $_form_id);
		foreach($pairs as $pair) {
			$data = explode(':', $pair);
			if (sizeof($data) != 2) $forms['all'] = $data[0];
			else $forms[$data[0]] = $data[1];
		}
		if (!defined('ICL_LANGUAGE_CODE')) $form_id = $forms['all'];
		else {
			if (!empty($_current_language) && array_key_exists($_current_language, $forms)) $form_id = $forms[$_current_language];
			else if (array_key_exists(ICL_LANGUAGE_CODE, $forms)) $form_id = $forms[ICL_LANGUAGE_CODE];
			else $form_id = $forms['all'];
		}
		return $form_id;
	}
	
	function wpml_compile_form_id($_form_id, $_old) {
		$new = $_form_id;
		if (defined('ICL_LANGUAGE_CODE')) {
			if (ICL_LANGUAGE_CODE == 'all') {
				$new = $_form_id;
			} else {
				$forms = array();
				$pairs = explode(',', $_old);
				foreach($pairs as $pair) {
					$data = explode(':', $pair);
					if (sizeof($data) != 2) $forms['all'] = $data[0];
					else $forms[$data[0]] = $data[1];
				}
				$forms[ICL_LANGUAGE_CODE] = $_form_id;
				$data = array();
				foreach ($forms as $key => $value) {
					$data[] = $key.':'.$value;
				}
				$new = implode(',', $data);
			}
		}
		return $new;
	}

	function register_session() {
		if(!session_id()) {
			session_start();
		}
	}

	function handle_demo_mode() {
		if (defined('HALFDATA_DEMO') && HALFDATA_DEMO === true && !defined('UAP_CORE') && is_user_logged_in() && !current_user_can('edit_posts') && is_admin()) {
			$this->demo_mode = true;
		} else if (defined('HALFDATA_DEMO') && HALFDATA_DEMO === true && defined('UAP_CORE')) {
			$this->demo_mode = true;
		}
	}
	
	function widgets_init() {
		include_once(dirname(__FILE__).'/widget.php');
		register_widget('leform_widget');
	}
}
$leform = new leform_class();
?>