<?php
/* HTML Form integration for Green Forms */
if (!defined('UAP_CORE') && !defined('ABSPATH')) exit;
class leform_customjs_class {
	var $default_form_options = array(
		"customjs-afterinit-enable" => "off",
		"customjs-afterinit-script" => "",
		"customjs-aftersubmitsuccess-enable" => "off",
		"customjs-aftersubmitsuccess-script" => "",
	);
	
	function __construct() {
		if (is_admin()) {
		}
		add_filter('leform_element_properties_meta', array(&$this, 'element_properties_meta'), 10, 1);
		add_filter('leform_form_suffix', array(&$this, 'front_form_suffix'), 10, 3);
	}
	
	function element_properties_meta($_meta) {
		$_meta['settings']['advanced-sections']['sections']['customjs'] = array('label' => esc_html__('Custom JavaScript Handlers', 'leform'), 'icon' => 'fab fa-js');
		$_meta_part = array(
			'start-customjs' => array('type' => 'section-start', 'section' => 'customjs'),
				'customjs-afterinit-enable' => array('value' => 'off', 'label' => esc_html__('AfterInit handler', 'leform'), 'tooltip' => esc_html__('Enable this feature to add JS-code which is executed when form initialized.', 'leform'), 'type' => 'checkbox'),
				'customjs-afterinit-script' => array('value' => '', 'label' => esc_html__('AfterInit code', 'leform'), 'tooltip' => esc_html__('JavaScript code which is executed when form initialized. Do not use script-tags (just put regular javascript-code) and make sure your javascript-code does not have any syntax errors.', 'leform'), 'type' => 'textarea', 'monospace' => 'on', 'visible' => array('customjs-afterinit-enable' => array('on'))),
				'customjs-aftersubmitsuccess-enable' => array('value' => 'off', 'label' => esc_html__('AfterSubmitSuccess handler', 'leform'), 'tooltip' => esc_html__('Enable this feature to add JS-code which is executed when form successfully submitted.', 'leform'), 'type' => 'checkbox'),
				'customjs-aftersubmitsuccess-script' => array('value' => '', 'label' => esc_html__('AfterSubmitSuccess code', 'leform'), 'tooltip' => esc_html__('JavaScript code which is executed when form successfully submitted. Do not use script-tags (just put regular javascript-code) and make sure your javascript-code does not have any syntax errors.', 'leform'), 'type' => 'textarea', 'monospace' => 'on', 'visible' => array('customjs-aftersubmitsuccess-enable' => array('on'))),
			'end-customjs' => array('type' => 'section-end')
		);
		$_meta['settings'] = array_merge($_meta['settings'], $_meta_part);
		return $_meta;
	}

	function front_form_suffix($_suffix, $_element_id, $_form_object) {
		global $leform;
		$form_options = array_merge($this->default_form_options, $_form_object->form_options);
		$suffix = '
<script>
leform_customjs_handlers["'.$_element_id.'"] = {'.($form_options['customjs-afterinit-enable'] == 'on' && !empty($form_options['customjs-afterinit-script']) ? '
	afterinit:			function(){
		'.$form_options['customjs-afterinit-script'].'
	},': '').($form_options['customjs-aftersubmitsuccess-enable'] == 'on' && !empty($form_options['customjs-aftersubmitsuccess-script']) ? '
	aftersubmitsuccess:	function(){
		'.$form_options['customjs-aftersubmitsuccess-script'].'
	},': '').'
	dom_id:				"'.$_element_id.'",
	form_id:			"'.$_form_object->id.'",
	errors:				{},
	user_data:			{},
	get_field_value:	function(_element_id) {return jQuery(".leform-form[data-id=\'"+this.dom_id+"\']").find("[name=\'leform-"+_element_id+"\']").val();},
	set_field_value:	function(_element_id, _value) {return jQuery(".leform-form[data-id=\'"+this.dom_id+"\']").find("[name=\'leform-"+_element_id+"\']").val(_value);}
};
</script>';
		return $_suffix.$suffix;
	}
	
}
$leform_customjs = new leform_customjs_class();
?>