<?php
if (!defined('UAP_CORE') && !defined('ABSPATH')) exit;
class leform_ajax_class {
	function __construct() {
		if (is_admin()) {
			add_action('wp_ajax_leform-settings-save', array(&$this, "admin_settings_save"));
			add_action('wp_ajax_leform-advanced-settings-save', array(&$this, "admin_advanced_settings_save"));
			add_action('wp_ajax_leform-forms-status-toggle', array(&$this, "admin_forms_status_toggle"));
			add_action('wp_ajax_leform-forms-delete', array(&$this, "admin_forms_delete"));
			add_action('wp_ajax_leform-forms-duplicate', array(&$this, "admin_forms_duplicate"));
			add_action('wp_ajax_leform-stats-reset', array(&$this, "admin_stats_reset"));
			add_action('wp_ajax_leform-records-delete', array(&$this, "admin_records_delete"));
			add_action('wp_ajax_leform-transactions-delete', array(&$this, "admin_transactions_delete"));
			add_action('wp_ajax_leform-form-save', array(&$this, "admin_form_save"));
			add_action('wp_ajax_leform-form-preview', array(&$this, "admin_form_save"));
			add_action('wp_ajax_leform-record-details', array(&$this, "admin_record_details"));
			add_action('wp_ajax_leform-transaction-details', array(&$this, "admin_transaction_details"));
			add_action('wp_ajax_leform-stats-load', array(&$this, "admin_stats_load"));
			add_action('wp_ajax_leform-field-analytics-load', array(&$this, "admin_field_analytics_load"));
			add_action('wp_ajax_leform-using', array(&$this, "admin_using"));

			add_action('wp_ajax_leform-remote-init', array(&$this, "front_remote_init"));
			add_action('wp_ajax_nopriv_leform-remote-init', array(&$this, "front_remote_init"));
			add_action('wp_ajax_leform-upload', array(&$this, "front_upload"));
			add_action('wp_ajax_nopriv_leform-upload', array(&$this, "front_upload"));
			add_action('wp_ajax_leform-upload-progress', array(&$this, "front_upload_progress"));
			add_action('wp_ajax_nopriv_leform-upload-progress', array(&$this, "front_upload_progress"));
			add_action('wp_ajax_leform-upload-delete', array(&$this, "front_upload_delete"));
			add_action('wp_ajax_nopriv_leform-upload-delete', array(&$this, "front_upload_delete"));
			add_action('wp_ajax_leform-front-submit', array(&$this, "front_submit"));
			add_action('wp_ajax_nopriv_leform-front-submit', array(&$this, "front_submit"));
			add_action('wp_ajax_leform-front-next', array(&$this, "front_submit"));
			add_action('wp_ajax_nopriv_leform-front-next', array(&$this, "front_submit"));
			add_action('wp_ajax_leform-front-add-impression', array(&$this, "front_add_impression"));
			add_action('wp_ajax_nopriv_leform-front-add-impression', array(&$this, "front_add_impression"));
			add_action('wp_ajax_leform-front-popup-load', array(&$this, "front_popup_load"));
			add_action('wp_ajax_nopriv_leform-front-popup-load', array(&$this, "front_popup_load"));
		}
	}

	function admin_settings_save() {
		global $wpdb, $leform;
		if ($leform->demo_mode) {
			echo json_encode(array('status' => 'ERROR', 'message' => esc_html__('This operation disabled in DEMO mode.', 'leform')));
			exit;
		}
		if (current_user_can('manage_options')) {
			$leform->populate_options();

			if (array_key_exists('leform-ga-tracking', $_REQUEST)) $leform->options['ga-tracking'] = 'on';
			else $leform->options['ga-tracking'] = 'off';
			if (array_key_exists('leform-fa-enable', $_REQUEST)) $leform->options['fa-enable'] = 'on';
			else $leform->options['fa-enable'] = 'off';
			if (array_key_exists('leform-fa-solid-enable', $_REQUEST)) $leform->options['fa-solid-enable'] = 'on';
			else $leform->options['fa-solid-enable'] = 'off';
			if (array_key_exists('leform-fa-regular-enable', $_REQUEST)) $leform->options['fa-regular-enable'] = 'on';
			else $leform->options['fa-regular-enable'] = 'off';
			if (array_key_exists('leform-fa-brands-enable', $_REQUEST)) $leform->options['fa-brands-enable'] = 'on';
			else $leform->options['fa-brands-enable'] = 'off';
			if (array_key_exists('leform-fa-css-disable', $_REQUEST)) $leform->options['fa-css-disable'] = 'on';
			else $leform->options['fa-css-disable'] = 'off';
			if (array_key_exists('leform-mask-enable', $_REQUEST)) $leform->options['mask-enable'] = 'on';
			else $leform->options['mask-enable'] = 'off';
			if (array_key_exists('leform-airdatepicker-enable', $_REQUEST)) $leform->options['airdatepicker-enable'] = 'on';
			else $leform->options['airdatepicker-enable'] = 'off';
			if (array_key_exists('leform-jsep-enable', $_REQUEST)) $leform->options['jsep-enable'] = 'on';
			else $leform->options['jsep-enable'] = 'off';
			if (array_key_exists('leform-mask-js-disable', $_REQUEST)) $leform->options['mask-js-disable'] = 'on';
			else $leform->options['mask-js-disable'] = 'off';

			$errors = array();
			
			if ($leform->options['fa-enable'] == 'on') {
				if ($leform->options['fa-solid-enable'] != 'on' && $leform->options['fa-regular-enable'] != 'on' && $leform->options['fa-brands-enable'] != 'on') $errors[] = esc_html__('Select at least one Font Awesome Icon pack.', 'leform');
			}
			
			if (!empty($errors)) {
				$return_object = array();
				$return_object['status'] = 'ERROR';
				$return_object['message'] = esc_html__('Attention! Please correct the errors below and try again.', 'leform').'<ul><li>'.implode('</li><li>', $errors).'</li></ul>';
				echo json_encode($return_object);
				exit;
			}
			$leform->update_options();
			
			$return_object = array();
			$return_object['status'] = 'OK';
			$return_object['message'] = esc_html__('Settings successfully saved.', 'leform');
			echo json_encode($return_object);
		}
		exit;
	}
	
	function admin_advanced_settings_save() {
		global $wpdb, $leform;
		if ($leform->demo_mode) {
			echo json_encode(array('status' => 'ERROR', 'message' => esc_html__('This operation disabled in DEMO mode.', 'leform')));
			exit;
		}
		if (current_user_can('manage_options')) {
			$leform->populate_advanced_options();

			if (array_key_exists('leform-advanced-enable-htmlform', $_REQUEST)) $leform->advanced_options['enable-htmlform'] = 'on';
			else $leform->advanced_options['enable-htmlform'] = 'off';
			if (array_key_exists('leform-advanced-enable-activecampaign', $_REQUEST)) $leform->advanced_options['enable-activecampaign'] = 'on';
			else $leform->advanced_options['enable-activecampaign'] = 'off';
			if (array_key_exists('leform-advanced-enable-activetrail', $_REQUEST)) $leform->advanced_options['enable-activetrail'] = 'on';
			else $leform->advanced_options['enable-activetrail'] = 'off';
			if (array_key_exists('leform-advanced-enable-agilecrm', $_REQUEST)) $leform->advanced_options['enable-agilecrm'] = 'on';
			else $leform->advanced_options['enable-agilecrm'] = 'off';
			if (array_key_exists('leform-advanced-enable-avangemail', $_REQUEST)) $leform->advanced_options['enable-avangemail'] = 'on';
			else $leform->advanced_options['enable-avangemail'] = 'off';
			if (array_key_exists('leform-advanced-enable-aweber', $_REQUEST)) $leform->advanced_options['enable-aweber'] = 'on';
			else $leform->advanced_options['enable-aweber'] = 'off';
			if (array_key_exists('leform-advanced-enable-campaignmonitor', $_REQUEST)) $leform->advanced_options['enable-campaignmonitor'] = 'on';
			else $leform->advanced_options['enable-campaignmonitor'] = 'off';
			if (array_key_exists('leform-advanced-enable-conversio', $_REQUEST)) $leform->advanced_options['enable-conversio'] = 'on';
			else $leform->advanced_options['enable-conversio'] = 'off';
			if (array_key_exists('leform-advanced-enable-freshmail', $_REQUEST)) $leform->advanced_options['enable-freshmail'] = 'on';
			else $leform->advanced_options['enable-freshmail'] = 'off';
			if (array_key_exists('leform-advanced-enable-getresponse', $_REQUEST)) $leform->advanced_options['enable-getresponse'] = 'on';
			else $leform->advanced_options['enable-getresponse'] = 'off';
			if (array_key_exists('leform-advanced-enable-jetpack', $_REQUEST)) $leform->advanced_options['enable-jetpack'] = 'on';
			else $leform->advanced_options['enable-jetpack'] = 'off';
			if (array_key_exists('leform-advanced-enable-madmimi', $_REQUEST)) $leform->advanced_options['enable-madmimi'] = 'on';
			else $leform->advanced_options['enable-madmimi'] = 'off';
			if (array_key_exists('leform-advanced-enable-mailautic', $_REQUEST)) $leform->advanced_options['enable-mailautic'] = 'on';
			else $leform->advanced_options['enable-mailautic'] = 'off';
			if (array_key_exists('leform-advanced-enable-mailchimp', $_REQUEST)) $leform->advanced_options['enable-mailchimp'] = 'on';
			else $leform->advanced_options['enable-mailchimp'] = 'off';
			if (array_key_exists('leform-advanced-enable-mailerlite', $_REQUEST)) $leform->advanced_options['enable-mailerlite'] = 'on';
			else $leform->advanced_options['enable-mailerlite'] = 'off';
			if (array_key_exists('leform-advanced-enable-mailpoet', $_REQUEST)) $leform->advanced_options['enable-mailpoet'] = 'on';
			else $leform->advanced_options['enable-mailpoet'] = 'off';
			if (array_key_exists('leform-advanced-enable-mailster', $_REQUEST)) $leform->advanced_options['enable-mailster'] = 'on';
			else $leform->advanced_options['enable-mailster'] = 'off';
			if (array_key_exists('leform-advanced-enable-mailwizz', $_REQUEST)) $leform->advanced_options['enable-mailwizz'] = 'on';
			else $leform->advanced_options['enable-mailwizz'] = 'off';
			if (array_key_exists('leform-advanced-enable-mumara', $_REQUEST)) $leform->advanced_options['enable-mumara'] = 'on';
			else $leform->advanced_options['enable-mumara'] = 'off';
			if (array_key_exists('leform-advanced-enable-omnisend', $_REQUEST)) $leform->advanced_options['enable-omnisend'] = 'on';
			else $leform->advanced_options['enable-omnisend'] = 'off';
			if (array_key_exists('leform-advanced-enable-ontraport', $_REQUEST)) $leform->advanced_options['enable-ontraport'] = 'on';
			else $leform->advanced_options['enable-ontraport'] = 'off';
			if (array_key_exists('leform-advanced-enable-rapidmail', $_REQUEST)) $leform->advanced_options['enable-rapidmail'] = 'on';
			else $leform->advanced_options['enable-rapidmail'] = 'off';
			if (array_key_exists('leform-advanced-enable-zohocrm', $_REQUEST)) $leform->advanced_options['enable-zohocrm'] = 'on';
			else $leform->advanced_options['enable-zohocrm'] = 'off';

			if (array_key_exists('leform-advanced-enable-blockchain', $_REQUEST)) $leform->advanced_options['enable-blockchain'] = 'on';
			else $leform->advanced_options['enable-blockchain'] = 'off';
			if (array_key_exists('leform-advanced-enable-interkassa', $_REQUEST)) $leform->advanced_options['enable-interkassa'] = 'on';
			else $leform->advanced_options['enable-interkassa'] = 'off';
			if (array_key_exists('leform-advanced-enable-paypal', $_REQUEST)) $leform->advanced_options['enable-paypal'] = 'on';
			else $leform->advanced_options['enable-paypal'] = 'off';
			if (array_key_exists('leform-advanced-enable-perfectmoney', $_REQUEST)) $leform->advanced_options['enable-perfectmoney'] = 'on';
			else $leform->advanced_options['enable-perfectmoney'] = 'off';
			if (array_key_exists('leform-advanced-enable-skrill', $_REQUEST)) $leform->advanced_options['enable-skrill'] = 'on';
			else $leform->advanced_options['enable-skrill'] = 'off';
			if (array_key_exists('leform-advanced-enable-stripe', $_REQUEST)) $leform->advanced_options['enable-stripe'] = 'on';
			else $leform->advanced_options['enable-stripe'] = 'off';

			if (array_key_exists('leform-advanced-minified-sources', $_REQUEST)) $leform->advanced_options['minified-sources'] = 'on';
			else $leform->advanced_options['minified-sources'] = 'off';

			$errors = array();
			if (!empty($errors)) {
				$return_object = array();
				$return_object['status'] = 'ERROR';
				$return_object['message'] = esc_html__('Attention! Please correct the errors below and try again.', 'leform').'<ul><li>'.implode('</li><li>', $errors).'</li></ul>';
				echo json_encode($return_object);
				exit;
			}
			$leform->update_advanced_options();
			
			$return_object = array();
			$return_object['status'] = 'OK';
			$return_object['message'] = esc_html__('Settings successfully saved.', 'leform');
			echo json_encode($return_object);
		}
		exit;
	}
	
	function admin_forms_status_toggle() {
		global $wpdb, $leform;
		if (current_user_can('manage_options') || $leform->demo_mode) {
			$callback = '';
			if (isset($_REQUEST['callback'])) {
				header("Content-type: text/javascript");
				$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
			}
			$form_id = null;
			if (array_key_exists('form-id', $_REQUEST)) {
				$form_id = intval($_REQUEST['form-id']);
				$form_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0' AND id = '".esc_sql($form_id)."'", ARRAY_A);
				if (empty($form_details)) $form_id = null;
			}
			if (empty($form_id)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Requested form not found.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			if ($_REQUEST['form-status'] == 'active') {
				$wpdb->query("UPDATE ".$wpdb->prefix."leform_forms SET active = '0' WHERE deleted = '0' AND id = '".esc_sql($form_id)."'");
				$return_data = array(
					'status' => 'OK',
					'message' => esc_html__('The form successfully deactivated.', 'leform'),
					'form_action' => esc_html__('Activate', 'leform'),
					'form_action_doing' => esc_html__('Activating...', 'leform'),
					'form_status' => 'inactive',
					'form_status_label' => esc_html__('No', 'leform')
				);
			} else {
				$wpdb->query("UPDATE ".$wpdb->prefix."leform_forms SET active = '1' WHERE deleted = '0' AND id = '".esc_sql($form_id)."'");
				$return_data = array(
					'status' => 'OK',
					'message' => esc_html__('The form successfully activated.', 'leform'),
					'form_action' => esc_html__('Deactivate', 'leform'),
					'form_action_doing' => esc_html__('Deactivating...', 'leform'),
					'form_status' => 'active',
					'form_status_label' => esc_html__('Yes', 'leform')
				);
			}
			if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
			else echo json_encode($return_data);
		}
		exit;
	}
	
	function admin_forms_delete() {
		global $wpdb, $leform;
		if (current_user_can('manage_options') || $leform->demo_mode) {
			$callback = '';
			if (isset($_REQUEST['callback'])) {
				header("Content-type: text/javascript");
				$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
			}
			$form_id = null;
			if (array_key_exists('form-id', $_REQUEST)) {
				$form_id = intval($_REQUEST['form-id']);
				$form_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0' AND id = '".$form_id."'", ARRAY_A);
				if (empty($form_details)) $form_id = null;
			}
			if (empty($form_id)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Requested form not found.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			$wpdb->query("UPDATE ".$wpdb->prefix."leform_forms SET deleted = '1' WHERE deleted = '0' AND id = '".esc_sql($form_id)."'");
			$return_data = array(
				'status' => 'OK',
				'message' => esc_html__('The form successfully deleted.', 'leform')
			);
			if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
			else echo json_encode($return_data);
		}
		exit;
	}

	function admin_forms_duplicate() {
		global $wpdb, $leform;
		if (current_user_can('manage_options') || $leform->demo_mode) {
			$callback = '';
			if (isset($_REQUEST['callback'])) {
				header("Content-type: text/javascript");
				$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
			}
			$form_id = null;
			if (array_key_exists('form-id', $_REQUEST)) {
				$form_id = intval($_REQUEST['form-id']);
				$form_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0' AND id = '".esc_sql($form_id)."'", ARRAY_A);
				if (empty($form_details)) $form_id = null;
			}
			if (empty($form_id)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Requested form not found.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_forms (name,options,pages,elements,active,created,modified,deleted) VALUES (
				'".esc_sql($form_details['name'])."','".esc_sql($form_details['options'])."','".esc_sql($form_details['pages'])."','".esc_sql($form_details['elements'])."','".esc_sql($form_details['active'])."','".esc_sql(time())."','".esc_sql(time())."','0')");

			$return_data = array(
				'status' => 'OK',
				'message' => esc_html__('The form successfully duplicated.', 'leform')
			);
			if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
			else echo json_encode($return_data);
		}
		exit;
	}

	function admin_stats_reset() {
		global $wpdb, $leform;
		if (current_user_can('manage_options') || $leform->demo_mode) {
			$callback = '';
			if (isset($_REQUEST['callback'])) {
				header("Content-type: text/javascript");
				$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
			}
			$form_id = null;
			if (array_key_exists('form-id', $_REQUEST)) {
				$form_id = intval($_REQUEST['form-id']);
				$form_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0' AND id = '".esc_sql($form_id)."'", ARRAY_A);
				if (empty($form_details)) $form_id = null;
			}
			if (empty($form_id)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Requested form not found.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			$wpdb->query("UPDATE ".$wpdb->prefix."leform_stats SET impressions = '0', submits = '0', confirmed = '0', payments = '0' WHERE form_id = '".esc_sql($form_id)."'");

			$return_data = array(
				'status' => 'OK',
				'message' => esc_html__('The form statistics successfully reset.', 'leform')
			);
			if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
			else echo json_encode($return_data);
		}
		exit;
	}
	
	function admin_form_save() {
		global $wpdb, $leform;
		if (current_user_can('manage_options') || $leform->demo_mode) {
			$callback = '';
			if (isset($_REQUEST['callback'])) {
				header("Content-type: text/javascript");
				$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
			}
			
			$form_id = null;
			$form_options = null;
			$form_details = array();
			if (array_key_exists('form-id', $_REQUEST)) {
				$form_id = intval($_REQUEST['form-id']);
				$form_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0' AND id = '".esc_sql($form_id)."'", ARRAY_A);
				if (empty($form_details)) $form_id = null;
			}
			
			$default_form_options = $leform->default_form_options();
			$form_options = $default_form_options;
			if (array_key_exists('form-options', $_REQUEST)) {
				$form_options_new = json_decode(base64_decode(trim(stripslashes($_REQUEST['form-options']))), true);
				if (is_array($form_options_new)) $form_options = array_merge($form_options, $form_options_new);
			}
			if (empty($form_options['name'])) $form_options['name'] = esc_html__('Untitled', 'leform');

			$form_pages = array();
			$default_page_options = $leform->default_form_options("page");
			$default_page_confirmation_options = $leform->default_form_options("page-confirmation");
			if (array_key_exists('form-pages', $_REQUEST) && is_array($_REQUEST['form-pages'])) {
				foreach($_REQUEST['form-pages'] as $encoded_page) {
					$page_options = json_decode(base64_decode(trim(stripslashes($encoded_page))), true);
					if (is_array($page_options)) {
						if (!array_key_exists('type', $page_options)) $page_options['type'] = 'page';
						if ($page_options['type'] == 'page') $page_options = array_merge($default_page_options, $page_options);
						else $page_options = array_merge($default_page_confirmation_options, $page_options);
						$form_pages[] = $page_options;
					}
				}
			}
			
			$form_elements = array();
			if (array_key_exists('form-elements', $_REQUEST) && is_array($_REQUEST['form-elements'])) {
				foreach($_REQUEST['form-elements'] as $encoded_element) {
					$element_options = json_decode(base64_decode(trim(stripslashes($encoded_element))), true);
					if (is_array($element_options) && array_key_exists('type', $element_options)) {
						$default_element_options = $leform->default_form_options($element_options['type']);
						$element_options = array_merge($default_element_options, $element_options);
						$form_elements[] = json_encode($element_options);
					}
				}
			}
			
			if (empty($form_id)) {
				if ($_REQUEST['action'] != 'leform-form-preview') {
					$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_forms (name,options,pages,elements,cache_time,active,created,modified,deleted) VALUES (
						'".esc_sql($form_options['name'])."','".esc_sql(json_encode($form_options))."','".esc_sql(json_encode($form_pages))."','".esc_sql(json_encode($form_elements))."','0','".esc_sql($form_options['active'] == 'on' ? 1 : 0)."','".esc_sql(time())."','".esc_sql(time())."','0')");
					$form_id = $wpdb->insert_id;
				}
			} else {
				if ($_REQUEST['action'] != 'leform-form-preview') {
					$wpdb->query("UPDATE ".$wpdb->prefix."leform_forms SET 
						name = '".esc_sql($form_options['name'])."',
						options = '".esc_sql(json_encode($form_options))."',
						pages = '".esc_sql(json_encode($form_pages))."',
						elements = '".esc_sql(json_encode($form_elements))."',
						cache_time = '0',
						active = '".esc_sql($form_options['active'] == 'on' ? 1 : 0)."',
						modified = '".esc_sql(time())."'
						WHERE deleted = '0' AND id = '".esc_sql($form_id)."'");
				}
				$preview_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_previews WHERE deleted = '0' AND form_id = '".esc_sql($form_id)."'", ARRAY_A);
				if (empty($preview_details)) {
					$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_previews (form_id, name,options,pages,elements,created,deleted) VALUES (
						'".esc_sql($form_id)."', '".esc_sql($form_options['name'])."','".esc_sql(json_encode($form_options))."','".esc_sql(json_encode($form_pages))."','".esc_sql(json_encode($form_elements))."','".esc_sql(time())."','0')");
				} else {
					$wpdb->query("UPDATE ".$wpdb->prefix."leform_previews SET 
						form_id = '".esc_sql($form_id)."',
						name = '".esc_sql($form_options['name'])."',
						options = '".esc_sql(json_encode($form_options))."',
						pages = '".esc_sql(json_encode($form_pages))."',
						elements = '".esc_sql(json_encode($form_elements))."'
						WHERE deleted = '0' AND form_id = '".esc_sql($form_id)."'");
				}
			}

			$return_data = array(
				'status' => 'OK',
				'form_id' => $form_id,
				'form_name' => $form_options['name'],
				'preview_url' => admin_url('admin.php').'?leform-action=preview&id='.$form_id,
				'message' => esc_html__('The form successfully saved.', 'leform')
			);
			if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
			else echo json_encode($return_data);
		}
		exit;
	}

	function admin_records_delete() {
		global $wpdb, $leform;
		if (current_user_can('manage_options') || $leform->demo_mode) {
			$callback = '';
			if (isset($_REQUEST['callback'])) {
				header("Content-type: text/javascript");
				$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
			}
			$record_id = null;
			if (array_key_exists('record-id', $_REQUEST)) {
				$record_id = intval($_REQUEST['record-id']);
				$record_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_records WHERE deleted = '0' AND id = '".esc_sql($record_id)."'", ARRAY_A);
				if (empty($record_details)) $record_id = null;
			}
			if (empty($record_id)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Requested record not found.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			$wpdb->query("UPDATE ".$wpdb->prefix."leform_records SET deleted = '1' WHERE deleted = '0' AND id = '".esc_sql($record_id)."'");
			$return_data = array(
				'status' => 'OK',
				'message' => esc_html__('The record successfully deleted.', 'leform')
			);
			if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
			else echo json_encode($return_data);
		}
		exit;
	}

	function admin_record_details() {
		global $wpdb, $leform;
		if (current_user_can('manage_options') || $leform->demo_mode) {
			$callback = '';
			if (isset($_REQUEST['callback'])) {
				header("Content-type: text/javascript");
				$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
			}
			$record_id = null;
			if (array_key_exists('record-id', $_REQUEST)) {
				$record_id = intval($_REQUEST['record-id']);
				$record_details = $wpdb->get_row("SELECT t1.*, t2.name AS form_name, t2.options AS form_options, t2.elements AS form_elements FROM ".$wpdb->prefix."leform_records t1 LEFT JOIN ".$wpdb->prefix."leform_forms t2 ON t2.id = t1.form_id WHERE t1.deleted = '0' AND t1.id = '".esc_sql($record_id)."'", ARRAY_A);
				if (empty($record_details)) $record_id = null;
			}
			if (empty($record_id)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Requested record not found.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			
			$form_elements = json_decode($record_details['form_elements'], true);
			if (!is_array($form_elements)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Requested form corrupted.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			
			$fields = json_decode($record_details['fields'], true);
			if (!is_array($fields)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Requested record corrupted.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			
			$fields_meta = array();
			foreach($form_elements as $form_element_json) {
				$form_element = json_decode($form_element_json, true);
				if (is_array($form_element) && array_key_exists('name', $form_element)) {
					$fields_meta[$form_element['id']]['name'] = $form_element['name'];
					$fields_meta[$form_element['id']]['type'] = $form_element['type'];
				}
			}
			
			$html = '
			<div class="leform-record-details">';
			if (sizeof($fields) > 0) {
				$html .= '
				<h3>'.esc_html__('Form values', 'leform').'</h3>
				<table class="leform-record-details-table">';
				$upload_dir = wp_upload_dir();
				foreach ($fields as $id => $values) {
					if ($fields_meta[$id]['type'] == 'file') {
						if (!empty($values)) {
							foreach ($values as $values_key => $values_value) {
								$values[$values_key] = esc_sql($values_value);
							}
							$uploads = $wpdb->get_results("SELECT * FROM ".$wpdb->prefix."leform_uploads WHERE id IN ('".implode("', '", $values)."')", ARRAY_A);
							$values = array();
							foreach($uploads as $upload_details) {
								if (file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/'.$record_details['form_id'].'/'.$upload_details['filename']) && is_file($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/'.$record_details['form_id'].'/'.$upload_details['filename'])) {
									$values[] = '<a href="'.admin_url('admin.php').'?page=leform&leform-action=download&id='.esc_html($upload_details['id']).'" target="_blank">'.esc_html($upload_details['filename_original']).'</a>';
								} else {
									$values[] = esc_html($upload_details['filename_original']).' ('.esc_html__('file deleted', 'leform').')';
								}
							}
							if (!empty($values)) $value = implode("<br />", $values);
							else $value = '-';
						} else $value = '-';
					} else if (is_array($values)) {
						foreach ($values as $key => $values_value) {
							$values_value = trim($values_value);
							if ($values_value == "") $values[$key] = "-";
							else $values[$key] = esc_html($values_value);
						}
						$value = implode("<br />", $values);
					} else if ($values != "") {
						if ($fields_meta[$id]['type'] == 'textarea') {
							$value_strings = explode("\n", $values);
							foreach ($value_strings as $key => $values_value) {
								$value_strings[$key] = esc_html(trim($values_value));
							}
							$value = implode("<br />", $value_strings);
						} else $value = esc_html($values);
					} else $value = "-";	
					$html .= '
					<tr><td class="leform-record-details-table-name">'.(array_key_exists($id, $fields_meta) ? esc_html($fields_meta[$id]['name']) : '-').'</td><td class="leform-record-details-table-value">'.$value.'</td></tr>';
				}
				$html .= '
				</table>';
			}
			if ($record_details['amount'] > 0) {
					$html .= '
				<h3>'.esc_html__('Payment', 'leform').'</h3>
				<table class="leform-record-details-table">
					<tr><td class="leform-record-details-table-name">'.esc_html__('Amount', 'leform').'</td><td class="leform-record-details-table-value">'.($record_details['currency'] != 'BTC' ? number_format($record_details['amount'], 2, '.', '') : number_format($record_details['amount'], 8, '.', '')).' '.esc_html($record_details['currency']).'</td></tr>
					<tr><td class="leform-record-details-table-name">'.esc_html__('Status', 'leform').'</td><td class="leform-record-details-table-value">'.($record_details['status'] == LEFORM_RECORD_STATUS_PAID ? '<span class="leform-badge leform-badge-success">'.esc_html__('Paid', 'leform').'</span>' : '<span class="leform-badge leform-badge-danger">'.esc_html__('Unpaid', 'leform').'</span>').'</td></tr>
				</table>';
			}
			$info = json_decode($record_details['info'], true);
			if (is_array($info)) {
				if (sizeof($fields) > 0) {
					$html .= '
				<h3>'.esc_html__('Technical info', 'leform').'</h3>
				<table class="leform-record-details-table">';
					foreach($info as $info_key => $info_value) {
						$label = $leform->get_info_label($info_key);
						$html .= '
					<tr><td class="leform-record-details-table-name">'.esc_html($label).'</td><td class="leform-record-details-table-value">'.esc_html($info_value).'</td></tr>';
					}
					$html .= '
				</table>';
				}
			}
			$html .= '</div>';
			
			
			$return_data = array(
				'status' => 'OK',
				'html' => $html,
				'form_name' => esc_html($record_details['form_name'])
			);
			if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
			else echo json_encode($return_data);
		}
		exit;
	}

	function admin_transactions_delete() {
		global $wpdb, $leform;
		if (current_user_can('manage_options') || $leform->demo_mode) {
			$callback = '';
			if (isset($_REQUEST['callback'])) {
				header("Content-type: text/javascript");
				$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
			}
			$record_id = null;
			if (array_key_exists('transaction-id', $_REQUEST)) {
				$record_id = intval($_REQUEST['transaction-id']);
				$record_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_transactions WHERE deleted = '0' AND id = '".esc_sql($record_id)."'", ARRAY_A);
				if (empty($record_details)) $record_id = null;
			}
			if (empty($record_id)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Requested transaction not found.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			$wpdb->query("UPDATE ".$wpdb->prefix."leform_transactions SET deleted = '1' WHERE deleted = '0' AND id = '".esc_sql($record_id)."'");
			$return_data = array(
				'status' => 'OK',
				'message' => esc_html__('The transaction successfully deleted.', 'leform')
			);
			if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
			else echo json_encode($return_data);
		}
		exit;
	}

	function admin_transaction_details() {
		global $wpdb, $leform;
		if (current_user_can('manage_options') || $leform->demo_mode) {
			$callback = '';
			if (isset($_REQUEST['callback'])) {
				header("Content-type: text/javascript");
				$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
			}
			$record_id = null;
			if (array_key_exists('transaction-id', $_REQUEST)) {
				$record_id = intval($_REQUEST['transaction-id']);
				$record_details = $wpdb->get_row("SELECT t1.*, t2.form_id AS form_id FROM ".$wpdb->prefix."leform_transactions t1 LEFT JOIN ".$wpdb->prefix."leform_records t2 ON t2.id = t1.record_id WHERE t1.deleted = '0' AND t1.id = '".esc_sql($record_id)."'", ARRAY_A);
				if (empty($record_details)) $record_id = null;
			}
			if (empty($record_id)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Requested transaction not found.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			$html = apply_filters('leform_payment_gateways_transaction_html_'.$record_details['provider'], "", $record_details);
			if (empty($html)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Transaction details not found.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			$return_data = array(
				'status' => 'OK',
				'html' => $html
			);
			if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
			else echo json_encode($return_data);
		}
		exit;
	}

	function admin_stats_load() {
		global $wpdb, $leform;
		if (current_user_can('manage_options') || $leform->demo_mode) {
			$callback = '';
			if (isset($_REQUEST['callback'])) {
				header("Content-type: text/javascript");
				$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
			}
			
			if (!array_key_exists('start-date', $_REQUEST) || !array_key_exists('end-date', $_REQUEST) || !array_key_exists('form-id', $_REQUEST)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Invalid request.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			
			$form_id = null;
			if ($_REQUEST['form-id'] != 0) {
				$form_id = intval($_REQUEST['form-id']);
				$form_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0' AND id = '".esc_sql($form_id)."'", ARRAY_A);
				if (empty($form_details)) $form_id = null;
			}
			
			try {
				$start_date = new DateTime($_REQUEST['start-date']);
				$end_date = new DateTime($_REQUEST['end-date']);
			} catch (Exception $e) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Invalid dates.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}

			if ($end_date->diff($start_date)->days > 366) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Date interval is too large.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			
			if ($start_date > $end_date) $output = $leform->stats_array($form_id, $end_date, $start_date);
			else $output = $leform->stats_array($form_id, $start_date, $end_date);
			
			$return_data = array(
				'status' => 'OK',
				'data' => $output
			);
			if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
			else echo json_encode($return_data);
		}
		exit;
	}

	function admin_field_analytics_load() {
		global $wpdb, $leform;
		if (current_user_can('manage_options') || $leform->demo_mode) {
			$callback = '';
			if (isset($_REQUEST['callback'])) {
				header("Content-type: text/javascript");
				$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
			}
			
			if (!array_key_exists('start-date', $_REQUEST) || !array_key_exists('end-date', $_REQUEST) || !array_key_exists('form-id', $_REQUEST)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Invalid request.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			
			$form_id = null;
			if ($_REQUEST['form-id'] != 0) {
				if (!class_exists("leform_form")) include_once(dirname(__FILE__).'/core-form.php');
				$form_object = new leform_form(intval($_REQUEST['form-id']), true);
				if (empty($form_object->id)) $form_id = null;
				else $form_id = $form_object->id;
			}
			if (empty($form_id)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Select existing form.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			if ($_REQUEST['period'] == 'on') {
				try {
					$start_date = new DateTime($_REQUEST['start-date']);
					$end_date = new DateTime($_REQUEST['end-date']);
				} catch (Exception $e) {
					$return_data = array(
						'status' => 'ERROR',
						'message' => esc_html__('Invalid dates.', 'leform')
					);
					if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
					else echo json_encode($return_data);
					exit;
				}
			} else {
				$start_date = new DateTime('2000-01-01');
				$end_date = new DateTime('2030-12-31');
			}

			if ($start_date > $end_date) $output = $form_object->field_analytics_array($end_date, $start_date);
			else $output = $form_object->field_analytics_array($start_date, $end_date);
			
			$return_data = array(
				'status' => 'OK',
				'data' => $output
			);
			if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
			else echo json_encode($return_data);
		}
		exit;
	}

	function admin_using() {
		global $wpdb, $leform;
		if (current_user_can('manage_options') || $leform->demo_mode) {
			$callback = '';
			if (isset($_REQUEST['callback'])) {
				header("Content-type: text/javascript");
				$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
			}
			$form_id = null;
			if ($_REQUEST['form-id'] != 0) {
				$form_id = intval($_REQUEST['form-id']);
				$form_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0' AND id = '".esc_sql($form_id)."'", ARRAY_A);
				if (empty($form_details)) $form_id = null;
			}
			if (empty($form_id)) {
				$return_data = array(
					'status' => 'ERROR',
					'message' => esc_html__('Requested form not found.', 'leform')
				);
				if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
				else echo json_encode($return_data);
				exit;
			}
			if (defined('UAP_CORE')) {
				$html = '
			<div class="leform-using-details">
				<table class="leform-using-table">
					<tr>
						<td colspan="2">
							<span>'.sprintf(esc_html__('Important! Make sure that you properly embedded script into your website, as it is said on %sHow To Use%s page.', 'leform'), '<a target="_blank" href="?page=leform-using">', '</a>').'</span>
						</td>
					</tr>
					<tr>
						<th>'.esc_html__('Shortcode', 'leform').'</th>
						<td>
							<input type="text" readonly="readonly" value="'.esc_html('<div class="leform-inline" data-id="'.$form_id.'"></div>').'" onclick="this.focus();this.select();" />
						</td>
					</tr>
					<tr>
						<th>'.esc_html__('Popup (standard)', 'leform').'</th>
						<td>
							<span>'.esc_html__('Use the following URL with a link/button (href attribute):', 'leform').'</span>
							<input type="text" readonly="readonly" value="#leformx-'.esc_html($form_id).'" onclick="this.focus();this.select();" />
						</td>
					</tr>
					<tr>
						<th>'.esc_html__('Popup (javascript)', 'leform').'</th>
						<td>
							<span>'.esc_html__('Use the following javascript function to open the form in popup mode:', 'leform').'</span>
							<input type="text" readonly="readonly" value="leform_popup_open('.esc_html($form_id).');" onclick="this.focus();this.select();" />
						</td>
					</tr>
				</table>
			</div>';
			} else {
				$html = '
			<div class="leform-using-details">
				<table class="leform-using-table">
					<tr>
						<th>'.esc_html__('Gutenberg Block', 'leform').'</th>
						<td>
							<span>'.esc_html__('In case of using Gutenberg content editor you can add the form as a standard Gutenberg Block. Find it under Widgets category.', 'leform').'</span>
							<img style="width: 95%; box-shadow: 1px 1px 10px -5px;" src="'.$leform->plugins_url.'/images/gutenberg-block-scr01.png?ver='.LEFORM_VERSION.'" alt="" />
						</td>
					</tr>
					<tr>
						<th>'.esc_html__('Shortcode', 'leform').'</th>
						<td>
							<input type="text" readonly="readonly" value="[leform id=\''.esc_html($form_id).'\' name=\''.esc_html(str_replace("'", "", $form_details['name'])).'\']" onclick="this.focus();this.select();" />
						</td>
					</tr>
					<tr>
						<th>'.esc_html__('PHP', 'leform').'</th>
						<td>
							<span>'.esc_html__('Use the following PHP-code to embed the form into theme files:', 'leform').'</span>
							<input type="text" readonly="readonly" value="'.esc_html('<?php do_shortcode("[leform id=\''.esc_html($form_id).'\']"); ?>').'" onclick="this.focus();this.select();" />
						</td>
					</tr>
					<tr>
						<th>'.esc_html__('Popup (standard)', 'leform').'</th>
						<td>
							<span>'.esc_html__('Use the following URL with a link/button (href attribute):', 'leform').'</span>
							<input type="text" readonly="readonly" value="#leformx-'.esc_html($form_id).'" onclick="this.focus();this.select();" />
						</td>
					</tr>
					<tr>
						<th>'.esc_html__('Popup (javascript)', 'leform').'</th>
						<td>
							<span>'.esc_html__('Use the following javascript function to open the form in popup mode:', 'leform').'</span>
							<input type="text" readonly="readonly" value="leform_popup_open('.esc_html($form_id).');" onclick="this.focus();this.select();" />
						</td>
					</tr>
					<tr>
						<th>'.esc_html__('Widget', 'leform').'</th>
						<td>
							<span>'.esc_html__('Go to Appearance >> Widgets and drag the Green Forms widget into the desired sidebar. You will be able to select this form from the dropdown options while configuring widget.', 'leform').'</span>
						</td>
					</tr>
					<tr>
						<th>'.esc_html__('Remote use', 'leform').'</th>
						<td>
							<span>'.esc_html__('Use the form with any non-WordPress pages of the site or with 3rd party sites. How to do it?', 'leform').'</span>
							<ol>
								<li>
									<span>'.sprintf(esc_html__('Make sure that non-WordPress page has %sDOCTYPE%s. If not, add the following line as a first line of HTML-document:', 'leform'), '<code>', '</code>').'</span>
									<input type="text" readonly="readonly" value="'.esc_html('<!DOCTYPE html>').'" onclick="this.focus();this.select();" />
								</li>
								<li>
									<span>'.sprintf(esc_html__('Make sure that website loads jQuery version 1.9 or higher. If not, add the following line into %shead%s section of HTML-document:', 'leform'), '<code>', '</code>').'</span>
									<input type="text" readonly="readonly" value="'.esc_html('<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>').'" onclick="this.focus();this.select();" />
								</li>
								<li>
									<span>'.sprintf(esc_html__('Copy the following JS-snippet and paste it into HTML-document. You need paste it at the end of %sbody%s section (above closing %s</body>%s tag).', 'leform'), '<code>', '</code>', '<code>', '</code>').'</span>
									<input type="text" readonly="readonly" value="'.esc_html('<script id="leform-remote" src="'.$leform->plugins_url.'/js/leform'.($leform->advanced_options['minified-sources'] == 'on' ? '.min' : '').'.js?ver='.LEFORM_VERSION.'" data-handler="'.admin_url('admin-ajax.php').'"></script>').'" onclick="this.focus();this.select();" />
									<span>'.esc_html__('PS: You need do it one time only, even if you use several forms on the same page.', 'leform').'</span>
								</li>
								<li>
									<span>'.esc_html__('Use the following HTML-code to embed the form into HTML-document as inline form:', 'leform').'</span>
									<input type="text" readonly="readonly" value="'.esc_html('<div class="leform-inline" data-id="'.$form_id.'"></div>').'" onclick="this.focus();this.select();" />
								</li>
								<li>
									<span>'.esc_html__('Use the following URL with a link/button (href attribute) to open the form in popup mode:', 'leform').'</span>
									<input type="text" readonly="readonly" value="#leformx-'.esc_html($form_id).'" onclick="this.focus();this.select();" />
								</li>
								<li>
									<span>'.esc_html__('Use the following javascript function to open the form in popup mode:', 'leform').'</span>
									<input type="text" readonly="readonly" value="leform_popup_open('.esc_html($form_id).');" onclick="this.focus();this.select();" />
								</li>
							</ol>
						</td>
					</tr>
				</table>
			</div>';
			}
			$return_data = array(
				'status' => 'OK',
				'html' => $html,
				'form_name' => esc_html($form_details['name'])
			);
			if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
			else echo json_encode($return_data);
		}
		exit;
	}
	
	function front_submit() {
		global $wpdb, $leform;
		$callback = '';
		if (isset($_REQUEST['callback'])) {
			header("Content-type: text/javascript");
			$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
		}
		$preview = false;
		if (array_key_exists('preview', $_REQUEST) && $_REQUEST['preview'] == 'on') $preview = true;
		if (!class_exists("leform_form")) include_once(dirname(__FILE__).'/core-form.php');
		$form_object = new leform_form(intval($_REQUEST['form-id']), $preview);
		if (!empty($form_object->id)) {
			if (array_key_exists('page-id', $_REQUEST)) $page_id = intval($_REQUEST['page-id']);
			else $page_id = 0;
			$pages = $form_object->get_pages();
			if (array_key_exists($page_id, $pages)) {
				$form_data = array();
				parse_str(base64_decode($_REQUEST['form-data']), $form_data);
				
				$form_object->set_form_data($form_data);
				$form_object->set_form_info();
				
				$errors_all = $form_object->validate_form_data();
				
				if ($errors_all === false) {
					$return_data = array(
						'status' => 'FATAL',
						'message' => esc_html__('Requested form not found.', 'leform')
					);
				} else if (!is_array($errors_all)) {
					$return_data = array(
						'status' => 'FATAL',
						'message' => esc_html__('Unexpected error.', 'leform')
					);
				} else {
					$errors = array();
					if (!empty($errors_all)) {
						foreach ($pages as $key => $elements) {
							if ($form_object->is_page_visible($key)) {
								foreach ($elements as $element_id) {
									if (array_key_exists($element_id, $errors_all)) {
										$errors[$key.':'.$element_id] = $errors_all[$element_id];
									}
								}
							}
							if ($key == $page_id) break;
						}
					}
					if (empty($errors)) {
						$next_page_id = $form_object->get_next_page_id($page_id);
						if ($next_page_id === false) {
							$return_data = array(
								'status' => 'FATAL',
								'message' => esc_html__('Requested page not found.', 'leform')
							);
						} else if ($next_page_id === true || $next_page_id == 'confirmation') {
							$payment_ok = false;
							$log_record = array('str-id' => '', 'id' => 0);
							if (!$preview) {
								$log_record = $form_object->save_data();
							}
							$confirmation = $form_object->get_confirmation();
							$return_data = array(
								'status' => 'OK'
							);
							if (empty($confirmation)) {
								$return_data['type'] = 'page';
								$return_data['reset-form'] = 'on';
							} else {
								$return_data['type'] = $confirmation['type'];
								$return_data['reset-form'] = $confirmation['reset-form'];
								if (in_array($confirmation['type'], array('page-redirect', 'message-redirect', 'redirect'))) $return_data['url'] = $confirmation['url'];
								if (in_array($confirmation['type'], array('page-redirect', 'page-payment', 'message-redirect', 'message-payment', 'message'))) $return_data['delay'] = $confirmation['delay'];
								if (in_array($confirmation['type'], array('message-redirect', 'message-payment', 'message'))) {
									$return_data['message'] = $form_object->replace_shortcodes($confirmation['message']);
								}
								if (in_array($confirmation['type'], array('page-payment', 'message-payment', 'payment'))) {
									$payment_gateway = $form_object->get_payment_gateway($confirmation['payment-gateway']);
									if (!empty($payment_gateway) && is_array($payment_gateway)) {
										$data = $form_object->replace_shortcodes($payment_gateway['data']);
										$data['record-id'] = $log_record['id'];
										$data['form-id'] = $form_object->id;
										$data['form-name'] = $form_object->name;
										$payment_data = apply_filters('leform_payment_gateways_do_'.$payment_gateway['provider'], null, $data);
										if (!empty($payment_data) && is_array($payment_data) && $payment_data['status'] == 'OK') {
											$wpdb->query("UPDATE ".$wpdb->prefix."leform_records SET amount = '".esc_sql($payment_data['amount'])."', currency = '".esc_sql($payment_data['currency'])."', gateway_id = '".esc_sql($payment_gateway['id'])."', status = '".esc_sql(LEFORM_RECORD_STATUS_UNPAID)."' WHERE id = '".esc_sql($log_record['id'])."'");
											if (array_key_exists('form', $payment_data)) $return_data['payment-form'] = $payment_data['form'];
											else if (array_key_exists('message', $payment_data)) $return_data['payment-message'] = $payment_data['message'];
											else if (array_key_exists('stripe', $payment_data)) $return_data['stripe'] = $payment_data['stripe'];
											$payment_ok = true;
										} else if (!empty($payment_data) && is_array($payment_data) && $payment_data['status'] == 'ERROR' && array_key_exists('message', $payment_data)) {
											$return_data['error'] = $payment_data['message'];
										}
									}
									if (!$payment_ok) {
										if (in_array($confirmation['type'], array('page-payment', 'payment'))) $return_data['type'] = 'page';
										else $return_data['type'] = 'message';
									}
								}
							}
							if (!$preview) {
								if (!defined('HALFDATA_DEMO') || HALFDATA_DEMO != true || current_user_can('manage_options')) {
									if (!$payment_ok) {
										$shortcode_addons = array('{{confirmation-url}}' => (defined('UAP_CORE') ? admin_url('do.php') : get_bloginfo('url').'/').'?leform-confirm='.$log_record['str-id']);
										if ($form_object->form_options['double-enable'] == 'on') {
											$to = $form_object->replace_shortcodes($form_object->form_options['double-email-recipient']);
											if (!empty($to) && preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,19})$/i", $to)) {
												$subject = $form_object->replace_shortcodes($form_object->form_options['double-email-subject'], $shortcode_addons);
												$message = $form_object->replace_shortcodes($form_object->form_options['double-email-message'], $shortcode_addons);
												$from_email = $form_object->replace_shortcodes($form_object->form_options['double-from-email']);
												if (empty($from_email) || !preg_match("/^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,19})$/i", $from_email)) $from_email = $leform->options['from-email'];
												$from_name = $form_object->replace_shortcodes($form_object->form_options['double-from-name']);
												$mail_headers = "Content-Type: text/html; charset=UTF-8\r\n";
												$mail_headers .= "From: ".(empty($from_name) ? esc_html($from_email) : esc_html($from_name))." <".esc_html($from_email).">\r\n";
												$mail_headers .= "X-Mailer: PHP/".phpversion()."\r\n";
												wp_mail($to, $subject, $message, $mail_headers);
											}
										}
									}
									$form_object->do_notifications("submit", ($payment_ok ? array('payment-amount' => $payment_data['amount'], 'payment-currency' => $payment_data['currency'], 'payment-status' => esc_html__('Unpaid', 'leform')) : array()));
									$integrations_data = $form_object->do_integrations("submit");
									if (array_key_exists('forms', $integrations_data)) $return_data['forms'] = implode('', $integrations_data['forms']);
									do_action('leform_submitted', $form_object);
								}
							}
						} else {
							$return_data = array(
								'status' => 'NEXT',
								'page' => $next_page_id
							);
						}
					} else {
						$return_data = array(
							'status' => 'ERROR',
							'errors' => $errors
						);
					}
				}
			} else {
				$return_data = array(
					'status' => 'FATAL',
					'message' => esc_html__('Requested page not found.', 'leform')
				);
			}
		} else {
			$return_data = array(
				'status' => 'FATAL',
				'message' => esc_html__('Requested form not found.', 'leform')
			);
		}
		if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
		else echo json_encode($return_data);
		exit;
	}

	function front_add_impression() {
		global $wpdb, $leform;
		$callback = '';
		if (isset($_REQUEST['callback'])) {
			header("Content-type: text/javascript");
			$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
		}
		if (array_key_exists('form-ids', $_REQUEST)) {
			$form_ids = explode(',', $_REQUEST['form-ids']);
			for ($i=0; $i<sizeof($form_ids); $i++) {
				$form_id = intval($form_ids[$i]);
				$form_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0' AND id = '".esc_sql($form_id)."'", ARRAY_A);
				if (empty($form_details)) continue;
				$datestamp = date('Ymd');
				$timestamp = date('h');
				$stats_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_stats WHERE form_id = '".esc_sql($form_id)."' AND datestamp = '".esc_sql($datestamp)."' AND timestamp = '".esc_sql($timestamp)."'", ARRAY_A);
				if (!empty($stats_details)) {
					$wpdb->query("UPDATE ".$wpdb->prefix."leform_stats SET impressions = impressions + 1 WHERE id = '".esc_sql($stats_details['id'])."'");
				} else {
					$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_stats (form_id, impressions, submits, confirmed, payments, datestamp, timestamp, deleted) VALUES ('".esc_sql($form_id)."', '1', '0', '0', '0', '".esc_sql($datestamp)."', '".esc_sql($timestamp)."', '0')");
				}
			}
			$return_data = array(
				'status' => 'OK'
			);
		} else {
			$return_data = array(
				'status' => 'FATAL',
				'message' => esc_html__('Invalid request.', 'leform')
			);
		}
		if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
		else echo json_encode($return_data);
		exit;
	}

	function front_popup_load() {
		global $wpdb, $leform;
		$callback = '';
		$html = '';
		if (isset($_REQUEST['callback'])) {
			header("Content-type: text/javascript");
			$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
		}

		if ($leform->options['fa-enable'] == 'on') $fa_prefix = '';
		else $fa_prefix = 'leform-';
		
		if (array_key_exists('form-id', $_REQUEST)) {
			if (!class_exists("leform_form")) include_once(dirname(__FILE__).'/core-form.php');
			$form_object = new leform_form(intval($_REQUEST['form-id']));
			if (!empty($form_object->id)) {
				$form = $form_object->get_form_html();
				if (is_array($form) && array_key_exists('style', $form) && array_key_exists('html', $form)) {
					if (!empty($form_object->form_options['max-width-value'])) $max_width = $form_object->form_options['max-width-value'].$form_object->form_options['max-width-unit'];
					else $max_width = '800px';
					$html = '<div class="leform-popup leform-container" id="leform-popup-'.esc_html($form_object->id).'" data-width="'.esc_html($max_width).'" onclick="event.stopPropagation();" style="max-width:'.esc_html($max_width).'"><span class="leform-popup-close" onclick="leform_popup_active_close();"><i class="leform-if leform-if-times"></i></span>'.$form['html'].'</div>';
					if (array_key_exists('form-style', $_REQUEST) && $_REQUEST['form-style'] == 'off') $return_data = array('status' => 'OK', 'html' => $html);
					else $return_data = array('status' => 'OK', 'html' => $form['style'].$html);
				} else {
					$return_data = array('status' => 'ERROR');
				}
			} else {
				$return_data = array('status' => 'ERROR');
			}
		} else {
			$return_data = array('status' => 'ERROR');
		}
		if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
		else echo json_encode($return_data);
		exit;
	}

	function front_upload() {
		global $leform, $wpdb;
		if (array_key_exists('upload-id', $_REQUEST) && array_key_exists('form-id', $_REQUEST) && array_key_exists('element-id', $_REQUEST)) {
			$upload_id = preg_replace('/[^a-zA-Z0-9-]/', '', $_REQUEST['upload-id']);
			if (!empty($upload_id)) {
				if (!class_exists("leform_form")) include_once(dirname(__FILE__).'/core-form.php');
				$form_object = new leform_form(intval($_REQUEST['form-id']));
				if (!empty($form_object->id)) {
					$element_idx = false;
					for ($i=0; $i<sizeof($form_object->form_elements); $i++) {
						if ($form_object->form_elements[$i]['id'] == $_REQUEST['element-id'] && $form_object->form_elements[$i]['type'] == 'file') {
							$element_idx = $i;
						}
					}
					if ($element_idx !== false) {
						if (array_key_exists('files', $_FILES) && sizeof($_FILES['files']) > 0 && sizeof($_FILES['files']['name']) > 0) {
							
							$allowed_extensions_raw = explode(',', $form_object->form_elements[$element_idx]['allowed-extensions']);
							$allowed_extensions = array();
							foreach ($allowed_extensions_raw as $extension) {
								$extension = trim(trim($extension), '.');
								if (!empty($extension)) $allowed_extensions[] = strtolower($extension);
							}
						
							$upload_dir = wp_upload_dir();
							wp_mkdir_p($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/'.$form_object->id);
							if (!file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/'.$form_object->id.'/.htaccess')) {
								file_put_contents($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/'.$form_object->id.'/.htaccess', 'deny from all');
							}
							foreach ($_FILES["files"]["error"] as $key => $error) {
								if ($error == UPLOAD_ERR_OK) {
									$filename_original = basename($_FILES["files"]["name"][$key]);
									$upload_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_uploads WHERE deleted = '0' AND upload_id = '".esc_sql($upload_id)."' AND filename_original = '".esc_sql($filename_original)."'", ARRAY_A);
									if (empty($upload_details)) {
										$ext = pathinfo($filename_original, PATHINFO_EXTENSION);
										$ext = strtolower($ext);
										$max_size = intval($form_object->form_elements[$element_idx]['max-size'])*1024*1024;
										if ((!empty($allowed_extensions) && !in_array($ext, $allowed_extensions)) || substr($ext, 0, 3) == "php") {
											$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_uploads (record_id, form_id, element_id, upload_id, str_id, status, message, filename, filename_original, created, deleted) VALUES ('0', '".esc_sql($form_object->id)."', '0', '".esc_sql($upload_id)."', '', '".esc_sql(LEFORM_UPLOAD_STATUS_ERROR)."', '".esc_sql($form_object->form_elements[$element_idx]['allowed-extensions-error'])."', '', '".esc_sql($filename_original)."', '".esc_sql(time())."', '0')");
										} else if ($max_size > 0 && $_FILES["files"]["size"][$key] > $max_size) {
											$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_uploads (record_id, form_id, element_id, upload_id, str_id, status, message, filename, filename_original, created, deleted) VALUES ('0', '".esc_sql($form_object->id)."', '0', '".esc_sql($upload_id)."', '', '".esc_sql(LEFORM_UPLOAD_STATUS_ERROR)."', '".esc_sql($form_object->form_elements[$element_idx]['max-size-error'])."', '', '".esc_sql($filename_original)."', '".esc_sql(time())."', '0')");
										} else {
											$filename = '_'.$leform->random_string(32).(!empty($ext) ? '.'.$ext : '');
											$moved = move_uploaded_file($_FILES["files"]["tmp_name"][$key], $upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/'.$form_object->id.'/'.$filename);
											if ($moved) {
												$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_uploads (record_id, form_id, element_id, upload_id, str_id, status, message, filename, filename_original, created, deleted) VALUES ('0', '".esc_sql($form_object->id)."', '0', '".esc_sql($upload_id)."', '', '".esc_sql(LEFORM_UPLOAD_STATUS_OK)."', '', '".esc_sql($filename)."', '".esc_sql($filename_original)."', '".esc_sql(time())."', '0')");
											} else {
												$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_uploads (record_id, form_id, element_id, upload_id, str_id, status, message, filename, filename_original, created, deleted) VALUES ('0', '".esc_sql($form_object->id)."', '0', '".esc_sql($upload_id)."', '', '".esc_sql(LEFORM_UPLOAD_STATUS_ERROR)."', '".esc_sql(esc_html__('Can not move uploaded file.', 'leform'))."', '".esc_sql($filename)."', '".esc_sql($filename_original)."', '".esc_sql(time())."', '0')");
											}
										}
									}
								} else {
									$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_uploads (record_id, form_id, element_id, upload_id, str_id, status, message, filename, filename_original, created, deleted) VALUES ('0', '".esc_sql($form_object->id)."', '0', '".esc_sql($upload_id)."', '', '".esc_sql(LEFORM_UPLOAD_STATUS_ERROR)."', '".esc_sql(esc_html__('Can not process uploaded file.', 'leform'))."', '', '".esc_sql($filename_original)."', '".esc_sql(time())."', '0')");
								}
							}						
						}
					}
				}
			}
		}
		echo 'Upload Completed!';
		exit;
	}
	
	function front_upload_progress() {
		global $wpdb, $leform;
		$callback = '';
		$html = '';
		if (isset($_REQUEST['callback'])) {
			header("Content-type: text/javascript");
			$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
		}
		if (array_key_exists('upload-id', $_REQUEST)) {
			$upload_id = preg_replace('/[^a-zA-Z0-9-]/', '', $_REQUEST['upload-id']);
			if (!empty($upload_id)) {
				$uploads = $wpdb->get_results("SELECT * FROM ".$wpdb->prefix."leform_uploads WHERE deleted = '0' AND upload_id = '".esc_sql($upload_id)."' AND str_id = '' AND status != '".esc_sql(LEFORM_UPLOAD_STATUS_DELETED)."'", ARRAY_A);
				if (!empty($uploads)) {
					$return_data = array('status' => 'OK', 'result' => array());
					foreach ($uploads as $upload_details) {
						switch($upload_details['status']) {
							case LEFORM_UPLOAD_STATUS_ERROR:
								$file_data = array(
									'status' => 'ERROR',
									'message' => $upload_details['message'],
									'name' => $upload_details['filename_original']
								);
								$wpdb->query("DELETE FROM ".$wpdb->prefix."leform_uploads WHERE id = '".esc_sql($upload_details['id'])."'");
								break;
							default:
								$str_id = $leform->random_string(16);
								$wpdb->query("UPDATE ".$wpdb->prefix."leform_uploads SET str_id='".esc_sql($str_id)."' WHERE id = '".esc_sql($upload_details['id'])."'");
								$file_data = array(
									'status' => 'OK',
									'uid' => $str_id,
									'name' => $upload_details['filename_original']
								);
								
								break;
						}
						$return_data['result'][] = $file_data;
					}
				} else {
					if (array_key_exists('last-request', $_REQUEST)) {
						$return_data = array('status' => 'ERROR');
					} else {
						$return_data = array('status' => 'LOADING');
						$key = ini_get("session.upload_progress.prefix").$upload_id;
						if (array_key_exists($key, $_SESSION) && !empty($_SESSION[$key])) {
							foreach ($_SESSION[$key]['files'] as $file) {
								$return_data['progress'][] = array('name' => $file['name'], 'bytes_processed' => $file['bytes_processed']);
							}
						}
					}
				}
			} else {
				$return_data = array('status' => 'ERROR', 'message' => esc_html__('Invalid request.', 'leform'));
			}
		} else {
			$return_data = array('status' => 'ERROR', 'message' => esc_html__('Invalid request.', 'leform'));
		}
		if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
		else echo json_encode($return_data);
		exit;
	}
	
	function front_upload_delete() {
		global $wpdb, $leform;
		$callback = '';
		$html = '';
		if (isset($_REQUEST['callback'])) {
			header("Content-type: text/javascript");
			$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
		}
		if (array_key_exists('upload-id', $_REQUEST) && array_key_exists('name', $_REQUEST)) {
			$upload_id = preg_replace('/[^a-zA-Z0-9-]/', '', $_REQUEST['upload-id']);
			$name = stripslashes(trim($_REQUEST['name']));
			if (!empty($upload_id) && !empty($name)) {
				$upload_details = $wpdb->get_row("SELECT * FROM ".$wpdb->prefix."leform_uploads WHERE deleted = '0' AND upload_id = '".esc_sql($upload_id)."' AND filename_original = '".esc_sql($name)."'", ARRAY_A);
				if ($upload_details) {
					if ($upload_details['status'] == LEFORM_UPLOAD_STATUS_OK) {
						$wpdb->query("UPDATE ".$wpdb->prefix."leform_uploads SET status = '".esc_sql(LEFORM_UPLOAD_STATUS_DELETED)."' WHERE id = '".esc_sql($upload_details['id'])."'");
						$upload_dir = wp_upload_dir();
						if (file_exists($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/'.$upload_details['form_id'].'/'.$upload_details['filename']) && is_file($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/'.$upload_details['form_id'].'/'.$upload_details['filename'])) {
							unlink($upload_dir["basedir"].'/'.LEFORM_UPLOADS_DIR.'/uploads/'.$upload_details['form_id'].'/'.$upload_details['filename']);
						}
					}
				} else {
					$wpdb->query("INSERT INTO ".$wpdb->prefix."leform_uploads (record_id, form_id, element_id, upload_id, str_id, status, message, filename, filename_original, created, deleted) VALUES ('0', '0', '0', '".esc_sql($upload_id)."', '', '".esc_sql(LEFORM_UPLOAD_STATUS_DELETED)."', '', '', '".esc_sql($name)."', '".esc_sql(time())."', '0')");
				}
				$return_data = array('status' => 'OK');
			} else {
				$return_data = array('status' => 'ERROR', 'message' => esc_html__('Invalid request.', 'leform'));
			}
		} else {
			$return_data = array('status' => 'ERROR', 'message' => esc_html__('Invalid request.', 'leform'));
		}
		if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
		else echo json_encode($return_data);
		exit;
	}

	function front_remote_init() {
		global $wpdb, $leform;
		$callback = '';
		if (isset($_REQUEST['callback'])) {
			header("Content-type: text/javascript");
			$callback = preg_replace('/[^a-zA-Z0-9_]/', '', $_REQUEST['callback']);
		}
		if ($leform->advanced_options['minified-sources'] == 'on') $min = '.min';
		else $min = '';
		$return_data = array();
		$return_data['status'] = 'OK';
		$return_data['resources']['css'][] = $leform->plugins_url.'/css/style'.$min.'.css?ver='.LEFORM_VERSION;
		if ($leform->options['fa-enable'] == 'on') {
			if ($leform->options['fa-css-disable'] != 'on') {
				if ($leform->options['fa-solid-enable'] == 'on' && $leform->options['fa-regular-enable'] == 'on' && $leform->options['fa-brands-enable'] == 'on') $return_data['resources']['css'][] = $leform->plugins_url.'/css/fontawesome-all'.$min.'.css?ver='.LEFORM_VERSION;
				else {
					$return_data['resources']['css'][] = $leform->plugins_url.'/css/fontawesome'.$min.'.css?ver='.LEFORM_VERSION;
					if ($leform->options['fa-solid-enable'] == 'on') $return_data['resources']['css'][] = $leform->plugins_url.'/css/fontawesome-solid'.$min.'.css?ver='.LEFORM_VERSION;
					if ($leform->options['fa-regular-enable'] == 'on') $return_data['resources']['css'][] = $leform->plugins_url.'/css/fontawesome-regular'.$min.'.css?ver='.LEFORM_VERSION;
					if ($leform->options['fa-brands-enable'] == 'on') $return_data['resources']['css'][] = $leform->plugins_url.'/css/fontawesome-brands'.$min.'.css?ver='.LEFORM_VERSION;
				}
			}
		} else $return_data['resources']['css'][] = $leform->plugins_url.'/css/leform-fa'.$min.'.css?ver='.LEFORM_VERSION;
		$return_data['resources']['css'][] = $leform->plugins_url.'/css/leform-if'.$min.'.css?ver='.LEFORM_VERSION;
		if ($leform->options['airdatepicker-enable'] == 'on') {
			if ($leform->options['airdatepicker-js-disable'] != 'on') {
				$return_data['resources']['css'][] = $leform->plugins_url.'/css/airdatepicker'.$min.'.css?ver='.LEFORM_VERSION;
				$return_data['resources']['js'][] = $leform->plugins_url.'/js/airdatepicker'.$min.'.js?ver='.LEFORM_VERSION;
			}
		}
		if ($leform->options['jsep-enable'] == 'on') {
			if ($leform->options['jsep-js-disable'] != 'on') {
				$return_data['resources']['js'][] = $leform->plugins_url.'/js/jsep'.$min.'.js?ver='.LEFORM_VERSION;
			}
		}
		if ($leform->options['mask-enable'] == 'on') {
			if ($leform->options['mask-js-disable'] != 'on') {
				$return_data['resources']['js'][] = $leform->plugins_url.'/js/jquery.mask'.$min.'.js?ver='.LEFORM_VERSION;
			}
		}
		$return_data['ga-tracking'] = $leform->options['ga-tracking'];
		
		if (array_key_exists('ignore-status', $_REQUEST) && $_REQUEST['ignore-status'] == 'on') $ignore_status = true;
		else $ignore_status = false;
		
		$forms = $wpdb->get_results("SELECT * FROM ".$wpdb->prefix."leform_forms WHERE deleted = '0'".($igonre_status ? '' : " AND active = '1'"), ARRAY_A);
		$default_form_options = $leform->default_form_options();
		$return_data['overlays'] = array();
		foreach ($forms as $form_details) {
			$form_options = json_decode($form_details['options'], true);
			if (!empty($form_options) && is_array($form_options)) $form_options = array_merge($default_form_options, $form_options);
			else $form_options = $default_form_options;
			$return_data['overlays']['leform-'.$form_details['id']] = array((empty($form_options['popup-overlay-color']) ? 'rgba(0,0,0,0.7)' : $form_options['popup-overlay-color']), (empty($form_options["popup-spinner-color-color1"]) ? '#FF5722' : $form_options["popup-spinner-color-color1"]), (empty($form_options["popup-spinner-color-color2"]) ? '#FF9800' : $form_options["popup-spinner-color-color2"]), (empty($form_options["popup-spinner-color-color3"]) ? '#FFC107' : $form_options["popup-spinner-color-color3"]));
		}
		$return_data["inline-forms"] = array();
		if (array_key_exists('form-ids', $_REQUEST)) {
			$form_ids = explode(',', $_REQUEST['form-ids']);
			if (is_array($form_ids) && sizeof($form_ids) > 0) {
				include_once(dirname(__FILE__).'/core-front.php');
				foreach($form_ids as $form_id) {
					$form_id = intval($form_id);
					$return_data['inline-forms'][] = leform_front_class::shortcode_handler(array('id' => $form_id));
				}
			}
		}
		$return_data = apply_filters('leform_remote_parameters', $return_data);
		if (!empty($callback)) echo $callback.'('.json_encode($return_data).')';
		else echo json_encode($return_data);
		exit;
	}
	
}
?>